import java.util.*;

class Layer
{
    Vector neurons;
    int size;

    // for the pocket algorithm
    double p1,p2,p3;
    int Rp;
    int Rw;

    public Layer(String l,int s)
    {
	String label;
	size    = s;
	neurons = new Vector();
	for(int i=0;i<s;i++)
	    {
		label = new String(l) + String.valueOf(i);
		neurons.addElement(new Neuron(label));
	    }
	initPocket();
    }
    public Neuron getNeuron(int i)
    {
	int         j=0;
	boolean     found=false;
	Neuron      neuron=null;
	Enumeration e = neurons.elements();
	while(e.hasMoreElements())
	    {
		neuron = (Neuron)e.nextElement();
		if (i==j)
		    {
			found = true;
			break;
		    } else j++;
	    }
	if (found==false) neuron = null;
	return neuron;
    }
    public void computeOutputs(int algorithm)
    {
	Neuron neuron;
	Enumeration e = neurons.elements();
	while(e.hasMoreElements())
	    {
		neuron = (Neuron)e.nextElement();
		neuron.computeOutput(algorithm);
	    }
    }
    public void computeAdaline(Vector s)
    {
	Neuron neuron;
	Synapse synapse;
	Enumeration syn;
	Enumeration e = neurons.elements();
	Enumeration d = s.elements();
	while(e.hasMoreElements())
	    {
		neuron = (Neuron)e.nextElement();
		neuron.computeAdalineDelta(((Double)d.nextElement()).doubleValue());
		syn = neuron.inlinks.elements();
		while(syn.hasMoreElements())
		    {
			synapse = (Synapse)syn.nextElement();
			synapse.weight += neuron.learningRate *
			    synapse.from.output * neuron.delta;
			// (neuron.delta - 0.5);
		    }
	    }
    }
    public void computePerceptron(Vector s)
    {
	Neuron neuron;
	Synapse synapse;
	Enumeration syn;
	Enumeration e = neurons.elements();
	Enumeration d = s.elements();
	while(e.hasMoreElements())
	    {
		neuron = (Neuron)e.nextElement();
		neuron.computePerceptronDelta(((Double)d.nextElement()).doubleValue());
		syn = neuron.inlinks.elements();
		if (Math.abs(neuron.delta) >= 0.5) // misclassified pattern
		    while(syn.hasMoreElements())
			{
			    synapse = (Synapse)syn.nextElement();
			    synapse.weight += neuron.delta * neuron.learningRate *
				synapse.from.output;
			}
	    }
    }
    public void computePocket(Vector s) // works only for 2 in / 1 out
    {
	boolean change = false;

	Neuron neuron;
	Synapse synapse;
	Enumeration syn;
	Enumeration e = neurons.elements();
	Enumeration d = s.elements();
	while(e.hasMoreElements())
	    {
		neuron = (Neuron)e.nextElement();
		neuron.computePerceptronDelta(((Double)d.nextElement()).doubleValue());
		if (Math.abs(neuron.delta) < 0.5) // well classified pattern
		    {
			Rw++;
			if (Rw > Rp)
			    {
				syn = neuron.inlinks.elements();  // save weights
				synapse = (Synapse)syn.nextElement();
				p1 = synapse.weight;
				synapse = (Synapse)syn.nextElement();
				p2 = synapse.weight;
				synapse = (Synapse)syn.nextElement();
				p3 = synapse.weight;
				Rp = Rw;
			    }
		    }
		else
		    {
			syn = neuron.inlinks.elements();
			while(syn.hasMoreElements())
			    {
				synapse = (Synapse)syn.nextElement();
				synapse.weight += neuron.delta * 
				    neuron.learningRate * synapse.from.output;
			    }
			Rw = 0;
		    }
	    }
    }
    public void initPocket()
    {
	Rw = 0;
	Rp = 0;
	p1 = 0.0;
	p3 = 0.0;
	p2 = 0.0;
    }
    public void restorePocket()
    {
	Neuron neuron;
	Synapse synapse;
	Enumeration syn;

	Enumeration e = neurons.elements();
	neuron = (Neuron)e.nextElement();
	syn = neuron.inlinks.elements();
	synapse = (Synapse)syn.nextElement();
	synapse.weight = p1;
	synapse = (Synapse)syn.nextElement();
	synapse.weight = p2;
	synapse = (Synapse)syn.nextElement();
	synapse.weight = p3;
    }
    public void computeBackpropDeltas(Vector s) // for output neurons
    {
	Neuron neuron;
	Enumeration e = neurons.elements();
	Enumeration d = s.elements();
	while(e.hasMoreElements())
	    {
		neuron = (Neuron)e.nextElement();
		neuron.computeBackpropDelta(((Double)d.nextElement()).doubleValue());
	    }
    }
    public void computeBackpropDeltas() // for hidden neurons
    {
	Neuron neuron;
	Enumeration e = neurons.elements();
	while(e.hasMoreElements())
	    {
		neuron = (Neuron)e.nextElement();
		neuron.computeBackpropDelta();
	    }
    }
    public void computeWeights()
    {
	Neuron neuron;
	Enumeration e = neurons.elements();
	while(e.hasMoreElements())
	    {
		neuron = (Neuron)e.nextElement();
		neuron.computeWeight();
	    }
    }
    public void print()
    {
	Neuron neuron;
	Enumeration e = neurons.elements();
	while(e.hasMoreElements())
	    {
		neuron = (Neuron)e.nextElement();
		neuron.print();
	    }
    }
}
