import java.applet.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;

public class SimplePerceptronApplet extends Applet
{
    InputSpaceCanvas inputSpaceCanvas;
    Perceptron       perceptron;
    Choice           colorChoice;
    Choice           algoChoice;
    TextField        iterationsTF;
    TextField        learningRateTF;
    Label            counter, totalIterations;
    Panel            controls, parameters;
    ErrorGraph       errorGraph;
    Button           init;
    Button           learn;
    Button           clear;
    final String redItem = "1 (red)";
    final String blueItem = "0 (blue)";
    final String backpropLabel = "Backprop";
    final String adalineLabel = "Adaline";
    final String perceptronLabel = "Perceptron";
    final String pocketLabel = "Pocket";

    public SimplePerceptronApplet()
    {
	initPerceptron();
    }

    public void init()
    {
	setLayout(new BorderLayout());
	controls = new Panel();
	algoChoice = new Choice();
	algoChoice.addItem(backpropLabel);
	algoChoice.addItem(adalineLabel);
	algoChoice.addItem(perceptronLabel);
	algoChoice.addItem(pocketLabel);
	ItemListener algoChoiceListener = new ItemListener() {
		public void itemStateChanged(ItemEvent e) {
		    algoChoicePerformed(e);
		}
	    };
	algoChoice.addItemListener(algoChoiceListener);
	controls.add(algoChoice);
	init = new Button("Init");
	ActionListener initListener = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    initPerformed();
		}
	    };
	init.addActionListener(initListener);
	controls.add(init);
	learn = new Button("Learn");
	ActionListener learnListener = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    learnPerformed();
		}
	    };
	learn.addActionListener(learnListener);
	controls.add(learn);
	clear = new Button("Clear");
	ActionListener clearListener = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    clearPerformed();
		}
	    };
	clear.addActionListener(clearListener);
	controls.add(clear);
	colorChoice = new Choice();
	ItemListener choiceListener = new ItemListener() {
		public void itemStateChanged(ItemEvent e) {
		    choicePerformed(e);
		}
	    };	
	colorChoice.addItemListener(choiceListener);
	colorChoice.addItem(redItem);
	colorChoice.addItem(blueItem);
	controls.add(colorChoice);
	add("North",controls);
    
	parameters = new Panel();
	parameters.add(new Label("Learning rate:"));
	learningRateTF = new TextField(String.valueOf(Neuron.learningRate),4);
	parameters.add(learningRateTF);
	parameters.add(new Label("Iterations:"));
	iterationsTF = new TextField("10",4);
	parameters.add(iterationsTF);
	counter = new Label("0   ");
	parameters.add(counter);
	add("South",parameters);
	totalIterations = new Label ("    0");
	parameters.add(new Label ("Total It.:"));
	parameters.add (totalIterations);
	inputSpaceCanvas = new InputSpaceCanvas();
	add("Center",inputSpaceCanvas);

	errorGraph = new ErrorGraph (this);
    }

    public void initPerformed() {
	initPerceptron();
	totalIterations.setText("    0");
	for(double x1 = 0.0; x1<=1.01; x1+=0.05)
	    for(double x2 = 0.0; x2<=1.01; x2+=0.05)
		inputSpaceCanvas.setBackground(x1,x2,-100.0);
	inputSpaceCanvas.repaint();
	errorGraph.graph.startNewTrace ();
    }

    public void clearPerformed() {
	Confirm c = new Confirm(new Frame(),true,"Are you sure ?");
	c.show();
	if (Confirm.answer==Confirm.OK) {
	    for(double x1 = 0.0; x1<=1.01; x1+=0.05)
		for(double x2 = 0.0; x2<=1.01; x2+=0.05)
		    inputSpaceCanvas.setBackground(x1,x2,-100.0);
	    initPerceptron();
	    totalIterations.setText("    0");
	    inputSpaceCanvas.clearPoints();
	    errorGraph.graph.startNewTrace ();
	}
    }

    public void learnPerformed() {
	try {
	    learnPoints();
	}
	catch (NumberFormatException e) {}
    }

    public void choicePerformed(ItemEvent e) {
	if (((Choice)(e.getSource())).getSelectedItem() == redItem) {
	    inputSpaceCanvas.setValue(1);
	}
	else if (((Choice)(e.getSource())).getSelectedItem() == blueItem) {
	    inputSpaceCanvas.setValue(0);
	}
	else {}
    }

    public void algoChoicePerformed(ItemEvent e) {
	if (((Choice)(e.getSource())).getSelectedItem() == perceptronLabel) {
	    perceptron.algorithm = perceptron.PERCEPTRON;
	}
	else if (((Choice)(e.getSource())).getSelectedItem() == backpropLabel) {
	    perceptron.algorithm = perceptron.BACKPROP;
	}
	else if (((Choice)(e.getSource())).getSelectedItem() == adalineLabel) {
	    perceptron.algorithm = perceptron.ADALINE;
	}
	else if (((Choice)(e.getSource())).getSelectedItem() == pocketLabel) {
	    perceptron.algorithm = perceptron.POCKET;
	}
	else {}
    }

    public void initPerceptron()
    {
	int i;
	if (perceptron!= null) i = perceptron.algorithm;
	else i = perceptron.BACKPROP;
	perceptron = new Perceptron(2,1,i); // 2 inputs / 1 output
	perceptron.connect(0,0,1,0);
	perceptron.connect(0,1,1,0);
	perceptron.biasConnect(1,0);
    }
    public void learnPoints()
    {
	setSamples();
	// perceptron.printSamples();
	Integer iterations = Integer.valueOf(iterationsTF.getText());
	Double learningRate = Double.valueOf(learningRateTF.getText());
	Neuron.learningRate = learningRate.doubleValue();
	disableDuringLearning ();
	if (perceptron.algorithm == perceptron.POCKET) perceptron.initPocket(); 
	int max = iterations.intValue();
	for(int i = 0;i < max; i++)
	    {
		counter.setText(String.valueOf(max - i));
		counter.repaint(); // not so bad
		perceptron.learn(1);
	    }
	counter.setText("0   ");
	if (perceptron.algorithm == perceptron.POCKET) // restore the W_best 
	    perceptron.restorePocket();
	totalIterations.setText(String.valueOf((int)max
					       +getFieldAsInt(totalIterations)
					       ));
	drawSpace();
	enableDuringLearning();
	errorGraph.graph.add (iterations.intValue(), 
			      perceptron.currentError());
	errorGraph.show ();
	// perceptron.print();
    }
    public void setSamples()
    {
	Vector input;
	Vector output;
	perceptron.removeSamples();
	Enumeration e = inputSpaceCanvas.points1.elements();
	while(e.hasMoreElements())
	    {
		output = new Vector();
		output.addElement(new Double(1.0));
		input  = new Vector();
		input.addElement((Double)e.nextElement());
		input.addElement((Double)e.nextElement());
		perceptron.addSample(input,output);
	    }
	e = inputSpaceCanvas.points0.elements();
	while(e.hasMoreElements())
	    {
		output = new Vector();
		output.addElement(new Double(0.0));
		input  = new Vector();
		input.addElement((Double)e.nextElement());
		input.addElement((Double)e.nextElement());
		perceptron.addSample(input,output);
	    }
    }
    public void drawSpace()
    {
	Vector input;
	Vector output;

	for(double x1 = 0.0; x1<=1.01; x1+=0.05)
	    for(double x2 = 0.0; x2<=1.01; x2+=0.05)
		{
		    input = new Vector();
		    input.addElement(new Double(x1));
		    input.addElement(new Double(x2));
		    output = perceptron.recognize(input);
		    inputSpaceCanvas.setBackground(x1,x2,
						   ((Double)output.firstElement()).doubleValue());
		}
	inputSpaceCanvas.repaint();
    }
    /**
     * Disables the text fields and controls during training.
     */

    public void disableDuringLearning() {
	parameters.setEnabled(false);
	controls.setEnabled(false);
    }

    /**
     * Enables the text fields.
     */

    public void enableDuringLearning() {
	parameters.setEnabled(true);
	controls.setEnabled(true);
    }

    /**
     * Return the contents of a textfield as an int.
     * @param TextField t - the textfield component.
     * @return int.
     * @exception NumberFormatException.
     */

    public int getFieldAsInt(Label t) {
	try {
	    return (Integer.valueOf(t.getText())).intValue();
	}
	catch (NumberFormatException e) {
	    t.setText("    0");
	    return 0;
	}
    }
    public void graphClose () {
	errorGraph.setVisible(false);
    } 
    
    public void destroy() {
	this.errorGraph.dispose();
    }

    public void stop() {
	this.errorGraph.dispose();
    }
    
    public static void main(String[] args) {
	SimplePerceptronApplet perceptronApplet = new SimplePerceptronApplet();
	perceptronApplet.init();
	
	WindowListener windowListener = new WindowListener() {
		public void windowActivated(WindowEvent e) {}             
		public void windowClosed(WindowEvent e) {}
		public void windowClosing(WindowEvent e) {
		    System.exit(0);
		}
		public void windowDeactivated(WindowEvent e) {}
		public void windowDeiconified(WindowEvent e) {}
		public void windowIconified(WindowEvent e) {} 
		public void windowOpened(WindowEvent e) {}
	    };
	Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
	
	Frame myFrame = new Frame("Adaline, Perceptron, Backprop");
	myFrame.add(perceptronApplet);
	myFrame.addWindowListener(windowListener);
	
	myFrame.pack();
	myFrame.setLocation(Math.abs((dimension.width-myFrame.getSize().width)/2),Math.abs((dimension.height-myFrame.getSize().height)/2));
	myFrame.show();
    }

}
