import java.awt.*;

class Database {
  final int maxnp = 1024;
  final int PtSize = 5;
  int[] x = new int[maxnp];
  int[] y = new int[maxnp];
  int np;
  int xsiz, ysiz;
  Color col;
  boolean lockflag = false;

  public Database(int xSize, int ySize, Color Col) {
    xsiz = xSize;
    ysiz = ySize;
    col = Col;
    np = 0;
  }
  
  public void paint(Graphics g) {
    g.setColor(col);
    for(int i = 0; i < np; i++) {
      g.fillRect(x[i]-PtSize/2,y[i]-PtSize/2,PtSize,PtSize);
    } 
  }

  public void push(int newx, int newy) {
    if(np < maxnp) {
      x[np] = newx;
      y[np] = newy;
      np++;
    }
  }

  public void clearPoints() {
    np = 0;
  }

  public void randomPoints(int n) {
    for(int i = 0; i < n; i++)
      push((int) (xsiz * Math.random()), (int) (ysiz * Math.random()));
  }

  public void circlePoints(int n) {
    int x,y;
    double alpha,range;
    for(int i = 0; i < n; i++) {
      alpha = Math.random()*2*Math.PI;
      range = 0.6 + Math.random()*0.4;
      x = (int)(range*Math.cos(alpha)*xsiz/2)+xsiz/2;
      y = (int)(range*Math.sin(alpha)*ysiz/2)+ysiz/2;
      push(x,y);
    }
  }

  public int nPoints() {
    return np;
  }

  public int xVal(int i) {
    return x[i];
  }

  public int yVal(int i) {
    return y[i];
  }
}
