import java.awt.*;
import java.util.*;

class ColorBar extends Panel
{
    final int NUMBER_BARS = 10;
    float background[];

    ColorBar()
    {
	background = new float[NUMBER_BARS];
	float step = 1.0f/(float)NUMBER_BARS;
	for(int i=0;i<NUMBER_BARS; i++)
	    background[i] = (float) i * step;
    }

    public void paint(Graphics g)
    {
	Rectangle r = getBounds(); 
	g.setColor(Color.blue);
	g.fillRect(0,0,r.width,r.height);
	int xx=0,yy=0;
	int h;
	if (r.height > r.width)
	    h = r.height/NUMBER_BARS;
	else
	    h = r.width/NUMBER_BARS;
	int w = (r.width);
	float step = 1.0f / (float) (NUMBER_BARS);
	for(int x1 = 0; x1 < NUMBER_BARS; x1++)
	    {
		g.setColor(new Color(1-background[x1],0,background[x1]));
		if (r.height >= r.width)
		    g.fillRect(xx,yy,w,h);
		else
		    g.fillRect(yy,xx,h,w);
		yy += h;
	    }

	g.fillRect(xx,yy,w,(int)h);
	g.setColor(Color.white);
	g.drawString("0",2, r.height-5);
	if (r.height >= r.width) g.drawString("1",2, 15);
	else g.drawString ("1",r.width-5,r.height-5);

    }

    public Dimension getPreferredSize ()
    { return new Dimension(120,20); }
}
