// -======-
// ArrayDup
// -======-

// Duplicating array structures

// Author:			Pollinger Thomas
// Built:				March 2nd, 1998


public class ArrayDup {

	// Returns a copy of the array arr
	public static OdeFct[] dup(OdeFct[] arr) {
		if (arr == null) return null;
		OdeFct[] ret = new OdeFct[arr.length];
		for (int k = 0; k < arr.length; k++)
			ret[k] = (OdeFct)arr[k].clone();
		return ret;
	}

	// Returns a copy of the array arr
	public static double[] dup(double[] arr) {
		if (arr == null) return null;
		double[] ret = new double[arr.length];
		for (int k = 0; k < arr.length; k++)
			ret[k] = arr[k];
		return ret;
	}

	public static double[][] dup(double[][] arr) {
		if (arr == null) return null;
		if (arr[0] == null) return new double[arr.length][0];

		double[][] ret = new double[arr.length][arr[0].length];
		for (int j = 0; j < arr.length; j++)
			for (int k = 0; k < arr[j].length; k++)
				ret[j][k] = arr[j][k];

		return ret;
	}
}
