// -=====-
// BaseOde
// -=====-

// Numerical Methods for Orinary Differential Equations

// There are numerical methods for ODEs of the form:
// - dx/dt = f(x(t)),
// - a one dimensional scheme for dx[i]/dt = f(x(t)[i],i)

// This class is the base class for all numerical solvers.
// The functor classes that deliver the ODEs to be solved may be 
// derived from OdeFct.

// Written by Pollinger Thomas
// Built:				Feb 26th, 1998


public abstract class BaseOde implements Cloneable {

	protected OdeFct[] xv, orig_x;

	public BaseOde() {
		xv = null;
		orig_x = null;
	}

	public BaseOde(final BaseOde bo) {
		xv = bo.xv;
		orig_x = ArrayDup.dup(bo.orig_x);
	}

	public void init(OdeFct x) {
		check_swap(xv, orig_x);

		xv = new OdeFct[1];
		orig_x = new OdeFct[1];

		xv[0] = x;
		orig_x[0] = (OdeFct)x.clone();
	}

	public void init(OdeFct[] x) {
		check_swap(xv, orig_x);

		xv = x;
		orig_x = ArrayDup.dup(x);
	}

	public abstract void eval(double dt);
	public abstract void eval(OdeFct x, double dt);
	public abstract void eval(OdeFct[] x, double dt);

	public abstract Object clone();

	// Protected members
	// -----------------

	protected void swap(OdeFct[] lft, OdeFct[] rgt) {
		int k;

		for (k = 0; k < lft.length; k++)
			lft[k].swap(rgt[k]);
	}

	protected void check_swap(OdeFct[] lft, OdeFct[] rgt) {
		int k;

		if (lft == null) return;
		for (k = 0; k < lft.length; k++)
			if (lft[k] != null)
				lft[k].check_swap(rgt[k]);
	}
}

