// -=========-
// CableOdeFct
// -=========-

// This class derives from OdeFct and implements an ODE functor
// designed for cable model functors.

// Written by Pollinger Thomas
// Built:				Feb 26th, 1998



public abstract class CableOdeFct extends OdeFct {

	protected double[][] var;
	protected double[] lat_var, lat_var_left, lat_var_right;

	protected int i, nb;
	protected double clen, len;

	public CableOdeFct
	(double length, double comp_length, int nb_variables, 
	 int nb_lat_variables, OdeFctRep dyn) {
		super(nb_variables, dyn);

		i = 0;
		clen = comp_length;
		len = length;
		adapt_nb_comp();

		lat_var = new double[nb_lat_variables];
		lat_var_right = new double[nb_lat_variables];
		lat_var_left = new double[nb_lat_variables];
	}

	public CableOdeFct(final CableOdeFct cof) {
		super(cof);

		i = cof.i;
		clen = cof.clen;
		len = cof.len;
		nb = cof.nb;

		var = ArrayDup.dup(cof.var);

		lat_var = ArrayDup.dup(cof.lat_var);
		lat_var_left = ArrayDup.dup(cof.lat_var_left);
		lat_var_right = ArrayDup.dup(cof.lat_var_right);
	}

	public double get_length() {
		return len;
	}

	public double get_comp_length() {
		return clen;
	}

	public int get_nb_comp() {
		return nb;
	}

	public void set_length(double length) {
		len = length;
		adapt_nb_comp();
	}

	public void set_comp_length(double comp_length) {
		clen = comp_length;
		adapt_nb_comp();
	}

	public void set_nb_comp(int nb_comp) {
		len = clen*nb_comp;
		adapt_nb_comp();
	}

	public void swap(OdeFct x) {
		super.swap(x);
		double[][] tmp = var;
		var = ((CableOdeFct)x).var;
		((CableOdeFct)x).var = tmp;
	}

	public void check_swap(OdeFct x) {}

	public void first() {
		ong_var = 0;
		i = 0;
		init();
	}

	public boolean next() {
		if (ong_var >= nb_var - 1)
			if (i >= nb - 1) return false;
			else {
				i++;
				ong_var = 0;
				init();
				return true;
			}
		ong_var++;
		return true;
	}

	public boolean next_comp() {
		if (i >= nb - 1) return false;
		else {
			i++;
			ong_var = 0;
			init();
			return true;
		}	
	}

	public double ong() {
		if (ong_var < lat_var.length) return lat_var[ong_var];
		return var[i][ong_var];
	}

	public void set(double new_var) {
		var[i][ong_var] = new_var;
	}

	public double left(int ong_variable) {
		return var[0][ong_variable];
	}

	public double right(int ong_variable) {
		return var[nb - 1][ong_variable];
	}

	public int get_comp(double x) {
		int l;
		
		l = (int)(x/len*nb);
		if (l < 1) return -1;
		if (l >= nb) return nb - 1;
		return l;
	}

	public double get_x(int comp) {
		if (comp < 0) return 0.0;
		return (comp + 0.5)*clen;
	}

	// Protected members
	// -----------------

	protected void init() {
		int k;
		double[] vari = var[i];

		if (i == 0) {			
			for (k = 0; k < lat_var.length; k++)
				lat_var[k] = vari[k];
		} else for (k = 0; k < lat_var.length; k++) {
			lat_var_left[k] = lat_var[k];
			lat_var[k] = lat_var_right[k];
		}
		
		if (i < nb - 1) {
			double[] vari1 = var[i + 1];
			
			for (k = 0; k < lat_var_right.length; k++)
				lat_var_right[k] = vari1[k];
		}
		
		if (i == 0) 
			for (k = 0; k < lat_var_left.length; k++)
				lat_var_left[k] = left(k);
		if (i == nb - 1)
			for (k = 0; k < lat_var_right.length; k++)
				lat_var_right[k] = right(k);	
	}
	
	protected void adapt_nb_comp() {
		nb = (int)(len/clen + 0.5); 
		if (nb == 0) nb = 1;
		len = nb*clen; 
		
		var = new double[nb][nb_var];
	}
}


