// -=====-
// Display
// -=====-

// Class for displaying results on a graph

// Author:			Pollinger Thomas
// Built:				March 3rd, 1998


import java.awt.*;
import java.util.Vector;
import graph.*;


public class Display {

	class DatasetType {
		public Vector sets = new Vector();
		public boolean showing = true;
	}

	protected DynGraph2D displ;
	protected Vector sets = new Vector();
	protected Axis ax, ay;
	protected double xmin, xmax, ymin, ymax;

	// Make a new instance of a display and initialize the graph
	public Display(Color DataBackground, Color GraphBackground,
								 String xLabel, String yLabel,
								 double xmin, double xmax, double ymin, double ymax,
								 int width, int height) {
		displ = new DynGraph2D(width, height);
		displ.setDataBackground(DataBackground);
		displ.setGraphBackground(GraphBackground);
		displ.setFont(new Font("TimesRoman",Font.PLAIN,14));

		this.xmin = xmin;
		this.xmax = xmax;
		this.ymin = ymin;
		this.ymax = ymax;

		ax = displ.createAxis(Axis.BOTTOM);
		ay = displ.createAxis(Axis.LEFT);
		resize();
		ax.setTitleFont(new Font("TimesRoman",Font.PLAIN,14));
		ax.setTitleText(xLabel);
		ay.setTitleFont(new Font("TimesRoman",Font.PLAIN,14));
		ay.setTitleText(yLabel);
	}

	// Resize axes. Call this method before repainting graph.
	public void resize() {
		ax.setManualRange(true);
		ay.setManualRange(true);
		ax.minimum = xmin;
		ax.maximum = xmax;
		ay.minimum = ymin;
		ay.maximum = ymax;
	}

	// Returns instance of display.
	public DynGraph2D getDisplay() {
		return displ;
	}

	public void newXRange(double xmin, double xmax) {
		this.xmin = xmin;
		this.xmax = xmax;
		resize();
	}

	public void newYRange(double ymin, double ymax) {
		this.ymin = ymin;
		this.ymax = ymax;
		resize();
	}

	public void newRanges(double xmin, double xmax, double ymin, double ymax) {
		this.xmin = xmin;
		this.xmax = xmax;
		this.ymin = ymin;
		this.ymax = ymax;
		resize();
	}

	// Add a new data set to be plotted on the graph
	// Returns the ID of the added data set.
	public int addDataSet(Color linecolor) {
		int k, n = sets.size();
		DynDataSet set = new DynDataSet();
		DatasetType clonedSets = new DatasetType();

		set.linecolor = linecolor;
		clonedSets.sets.addElement(set);

		ax.attachDataSet(set);
		ay.attachDataSet(set);
		displ.attachDataSet(set);

		for (k = 0; k < n; k++)
			if (sets.elementAt(k) == null) {
				sets.setElementAt(clonedSets, k);
				return k;
			}

		sets.addElement(clonedSets);
		return n;
	}
	
	// Makes a clone of a data set.
	// The clone has the same ID as the original data set.
	// All operations on a data set handle belong to the all clones
	// if not mentioned otherwise.
	// If the ID of the original data set does not exist, false
	// is returned.
	public boolean cloneDataSet(int setHandle) {
		DatasetType clonedSets = (DatasetType)sets.elementAt(setHandle);
		DynDataSet set;

		set = new DynDataSet();
		set.linecolor = ((DynDataSet)clonedSets.sets.lastElement()).linecolor;
		clonedSets.sets.addElement(set);
		
		if (clonedSets.showing) {
			ax.attachDataSet(set);
			ay.attachDataSet(set);
			displ.attachDataSet(set);
		}

		return true;
	}

	// Removes all data set clones belonging to the handle.
	public void removeDataSet(int setHandle) {
		DatasetType clonedSets = (DatasetType)sets.elementAt(setHandle);
		DynDataSet set;
		int k, n = clonedSets.sets.size();

		for (k = 0; k < n; k++) {
			if (clonedSets.showing) {
				set = (DynDataSet)clonedSets.sets.elementAt(k);
				ax.detachDataSet(set);
				ay.detachDataSet(set);
				displ.detachDataSet(set);
			}
		}

		clonedSets.sets.removeAllElements();
		sets.setElementAt(null, setHandle);
	}

	// Remove all data sets.
	public void removeAll() {
		int k, n;

		n = sets.size();
		for (k = 0; k < n; k++)
			removeDataSet(k);
	}

	// Show / hide data set on graph
	// Returns false if corresponding data set not found.
	public boolean show(int setHandle) {
		DatasetType clonedSets = (DatasetType)sets.elementAt(setHandle);
		DynDataSet set;
		int k, n = clonedSets.sets.size();

		if (clonedSets.showing) return true;
		clonedSets.showing = true;

		for (k = 0; k < n; k++) {
			set = (DynDataSet)clonedSets.sets.elementAt(k);
			ax.attachDataSet(set);
			ay.attachDataSet(set);
			displ.attachDataSet(set);
		}
		return true;
	}

	public boolean hide(int setHandle) {
		DatasetType clonedSets = (DatasetType)sets.elementAt(setHandle);
		DynDataSet set;
		int k, n = clonedSets.sets.size();

		if (!clonedSets.showing) return true;
		clonedSets.showing = false;

		for (k = 0; k < n; k++) {
			set = (DynDataSet)clonedSets.sets.elementAt(k);
			ax.detachDataSet(set);
			ay.detachDataSet(set);
			displ.detachDataSet(set);
		}
		return true;
	}

	// Clear data set
	public boolean clear(int setHandle) {
		DatasetType clonedSets = (DatasetType)sets.elementAt(setHandle);
		DynDataSet set;
		int k, n = clonedSets.sets.size();

		if (n == 0) return true;

		for (k = 1; k < n; k++) {
			set = (DynDataSet)clonedSets.sets.elementAt(k);
			if (clonedSets.showing) {
				ax.detachDataSet(set);
				ay.detachDataSet(set);
				displ.detachDataSet(set);
			}
			set.deleteData();
			clonedSets.sets.setElementAt(null, k);
		}

		set = (DynDataSet)clonedSets.sets.elementAt(0);
		set.deleteData();

		clonedSets.sets.removeAllElements();
		clonedSets.sets.addElement(set);

		return true;
	}

	// Clear all data sets
	public void clearAll() {
		int k, n = sets.size();

		for (k = 0; k < n; k++)
			clear(k);
	}

	// Appends a point to the data set specified by the handle.
	// The points are added to the last data set clones belonging to the handle.
	// Returns false if data set not found.
	public boolean addPoint(int setHandle, double x, double y) {
		DatasetType clonedSets = (DatasetType)sets.elementAt(setHandle);
		DynDataSet set;
		int k = 0;
		
		if ((set = (DynDataSet)clonedSets.sets.lastElement()) == null) 
			return false;

		double[] point = new double[2];
		point[0] = x;
		point[1] = y;
		try {
			set.append(point, 1);
		} catch (Exception e) {
			System.out.println("Could not append point to graph. ");
		}
		return true;
	}
}
