// -========-
// DynDataSet
// -========-

// This class extends class DataSet in order to remember the 
// last data points appended after an update of the graphic window.

// Use this class in conjunction with class DynGraph2D in order
// to apply dynamic graphical output update.

// Author:			Pollinger Thomas
// Built:				March 4th, 1998


import java.awt.*;
import graph.*;


public class DynDataSet extends DataSet {
	
	// Protected members
	// -----------------

	// Indicates the position of the first data point that has not yet
	// been drawn into the graphical window.
	protected int posNewData = 0;

	// Members
	// -------

	// Constructors
	public DynDataSet ( ) {
		super();
	}

	public DynDataSet(int stride) throws Exception {
		super(stride);
	}

	public DynDataSet(double d[], int n) throws Exception {
		super(d, n);
	}

	public DynDataSet(double d[], int n, int s) throws Exception {
		super(d, n, s);
	}

	// Override methods that change the data sets in order to keep track of the last
	// updated data points.
	public void delete(int start, int end) {
		super.delete(start, end);
		if (length == 0) posNewData = 0;
		else if (length <= posNewData) posNewData = length - 1;
	}

	public void deleteData() {
		super.deleteData();
		posNewData = 0;
	}

	// If the whole graph is repainted, no new points remaind.
	public void draw_data(Graphics g, Rectangle bounds) {
		super.draw_data(g, bounds);
		posNewData = length;
	}

	// Draws the newly appended data and updates posNewData
	public void dynDrawData(Graphics g, Rectangle bounds) {
		Color c;

		if (posNewData == length) return;

		if (clipping) g.clipRect(bounds.x, bounds.y, 
														 bounds.width, bounds.height);
		
		c = g.getColor();
		
		if (linestyle != DataSet.NOLINE) {
			if (linecolor != null) g.setColor(linecolor);
			else g.setColor(c);
			dyn_draw_lines(g,bounds);
		}    
		
		if (marker > 0) {
			if (markercolor != null) g.setColor(markercolor);
			else g.setColor(c);
			draw_markers(g,bounds);
		}    
		
		g.setColor(c);
		posNewData = length;
	}


	// Protected members
	// -----------------

	// This method is almost the same as draw_lines but it draws only
	// the newly introduced points
	protected void dyn_draw_lines(Graphics g, Rectangle w) {
		int i;
		int j;
		boolean inside0 = false;
		boolean inside1 = false;
		double x,y;
		int x0 = 0 , y0 = 0;
		int x1 = 0 , y1 = 0;
		// Calculate the clipping rectangle
		Rectangle clip = g.getClipBounds();
		int xcmin = clip.x;
		int xcmax = clip.x + clip.width;
		int ycmin = clip.y;
		int ycmax = clip.y + clip.height;
		int fst = posNewData;

		// Is there any data to draw? Sometimes the draw command will
		// will be called before any data has been placed in the class.
		if (data == null || data.length < stride ) return;

		// Sets fst to the last drawn point
		if (fst > 0) fst -= stride;

		// Is the first point inside the drawing region ?
		if ((inside0 = inside(data[fst], data[fst + 1]))) {			
			x0 = (int)(w.x + ((data[fst]-xmin)/xrange)*w.width);
			y0 = (int)(w.y + (1.0 - (data[fst + 1]-ymin)/yrange)*w.height);
			
			if( x0 < xcmin || x0 > xcmax || 
					y0 < ycmin || y0 > ycmax)  inside0 = false;			
		}

		for(i=fst + stride; i<length; i+=stride) {
			
			// Is this point inside the drawing region?
			inside1 = inside(data[i], data[i+1]);
             
			// If one point is inside the drawing region calculate the second point
			if (inside1 || inside0) {				
				x1 = (int)(w.x + ((data[i]-xmin)/xrange)*w.width);
				y1 = (int)(w.y + (1.0 - (data[i+1]-ymin)/yrange)*w.height);
				
				if( x1 < xcmin || x1 > xcmax || 
						y1 < ycmin || y1 > ycmax)  inside1 = false;				
			}

			// If the second point is inside calculate the first point if it
			// was outside
			if (!inside0 && inside1) {				
				x0 = (int)(w.x + ((data[i-stride]-xmin)/xrange)*w.width);
				y0 = (int)(w.y + (1.0 - (data[i-stride+1]-ymin)/yrange)*w.height);				
			}

			// If either point is inside draw the segment
			if (inside0 || inside1)  {
				// System.out.println("Drawing line" + x0 + " " + y0 + " " + x1 + " " + y1);
				g.drawLine(x0,y0,x1,y1);
			}
			
			/*
			** The reason for the convolution above is to avoid calculating
			** the points over and over. Now just copy the second point to the
			** first and grab the next point
			*/
			inside0 = inside1;
			x0 = x1;
			y0 = y1;			
		}
	}
}
