// -====-
// OdeFct
// -====-

// Base functor class for numerical solver classes

// Written by Pollinger Thomas
// Built:				Feb 26th, 1998



public abstract class OdeFct implements Cloneable{

	protected int nb_var, ong_var;
	protected OdeFctRep dynamics;

	public OdeFct(int nb_variables, OdeFctRep dyn) {
		dynamics = dyn;
		nb_var = nb_variables;
		ong_var = 0;
	}

	public OdeFct(final OdeFct of) {
		dynamics = (OdeFctRep)of.dynamics.clone();
		nb_var = of.nb_var;
		ong_var = of.nb_var;
	}

	public void set_dynamics(final OdeFctRep dyn) {
		dynamics = dyn;
	}

	public void setup_dynamics() {}

	public abstract double f();

	public void init_for_ong() {}
	public void init_for_f() {}
	public void init_for_set() {}
	public void end_ong() {}
	public void end_f() {}
	public void end_set() {}

	public void swap(OdeFct x) {
		OdeFctRep tmp = dynamics;
		dynamics = x.dynamics;
		x.dynamics = tmp;
		setup_dynamics();
	}

	public abstract void check_swap(OdeFct x);
	public abstract void update_ode_state(final OdeFct x);

	public void pass_values(final OdeFct x) {}

	public int get_nb_variables() {
		return nb_var;
	}

	public int get_nb_comp() {
		return 1;
	}

	public abstract void first();
	public abstract boolean next();
	public abstract boolean next_comp();

	public abstract double ong();
	public abstract void set(double new_x);

	public abstract Object clone();

	// Protected members
	// -----------------

	protected void init() {}
}

