// -========-
// Simulation
// -========-

// This class executes the Hodgkin-Huxley axon simulation
// and updates the results in the graphs passed as parameters continually

// Author:			Pollinger Thomas
// Built:				27th Feb, 1998


import java.awt.*;



public class Simulation extends Thread {
	
	private boolean running = true;

	private HHAxon axon;
	private Notifiable toBeNotified;
	private double beg = 0.0, end, res, tnext;
	private BaseOde solver = new RungeKutta();
	private Simtime sim;

	private Display[] displays = null;
	private int[] datasetHandles = null;
	private int[] variables = null;
	private int[] compartments = null;

	public Simulation(HHAxon axon, double tend, double tdt, double tres, 
										Notifiable toBeNotified) {
		sim = new Simtime();
		sim.setTime(0.0);
		sim.setTimeStep(tdt);
		end = tend;

		res = tres;
		tnext = 0.0;

		this.axon = axon;
		this.axon.set_simtime(sim);
		this.axon.set_solver(solver);

		this.toBeNotified = toBeNotified;

		axon.set_compartment(0);
	}

	// Adds a new display graph to plot.
	public void setDisplays(Display[] ds, int[] setHandles, int[] variables, 
													int[] compartments) {
		int k, nb = 0;

		if (ds != null) {
			for (k = 0; k < ds.length; k++)
				if (ds[k] != null) nb++;

		} else {
			displays = null;
			return;
		}

		displays = new Display[nb];
		datasetHandles = new int[nb];
		this.variables = new int[nb];
		this.compartments = new int[nb];

		for (k = 0, nb = 0; k < ds.length; k++) {
			if (ds[k] != null) {
				displays[nb] = ds[k];
				datasetHandles[nb] = setHandles[k];
				this.variables[nb] = variables[k];
				this.compartments[nb] = compartments[k];
				nb++;
			}
		}
	}

	// Run the simulation
	public void run() {
		int k;
		double x, y;

		while(running && sim.getTime() <= end) {
			sim.nextStep();
			axon.new_potential();

			x = sim.getTime();
			if (Dbl.lseq(tnext,x) && displays != null) {
				tnext += res;
				for (k = 0; k < displays.length; k++) {
					y = getVariable(variables[k], compartments[k]);
					displays[k].addPoint(datasetHandles[k], x, y);
					displays[k].getDisplay().dynUpdate();
				}
			}

			yield();
		}

		toBeNotified.notifyOnEnd();
	}

	public void halt() {
		running = false;
	}

	// Protected members
	// -----------------

	protected double getVariable(int variable, int comp) {
		axon.set_compartment(comp);
		switch(variable) {
		case 0: return axon.get_v_m();
		case 1: return axon.get_i_m();
		case 2: return axon.get_i_na();
 		case 3: return axon.get_i_k();
 		case 4: return axon.get_i_l();
 		case 5: return axon.get_i_c();
 		case 6: return axon.get_n();
 		case 7: return axon.get_m();
		case 8: return axon.get_h();
		default: return 0.0;
		}
	}
}
