//  A Simple Binary Hopfield Artificial Neural Network
//  by Matt Hill, written for fun, to learn Java, ie, no guarantees
//  or stylistic endrosements.
//  Based on an a-life program by A.F. Slater (http://www.cee.hw.ac.uk/~afs/)
//

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.*;

class HopMem
{
    boolean       settling;
    int           size;
    int           weights[][];
    HopfieldApp   happ;

    public void debug(Pattern pat)
    {
	int x, y;

	for(x=0;x<pat.length;x++)
	    {
		System.out.println(x+": "+pat.pattern[x]);
	    }
	System.out.println("Weights: ");
	for (x=0;x<pat.length;x++)
	    {
		for (y=0;y<pat.length;y++)
		    {
			System.out.print(x+","+y+": "+weights[x][y]+"\t");
		    }
		System.out.println("");
	    }
    }

    public void init(Pattern pattern)
    {
	settling = false;
	size	 = pattern.length;
	weights  = new int[pattern.length][pattern.length];
    }

    public int ham(Pattern p1,Pattern p2)
    {
	int x,total=0; // Returns number of elts with different signs

	for (x=0;x<p1.length;x++)
	    {
		if (p1.pattern[x]*p2.pattern[x] <= 0) total++;
	    }
	return(total);
    }

    public Pattern iterate(Pattern pat)
    {
	Pattern  new_state;
	int           x, y;

	if (happ.changed==true)
	    {
		happ.changed = false;
		happ.overlap1[0]=0;
		happ.overlap2[0]=0;
		for(x=0;x<pat.length;x++)
		    {
			happ.overlap1[0] += happ.first_pattern.pattern[x]*pat.pattern[x];
			happ.overlap2[0] += happ.last_pattern.pattern[x]*pat.pattern[x];
		    }
		happ.overlap1[0] /= pat.length;
		happ.overlap2[0] /= pat.length;
		happ.overlap=1;
	    }
	new_state = new Pattern();
	new_state.init(pat);
	for(x=0;x<new_state.length;x++)
	    {
		for(y=0;y<new_state.length;y++)
		    { 
			new_state.pattern[x]=new_state.pattern[x]+pat.pattern[y]*weights[x][y];
		    }	
	    }
	new_state = new_state.normalize();
	happ.overlap1[happ.overlap]=0;
	happ.overlap2[happ.overlap]=0;
	for(x=0;x<new_state.length;x++)
	    {
		happ.overlap1[happ.overlap] += happ.first_pattern.pattern[x]*
		    new_state.pattern[x];
		happ.overlap2[happ.overlap] += happ.last_pattern.pattern[x]*
		    new_state.pattern[x];
	    }
	happ.overlap1[happ.overlap] /= new_state.length;
	happ.overlap2[happ.overlap] /= new_state.length;
	happ.overlap++;
	if (happ.overlap==10) happ.overlap=0;
	happ.current_pattern = new_state;
	happ.hopCanvas.repaint();
	return(new_state);	// return the new state of the net
    }

    public void impose(Pattern pat)
    {
	int x,y;

	for(x=0;x<pat.length;x++) for(y=0;y<pat.length;y++) if (x!=y)
	    weights[x][y] = weights[x][y] + pat.pattern[x]*pat.pattern[y];
    }
} // End class HopMem

public class HopfieldApp extends Applet
{  
    HopMem mem;
    Pattern current_pattern,first_pattern,last_pattern;
    int xsize, ysize;
    Color bgrnd=Color.lightGray;
    boolean erase = false;
    boolean first = true;
    boolean changed = false;
    double  overlap1[];
    double  overlap2[];
    int     overlap;
    HopCanvas hopCanvas;

    public void init()
    {
	int i;

	current_pattern = new Pattern();
	mem = new HopMem();
	String w=getParameter("wid");
	String h=getParameter("ht");
	String ps=getParameter("size");

	if((w!=null)&&(h!=null))
	    {
		xsize=Integer.parseInt(w);
		ysize=Integer.parseInt(h);
	    }
	else
	    {
		xsize=200;
		ysize=200;
	    }
	if (ps!=null) current_pattern.blocksize=Integer.parseInt(ps);
	current_pattern.init(xsize, ysize);
	mem.init(current_pattern);
	mem.happ = this;
	overlap1 = new double[10];
	overlap2 = new double[10];
	for(i=0;i<10;i++)
	    {
		overlap1[i]=0;
		overlap2[i]=0;
	    }
	overlap = 0;
	first_pattern = current_pattern.clone_it();
	last_pattern = current_pattern.clone_it();


	hopCanvas = new HopCanvas(this);
	Panel p = new Panel();
	p.setLayout(new FlowLayout());
	Button clearDisplay = new Button("Clear Display");
	ActionListener clearDisplayListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		current_pattern.init();
		changed = true;
		hopCanvas.paintRectangles();
	    }
	};
	clearDisplay.addActionListener(clearDisplayListener);
	Button randomize = new Button("Randomize");
	ActionListener randomizeListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		current_pattern.randomize();
		changed = true;
		hopCanvas.paintRectangles();
	    }
	};
	randomize.addActionListener(randomizeListener);
	Button memorize = new Button("Memorize");
	ActionListener memorizeListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		mem.impose(current_pattern);
		changed = true;
		if (first) {
		    first_pattern = current_pattern.clone_it();
		    first = false;
		}
		last_pattern = current_pattern.clone_it();
	    }
	};
	memorize.addActionListener(memorizeListener);
	Button test = new Button("Test");
	ActionListener testListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		current_pattern = mem.iterate(current_pattern);
	    }
	};
	test.addActionListener(testListener);
	Button clearMemory = new Button("Clear Memory");
	ActionListener clearMemoryListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		mem.init(current_pattern);
		first_pattern = current_pattern.clone_it();
		last_pattern = current_pattern.clone_it();
		changed = true;
	    }
	};
	clearMemory.addActionListener(clearMemoryListener);
	Button firstPattern = new Button("First Pattern");
	ActionListener firstPatternListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		current_pattern = first_pattern.clone_it();
		hopCanvas.paintRectangles();
	    }
	};
	firstPattern.addActionListener(firstPatternListener);
	Button lastPattern = new Button("Last Pattern");
	ActionListener lastPatternListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		current_pattern = last_pattern.clone_it();
		hopCanvas.paintRectangles();
	    }
	};
	lastPattern.addActionListener(lastPatternListener);
	p.add(clearDisplay);
	p.add(randomize);
	p.add(memorize);
	p.add(test);
	p.add(clearMemory);
	p.add(firstPattern);
	p.add(lastPattern);
    
	add("Top",p);
	add("Center",hopCanvas);
    }   
}

class HopCanvas extends Canvas implements MouseListener, MouseMotionListener
{
    HopfieldApp parent;

    public HopCanvas(HopfieldApp a) {
	parent = a;
	setSize(680,200);
	this.addMouseListener(this);
	this.addMouseMotionListener(this);
    }
    public void paintRectangles()
    {
	Graphics g = getGraphics();
	Pattern current_pattern = parent.current_pattern;
	int xsize, ysize;
	int loc,xpos,ypos,i;

	xsize = parent.xsize;
	ysize = parent.ysize;

	setBackground(Color.white);
	for (loc=0;loc<parent.current_pattern.length;loc++) {
	    ypos = (int)(loc/(xsize/current_pattern.blocksize)) *
		current_pattern.blocksize;
	    xpos = (loc % (xsize/current_pattern.blocksize)) *
		current_pattern.blocksize;
	    if (current_pattern.pattern[loc] > 0) g.setColor(Color.red);
	    else g.setColor(Color.blue);
	    g.fillRect(xpos+1,ypos+1,current_pattern.blocksize-2,
		       current_pattern.blocksize-2);
	}

    }
    public void paintGraph()
    {
	Graphics g = getGraphics();
	int i;

	Pattern current_pattern = parent.current_pattern;
	int xsize, ysize;
	double  overlap1[];
	double  overlap2[];
	int     overlap;

	xsize = parent.xsize;
	ysize = parent.ysize;

	overlap1 = parent.overlap1;
	overlap2 = parent.overlap2;
	overlap  = parent.overlap;

	setBackground(Color.white);
	g.setColor(Color.black);
	g.drawRect(0,0,xsize-1,ysize-1);           // frames
	g.drawLine(xsize+20,10,xsize+20,ysize-20); // axis
	g.drawLine(xsize+20,10,xsize+15,20);
	g.drawLine(xsize+20,10,xsize+25,20);
	g.drawLine(xsize+18,ysize-100,xsize+380,ysize-100);
	g.drawLine(xsize+380,ysize-100,xsize+370,ysize-105);
	g.drawLine(xsize+380,ysize-100,xsize+370,ysize-95);
	g.drawString("Iteration",xsize+340,ysize-108);
	g.drawString("Overlap",xsize+28,20);
	g.drawString("0",xsize+9,ysize-96);
	g.drawString("First Pattern",xsize+322,20);
	g.drawString("Last Pattern",xsize+322,40);
	g.drawString("1",xsize+9,ysize-166);
	g.drawString("1",xsize+9,ysize-26);
	g.drawLine(xsize+18,ysize-30,xsize+22,ysize-30);
	g.drawLine(xsize+18,ysize-170,xsize+22,ysize-170);
	for(i=1;i<10;i++)
	    g.drawLine(xsize+20+(i*34),ysize-98,xsize+20+(i*34),ysize-102);
	g.setColor(Color.red);
	g.drawLine(xsize+300,16,xsize+320,16);    
	if (overlap==1)
	    g.drawRect(xsize+21,ysize-100-(int)(overlap1[0]*70),1,1);
	else for(i=0;i<overlap-1;i++)
	    g.drawLine(xsize+21+i*34,ysize-100-(int)(overlap1[i]*70),
		       xsize+21+(i+1)*34,ysize-100-(int)(overlap1[i+1]*70));
	g.setColor(Color.blue);
	g.drawLine(xsize+300,36,xsize+320,36);
	if (overlap==1)
	    g.drawRect(xsize+21,ysize-100-(int)(overlap2[0]*70),1,1);
	else for(i=0;i<overlap-1;i++)
	    g.drawLine(xsize+21+i*34,ysize-100-(int)(overlap2[i]*70),
		       xsize+21+(i+1)*34,ysize-100-(int)(overlap2[i+1]*70));
    }

    public void paint(Graphics g) {
	paintRectangles();
	paintGraph();
    }         
    
    public void mouseClicked(MouseEvent e) {
	int xsize = parent.xsize;
	int ysize = parent.ysize;
	int x = e.getX();
	int y = e.getY();
	
	Pattern current_pattern = parent.current_pattern;
	
	int click_loc = (int)((x/current_pattern.blocksize) + 
			      ((int)(y/current_pattern.blocksize) *
			       (int)(xsize/current_pattern.blocksize)));
	if ((x<xsize)&&(y<ysize))
	    {
		current_pattern.toggle(click_loc);
		Graphics hop_graphics = getGraphics();
		if (current_pattern.pattern[click_loc] > 0)
		    {
			parent.erase = false;
			hop_graphics.setColor(Color.red);
		    }
		else
		    {
			parent.erase = true;
			hop_graphics.setColor(Color.blue);
		    }
		hop_graphics.fillRect(x-(x % current_pattern.blocksize)+1,
				      y-(y%current_pattern.blocksize)+1,
				      current_pattern.blocksize-2,
				      current_pattern.blocksize-2);
		parent.changed = true;
	    }
    }
    
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}  
    
    public void mouseDragged(MouseEvent e) {
	int xsize = parent.xsize;
	int ysize = parent.ysize;
	int x = e.getX();
	int y = e.getY();
	Pattern current_pattern = parent.current_pattern;
	boolean erase = parent.erase;
	
	int click_loc = (int)((x/current_pattern.blocksize) + 
			      ((int)(y/current_pattern.blocksize) *
			       (int)(xsize/current_pattern.blocksize)));
	if ((x<xsize)&&(y<ysize))
	    {
		Graphics hop_graphics = getGraphics();
		if (erase)
		    {
			if (current_pattern.pattern[click_loc] > 0)
			    current_pattern.toggle(click_loc);
			hop_graphics.setColor(Color.blue);
		    }
		else
		    {
			if (current_pattern.pattern[click_loc] < 0)
			    current_pattern.toggle(click_loc);
			hop_graphics.setColor(Color.red);
		    }
		hop_graphics.fillRect(x-(x % current_pattern.blocksize)+1,
				      y-(y%current_pattern.blocksize)+1,
				      current_pattern.blocksize-2,
				      current_pattern.blocksize-2);
		parent.changed = true;
	    }
    }
    public void mouseMoved(MouseEvent e) {}

}
