import java.applet.*;
import java.awt.*;
import java.lang.*;

class Pattern
{
  int length,blocksize,xsize,ysize;
  int pattern[];

  public Pattern clone_it()
  {
    Pattern tmp = new Pattern();
    int x;
    tmp.pattern = new int[this.length];

    for(x=0;x<this.length;x++)
    {
      tmp.pattern[x] = this.pattern[x];
    }
    tmp.length = this.length;
    tmp.blocksize = this.blocksize;
    tmp.xsize = this.xsize;
    tmp.ysize = this.ysize;

    return(tmp);
  }

  public void init()
  {
    int x;

    for(x=0;x<length;x++)
    {
      this.pattern[x] = -1;
    }
  }

  public void init(Pattern pat)
  {
    this.length = pat.length;
    this.blocksize = pat.blocksize;
    pattern = new int[length];
    this.init();
  }

  public void init(int xs, int ys)
  {
    xsize   = xs/blocksize;
    ysize   = ys/blocksize;
    length  = (int)(xs/blocksize) * (int)(ys/blocksize);
    pattern = new int[length];
    this.init();
  }

  public void toggle(int loc)
  {
    if (loc<length) pattern[loc] = pattern[loc] * -1;
  }

  public Pattern normalize()
  {
    int x;

    for(x=0;x<this.length;x++)
    {
      if (this.pattern[x] != 0)
      {
	this.pattern[x] = (int)(this.pattern[x]/Math.abs(this.pattern[x]));
      }
    }
    return(this);
  }

  public void randomize()
  {
    int x;
    int y;

    for(x=0;x<length;x++)
    {
      pattern[x] = (int)(2*Math.round(Math.random())-1);
    }
  }
}
