import java.awt.*;
import java.util.*;
import java.awt.event.*;

//Modified by Sebastien Baehni in order to support further jvm
//(some of the methods were deprecated)
public class InputSpaceCanvas extends Canvas implements MouseListener
{
    final int BACKGROUND_SIZE = 21;
    float background[][];
    Vector points1;
    Vector points0;
    int value;

    InputSpaceCanvas()
    {
	points1 = new Vector();
	points0 = new Vector();
	value = 1;
	background = new float[BACKGROUND_SIZE][BACKGROUND_SIZE];
	for(int i=0;i<BACKGROUND_SIZE; i++)
	    for(int j=0;j<BACKGROUND_SIZE; j++)
		background[i][j] = -100;
	this.setSize(550,400);
	this.addMouseListener(this);
    }
    public void paint(Graphics g)
    {	
	Rectangle r = getBounds(); 
	g.setColor(Color.white);
	g.fillRect(0,0,r.width,r.height);
	int v,xx,yy;
	int h = (r.height - 50)/BACKGROUND_SIZE;
	int w = (r.width - 50)/BACKGROUND_SIZE;

	for(int x1 = 0; x1 < BACKGROUND_SIZE; x1++)
	    for(int x2 = 0; x2 < BACKGROUND_SIZE; x2++)
		{
		    xx = x1*r.width*3/(4*(BACKGROUND_SIZE-1)) + 20 - w/2;
		    yy = r.height - x2*r.height*3/(4*(BACKGROUND_SIZE-1)) - 21 - h/2;
		    if (background[x1][x2]!=-100)
			{
			    g.setColor(new Color(background[x1][x2],0,1-background[x1][x2]));
			    g.fillRect(xx,yy,w,h);
			    if (background[x1][x2] > 0.5) g.setColor(Color.red);
			    else g.setColor(Color.blue);
			    g.fillRect(xx+w/3,yy+h/3,w/3,h/3);
			}
		}
	g.setColor(Color.black);
	g.drawLine(5,r.height-20,r.width-5,r.height-20);
	g.drawLine(20,r.height-5,20,5);
	g.drawLine(r.width-5,r.height-20,r.width-10,r.height-17);
	g.drawLine(r.width-5,r.height-20,r.width-10,r.height-23);
	g.drawLine(20,5,17,10);
	g.drawLine(20,5,23,10);
	g.drawString("x1",r.width-25,r.height-5);
	g.drawString("x2",3,25);
	g.drawLine(20+3*r.width/4,r.height-25,20+3*r.width/4,r.height-15);
	g.drawLine(15,r.height/4-20,25,r.height/4-20);
	g.drawString("1",3,r.height/4-16);
	g.drawString("1",22+3*r.width/4,r.height-5);
	g.drawString("0",8,r.height-5);
	Enumeration e = points1.elements();
	Double X;
	Double Y;
	while (e.hasMoreElements())
	    {
		X = (Double)e.nextElement();
		Y = (Double)e.nextElement();
		drawPoint(1,X,Y);
	    }
	e = points0.elements();
	while (e.hasMoreElements())
	    {
		X = (Double)e.nextElement();
		Y = (Double)e.nextElement();
		drawPoint(0,X,Y);
	    }
    }

    // Implementation of the mouselistener ...
     public void mouseClicked(MouseEvent e) {
	Rectangle r = getBounds();
	Double X = new Double((float)(e.getX()-20) / (float)(3*r.width/4));
	Double Y = new Double((float)(r.height-20-e.getY()) / (float)(3*r.height/4));
	switch(value)
	    {
	    case 1:
		points1.addElement(X);
		points1.addElement(Y);
		break;
	    case 0:
		points0.addElement(X);
		points0.addElement(Y);
		break;
	    }
	drawPoint(value,X,Y);
    }
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
  
    public void drawPoint(int v,Double X,Double Y)
    {
	Graphics g = getGraphics();
	Rectangle r = getBounds();

	int x = 20 + (int)(X.floatValue()*3*r.width/4);
	int y = r.height - 20 - (int)(Y.floatValue()*3*r.height/4);
	if (v==1) g.setColor(Color.red); else g.setColor(Color.blue);
	g.fillArc(x-3,y-3,7,7,0,360);
	g.setColor(Color.white);
	g.drawArc(x-3,y-3,7,7,0,360);
    }
    public void clearPoints()
    {
	points1.removeAllElements();
	points0.removeAllElements();
	repaint();
    }
    public void setValue(int v)
    {
	value = v;
    }
    public void setBackground(double x1, double x2, double v)
    {
	int x = (int)(x1*(BACKGROUND_SIZE-1)+0.01);
	int y = (int)(x2*(BACKGROUND_SIZE-1)+0.01);
	if (v > 1.0) v = 1.0;
	else if ((v < 0.0)&&(v != -100.0)) v = 0.0;
	background[x][y]=(float)v;
    }
}
