import java.awt.*;
import java.util.*;
import java.awt.event.*;

//Modified by Sebastien Baehni in order to support further jvm
//(some of the methods were deprecated)
public class InputSpaceCanvas extends Canvas implements MouseListener
{
  final int BACKGROUND_SIZE = 20;
  float background[][];
  Vector points1;
  Vector points0;
  int value;

  InputSpaceCanvas()
  {
    points1 = new Vector();
    points0 = new Vector();
    value = 1;
    background = new float[BACKGROUND_SIZE][BACKGROUND_SIZE];
    for(int i=0;i<BACKGROUND_SIZE; i++)
     for(int j=0;j<BACKGROUND_SIZE; j++)
      background[i][j] = -100;
    this.setSize(550,400);
    this.addMouseListener(this);
    
  }
  public void paint(Graphics g)
  {
    Rectangle r = getBounds(); // should be getBounds(); in jdk-1.1.4
    g.setColor(Color.white);
    g.fillRect(0,0,r.width,r.height);
    int v,xx,yy;
    int h = (r.height*9/10)/BACKGROUND_SIZE;
    int w = (r.width*9/10)/BACKGROUND_SIZE;

    for(int x1 = 0; x1 < BACKGROUND_SIZE; x1++)
     for(int x2 = 0; x2 < BACKGROUND_SIZE; x2++)
     {
       xx = r.width/10+x1*w-w/2;
       yy = r.height*9/10-x2*h-h/2;
       float c = background[x1][x2];
       if (c!=-100)
       {
	 c = (c+1)/2;
         g.setColor(new Color(c,0,1-c));
         g.fillRect(xx,yy,w,h);
         if (c > 0.5) g.setColor(Color.red);
         else g.setColor(Color.blue);
         g.fillRect(xx+w/3,yy+h/3,w/3,h/3);
       }
     }
    g.setColor(Color.black);
    g.drawLine(5,r.height/2,r.width-5,r.height/2);
    g.drawLine(r.width/2,r.height-5,r.width/2,5);
    g.drawLine(r.width-5,r.height/2,r.width-10,r.height/2-3);
    g.drawLine(r.width-5,r.height/2,r.width-10,r.height/2+3);
    g.drawLine(r.width/2-3,10,r.width/2,5);
    g.drawLine(r.width/2+3,10,r.width/2,5);
    g.drawString("x1",r.width-25,r.height/2+15);
    g.drawString("x2",r.width/2-16,25);
    g.drawLine(r.width*9/10,r.height/2-5,r.width*9/10,r.height/2+5);
    g.drawLine(r.width/2-5,r.height/10,r.width/2+5,r.height/10);
    g.drawLine(r.width/10,r.height/2-5,r.width/10,r.height/2+5);
    g.drawLine(r.width/2-5,r.height*9/10,r.width/2+5,r.height*9/10);
    g.drawString("1",r.width/2-15,r.height/10);
    g.drawString("1",r.width*9/10,r.height/2+20);
    g.drawString("-1",r.width/2-15-5,r.height*9/10+10);
    g.drawString("-1",r.width/10-10,r.height/2+20);
    g.drawString("0",r.width/2+5,r.height/2-5);
    Enumeration e = points1.elements();
    Double X;
    Double Y;
    while (e.hasMoreElements())
    {
      X = (Double)e.nextElement();
      Y = (Double)e.nextElement();
      drawPoint(1,X,Y);
    }
    e = points0.elements();
    while (e.hasMoreElements())
    {
      X = (Double)e.nextElement();
      Y = (Double)e.nextElement();
      drawPoint(-1,X,Y);
    }
  }

    // Implementation of the mouselistener ...
    public void mouseClicked(MouseEvent e) {
	Rectangle r = getBounds();
	Double X = new Double((float)(e.getX() - r.width/2)*20.0 / (float)(8*r.width));
	Double Y = new Double((float)(r.height/2 -e.getY())*20.0 / (float)(8*r.height));
	switch(value)
	    {
	    case 1:
		points1.addElement(X);
		points1.addElement(Y);
		break;
	    case -1:
		points0.addElement(X);
		points0.addElement(Y);
		break;
	    }
	drawPoint(value,X,Y);
    }
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
 
    public void drawPoint(int v,Double X,Double Y)
    {
	Graphics g = getGraphics();
	Rectangle r = getBounds();
	
	int x = r.width/2  + (int)(X.floatValue()*8*r.width/20);
	int y = r.height/2 - (int)(Y.floatValue()*8*r.height/20);
	if (v==1) g.setColor(Color.red); else g.setColor(Color.blue);
	g.fillArc(x-3,y-3,7,7,0,360);
	g.setColor(Color.white);
	g.drawArc(x-3,y-3,7,7,0,360);
    }
    public void clearPoints()
    {
	points1.removeAllElements();
	points0.removeAllElements();
	repaint();
    }
    public void setValue(int v)
    {
	value = v;
    }
    public void setBackground(double x1, double x2, double v)
    {
	int x = (int)((x1+1.0)/2.0*(BACKGROUND_SIZE-1));
	int y = (int)((x2+1.0)/2.0*(BACKGROUND_SIZE-1));
	if (v > 1.0) v = 1.0;
	else if ((v < -1.0)&&(v != -100.0)) v = -1.0;
	background[x][y]=(float)v;
    }
}
