/*
 * @(#)Model3D.java
 * Copyright (c) 1994-1996 Sun Microsystems, Inc. All Rights Reserved.
 * @author  Fred Corbett
 * @version February 4, 1997
 */

abstract class Model3D extends Object {

  /**********************/
  /* Instance Variables */
  /**********************/

  /**
   * Array of real model vertices.
   */

  float vert[];

  /**
   * Array of transformed vertices.
   */

  int tvert[];

  /**
   * Number of vertices.
   */

  int nvert;

  /**
   * Maxmimum number of vertices.
   */

  int maxvert;

  /**
   * Flag indicating model has been transformed from real to screen
   * coordinate systems.
   */

  boolean transformed;

  /**
   * 3D matrix for transformations.
   */

  Matrix3D mat;

  /**
   * Bounding real coordinates for model.
   */

  float xmin, xmax, ymin, ymax, zmin, zmax;


  /******************/
  /* Public Methods */
  /******************/

  /**
   * Transform all the points in this model.
   */

  public void transform() {
    if (transformed || nvert <= 0)
      return;
    if (tvert == null || tvert.length < nvert * 3)
      tvert = new int[nvert * 3];
    mat.transform(vert, tvert, nvert);
    transformed = true;
  }

  /**
   * Find the bounding box of this model.
   */

  public void findBB() {
    if (nvert <= 0)
      return;
    float v[] = vert;
    float xmin = v[0], xmax = xmin;
    float ymin = v[1], ymax = ymin;
    float zmin = v[2], zmax = zmin;
    for (int i = nvert * 3; (i -= 3) > 0;) {
      float x = v[i];
      if (x < xmin)
        xmin = x;
      if (x > xmax)
        xmax = x;
      float y = v[i + 1];
      if (y < ymin)
        ymin = y;
      if (y > ymax)
        ymax = y;
      float z = v[i + 2];
      if (z < zmin)
        zmin = z;
      if (z > zmax)
        zmax = z;
    }
    this.xmax = xmax;
    this.xmin = xmin;
    this.ymax = ymax;
    this.ymin = ymin;
    this.zmax = zmax;
    this.zmin = zmin;
  }
}