import java.awt.*;
import java.awt.event.*;
import java.util.*;

class FunctionCanvas extends Canvas implements MouseListener, MouseMotionListener
{
    Vector input;
    Vector output;
    int function;
    int n_in,n_out;
    double delay,delta;
    double startx;
    Perceptron perceptron;

    // function
    final static public int NONE    = 0;
    final static public int SINUS   = 1;
    final static public int COSINUS = 2;
    final static public int COMPLEX = 3;
    final static public int CHAOS   = 4;
    double Ikeda[]; // for Ikeda chaotic function

    FunctionCanvas()
    {
	input  = new Vector();
	output = new Vector();
	function = COSINUS;
	startx   = 0.0;
	initIkeda();
	perceptron = null;
	this.addMouseListener(this);
	this.addMouseMotionListener(this);
    }
    public void setPerceptron(Perceptron p) {
	perceptron = p;
    }
    void initIkeda()
    {
	int i;
	double x1,x2,theta;

	x1 = 0.0;
	x2 = 0.0;
	Ikeda = new double[201];
	for(i=0;i<=200;i++) {
	    theta = 0.4 - 6.0/(1+x1*x1+x2*x2);
	    x1 = 1.0 + 0.7 * (x1 * Math.cos(theta) - x2 * Math.sin(theta));
	    x2 =       0.7 * (x1 * Math.sin(theta) + x2 * Math.sin(theta));
	    Ikeda[i] = x1 - 0.2;
	}
    }
    public void paint(Graphics g)
    {
	Rectangle r = getBounds();
	g.setColor(Color.white);
	g.fillRect(0,0,r.width,r.height);

	g.setColor(Color.black);
	g.drawLine(5,r.height-20,r.width-5,r.height-20);
	g.drawLine(20,r.height-5,20,5);
	g.drawLine(r.width-5,r.height-20,r.width-10,r.height-17);
	g.drawLine(r.width-5,r.height-20,r.width-10,r.height-23);
	g.drawLine(20,5,17,10);
	g.drawLine(20,5,23,10);
	g.drawString("x",r.width-25,r.height-5);
	g.drawString("y",3,25);
	g.drawLine(20+3*r.width/4,r.height-25,20+3*r.width/4,r.height-15);
	g.drawLine(20+3*r.width/8,r.height-25,20+3*r.width/8,r.height-15);
	g.drawLine(15,r.height/4-20,25,r.height/4-20);
	g.drawString("1",3,r.height/4-16);
	g.drawString("1",22+3*r.width/8,r.height-5);
	g.drawString("2",22+3*r.width/4,r.height-5);
	g.drawString("0",8,r.height-5);

	// draw function
	double x,y;
	int x1,y1,x2,y2;

	g.setColor(Color.magenta);
	y = func(0.0);
	for(x = 0; x<2.0; x+=0.01) {
	    x1 = 20 + (int)(x*3*r.width/8);
	    x2 = 20 + (int)((x+0.01)*3*r.width/8);
	    y1 = r.height - 20 - (int)(y*3*r.height/4);
	    y = func(x+0.01);
	    y2 = r.height - 20 - (int)(y*3*r.height/4);
	    g.drawLine(x1,y1,x2,y2);
	}

	Double X;
	Double Y;
	Enumeration e;
	e = input.elements();
	while (e.hasMoreElements())
	    {
		X = (Double)e.nextElement();
		Y = (Double)e.nextElement();
		drawPoint(0,X,Y); // 0 for input
	    }
	e = output.elements();
	while (e.hasMoreElements())
	    {
		X = (Double)e.nextElement();
		Y = (Double)e.nextElement();
		drawPoint(1,X,Y); // 1 for output
	    }
    }
    public void drawPoint(int v,Double X,Double Y)
    {
	Graphics g = getGraphics();
	Rectangle r = getBounds();

	int x = 20 + (int)(X.floatValue()*3*r.width/8);
	int y = r.height - 20 - (int)(Y.floatValue()*3*r.height/4);
	if (v==1) g.setColor(Color.red); else g.setColor(Color.blue);
	g.fillArc(x-3,y-3,7,7,0,360);
	g.setColor(Color.white);
	g.drawArc(x-3,y-3,7,7,0,360);
    }

    public void mouseClicked(MouseEvent e) {
	mouseHandle(e.getX(),e.getY());
    }
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}  
    
    public void mouseDragged(MouseEvent e) {
	mouseHandle(e.getX(),e.getY());
    }
    public void mouseMoved(MouseEvent e) {}
 

    public void mouseHandle(int x,int y)
    {
	Rectangle r = getBounds();
	startx = (double)(x-20) / (double)(3*r.width/8);
	setPoints();
	repaint();
    }
    public void clearPoints()
    {
	input.removeAllElements();
	output.removeAllElements();
	repaint();
    }
    public void setFunction(int f)
    {
	function = f;
    }
    public void setPoints()
    {
	int i;
	double length,x;
	Vector iS,oS;
	Enumeration e=null;

	iS = new Vector();
	input.removeAllElements();
	output.removeAllElements();
	length = ((double)(n_in + n_out - 2)) * delta + delay;
	for(i=0;i<n_in;i++) {
	    x = startx + delta*i;
	    input.addElement(new Double(x));
	    input.addElement(new Double(func(x)));
	    iS.addElement(new Double(func(x)));
	}
	if (perceptron!=null) {
	    perceptron.initInputs(iS);
	    perceptron.propagate();
	    oS = perceptron.getOutput();
	    e = oS.elements();
	}
	for(i=0;i<n_out;i++) {
	    x = startx + delay + delta*((double)(i+n_in-1));
	    output.addElement(new Double(x));
	    if (e!=null) output.addElement((Double)e.nextElement());
	    else output.addElement(new Double(func(x)));
	}
    }
    public void setParameters(int in,int out,double dl,double dt)
    {
	n_in  = in;
	n_out = out;
	delay = dl;
	delta = dt;
    }
    public double func(double x)
    {
	double value;
	switch(function) {
	case COSINUS:
	    value = 0.5+Math.cos(x*Math.PI)/2;
	    break;
	case SINUS:
	    value = 0.5+Math.sin(x*4*Math.PI)/2;
	    break;
	case COMPLEX:
	    value = 0.5+(Math.sin(x*3*Math.PI) +
			 Math.sin(x*7*Math.PI) + 
			 Math.sin(x*8*Math.PI) + 
			 Math.sin(x*11*Math.PI))/8;
	    break;
	case CHAOS:
	    int i;
	    double dx;
	    if (x>=2.00) value = Ikeda[200];
	    else {
		i = (int)(x*100.0);
		dx = 100*x - (double)i;
		value = Ikeda[i]*(1-dx)+Ikeda[i+1]*dx;
	    }
	    break;
	default:
	    value = 0.0;
	    break;
	}
	return value;
    }
    void setSamples()
    {
	int i,j;
	Vector in,out;
	double length, start,x;

	perceptron.removeSamples();
	length = ((double)(n_in + n_out - 2)) * delta + delay;
	for(j=0;j<100;j++) {
	    in  = new Vector();
	    out = new Vector();
	    start = j*(1.0-length)/100;
	    for(i=0;i<n_in;i++) {
		x = start + delta*i;
		in.addElement(new Double(func(x)));
	    }
	    for(i=0;i<n_out;i++) {
		x = start + delay + delta*((double)(i+n_in-1));
		out.addElement(new Double(func(x)));
	    }
	    perceptron.addSample(in,out);
	}
    }
}
