import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class SimplePerceptronApplet extends Applet
{
    FunctionCanvas   functionCanvas;
    Perceptron       perceptron;
    Choice           functionChoice;
    TextField        iterationsTF;
    TextField        learningRateTF;
    TextField        momentumTF;
    TextField        hiddenTF[] = new TextField[3];
    TextField        input;
    TextField        output;
    TextField        delay;
    TextField        delta;
    Label            counter, totalIterations;
    Panel            topPanel,controls1,controls2,parameters;
    ErrorGraph       errorGraph;
    int              n_in,n_out;

    public SimplePerceptronApplet()
    {
    }

    public void init()
    {
	setLayout(new BorderLayout());
	topPanel = new Panel();
	topPanel.setLayout(new BorderLayout());
	controls1 = new Panel();
	controls2 = new Panel();
	Button init = new Button("Init");
	ActionListener initListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		initGraph();
		initPerceptron();
		functionCanvas.setPoints();
		totalIterations.setText("    0");
		functionCanvas.repaint();
		if (errorGraph!=null) errorGraph.graph.clear();
	    }
	};
	init.addActionListener(initListener);
	controls1.add("North",init);
	Button learn = new Button("Learn");
	ActionListener learnListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		learnPoints();
	    }
	};
	learn.addActionListener(learnListener);
	controls1.add("North",learn);
	functionChoice = new Choice();
	ItemListener functionChoiceListener = new ItemListener() {
	    public void itemStateChanged(ItemEvent e) {
		String item = (String)e.getItem();
		if (item.equals("Cosinus")) {
		    functionCanvas.setFunction(FunctionCanvas.COSINUS);
		    initGraph();
		    functionCanvas.setPoints();
		    functionCanvas.repaint();
		}
		else if (item.equals("Sinus")) {
		    functionCanvas.setFunction(FunctionCanvas.SINUS);
		    initGraph();
		    functionCanvas.setPoints();
		    functionCanvas.repaint();
		}
		else if (item.equals("Complex")) {
		    functionCanvas.setFunction(FunctionCanvas.COMPLEX);
		    initGraph();
		    functionCanvas.setPoints();
		    functionCanvas.repaint();
		}
		else if (item.equals("Chaos")) {
		    functionCanvas.setFunction(FunctionCanvas.CHAOS);
		    initGraph();
		    functionCanvas.setPoints();
		    functionCanvas.repaint();
		}
	    }
	};
	functionChoice.addItem("Cosinus");
	functionChoice.addItem("Sinus");
	functionChoice.addItem("Complex");
	functionChoice.addItem("Chaos");
	functionChoice.addItemListener(functionChoiceListener);
	controls1.add("North",functionChoice);
    
	controls1.add("North",new Label("H1:"));
	hiddenTF[0] = new TextField("1",3);
	controls1.add("North",hiddenTF[0]);
	controls1.add("North",new Label("H2:"));
	hiddenTF[1] = new TextField("",3);
	controls1.add("North",hiddenTF[1]);
	controls1.add("North",new Label("H3:"));
	hiddenTF[2] = new TextField("",3);
	controls1.add("North",hiddenTF[2]);

	input  = new TextField("2",3);
	output = new TextField("1",3);
	delta  = new TextField("0.2",4);
	delay  = new TextField("0.1",4);
	controls2.add("South",new Label("inputs:"));
	controls2.add("South",input);
	controls2.add("South",new Label("outputs:"));
	controls2.add("South",output);
	controls2.add("South",new Label("delta:"));
	controls2.add("South",delta);
	controls2.add("South",new Label("delay:"));
	controls2.add("South",delay);
	topPanel.add("North",controls1);
	topPanel.add("Center",controls2);
	add("North",topPanel);

	parameters = new Panel();
	parameters.add(new Label("Momentum:"));
	momentumTF = new TextField(String.valueOf(Neuron.momentum),4);
	parameters.add(momentumTF);
	parameters.add(new Label("Learning rate:"));
	learningRateTF = new TextField(String.valueOf(Neuron.learningRate),4);
	parameters.add(learningRateTF);
	parameters.add(new Label("Iterations:"));
	iterationsTF = new TextField("10",4);
	parameters.add(iterationsTF);
	counter = new Label("0   ");
	parameters.add(counter);
	add("South",parameters);
	totalIterations = new Label ("    0");
	parameters.add(new Label ("Total It.:"));
	parameters.add (totalIterations);
	functionCanvas = new FunctionCanvas();
	add("Center",functionCanvas);
	initGraph();
	initPerceptron();
	errorGraph = new ErrorGraph(this);
    }

    public void initGraph()
    {
	double dt,dl;
	String text;
	text = input.getText();
	n_in = (Integer.valueOf(text)).intValue();
	text = output.getText();
	n_out = (Integer.valueOf(text)).intValue();
	text = delta.getText();
	dt = (Double.valueOf(text)).doubleValue();
	text = delay.getText();
	dl = (Double.valueOf(text)).doubleValue();
	functionCanvas.setParameters(n_in,n_out,dl,dt);
    }
    public void initPerceptron()
    {
	int hid[] = new int[3];
	int nLayer,i,j,k;
	String text;

	perceptron = new Perceptron(n_in,n_out);
	nLayer=0;
	for(i=0;i<3;i++)
	    {
		text = hiddenTF[i].getText();
		if ("".equals(text)) hid[i]=0;
		else hid[i] = (Integer.valueOf(text)).intValue();
		if (hid[i]!=0)
		    {
			String s = "H" + String.valueOf(i) + "|";
			perceptron.addLayer(hid[i],s);
			nLayer++;
		    }
	    }
	for(j=0;j<nLayer;j++)
	    for(i=0;i<hid[j];i++) perceptron.biasConnect(j+1,i);
	perceptron.biasConnect(nLayer+1,0); // for the output

	if (nLayer==0)
	    for(i=0;i<n_in;i++) for(j=0;j<n_out;j++)
		perceptron.connect(0,i,1,j);
	else
	    {
		// connect the inputs to the first hidden layer
		for(i=0;i<hid[0];i++) for(j=0;j<n_in;j++)
		    perceptron.connect(0,j,1,i);
		// connect the hidden layers together
		for(k=0;k<nLayer-1;k++) for(i=0;i<hid[k];i++) for(j=0;j<hid[k+1];j++)
		    perceptron.connect(k+1,i,k+2,j);
		// connect the last hidden layer to the output
		for(i=0;i<hid[nLayer-1];i++) for(j=0;j<n_out;j++)
		    perceptron.connect(nLayer,i,nLayer+1,j);
	    }
	functionCanvas.setPerceptron(perceptron);
    }
    public void learnPoints()
    {
	functionCanvas.setSamples();
	Integer iterations = Integer.valueOf(iterationsTF.getText());
	Double learningRate = Double.valueOf(learningRateTF.getText());
	Neuron.learningRate = learningRate.doubleValue();
	disableDuringLearning ();
	int max = iterations.intValue();
	counter.setEnabled(true);
	for(int i = 0;i < max; i++)
	    {
		perceptron.learn(1);
		if (i%10==0)
		    {
			counter.setText(String.valueOf(max - i));
			counter.repaint(); // not so bad
			if (errorGraph==null) errorGraph = new ErrorGraph(this);
			errorGraph.graph.add(10,perceptron.currentError());
		    }
		perceptron.test();
		if (i%10==0)
		    {
			errorGraph.graph.add2(10,perceptron.currentError());
		    }
	    }
	counter.setText("0   ");
	totalIterations.setText(String.valueOf((int)max
					       +getFieldAsInt(totalIterations)
					       ));
	drawSpace();
	enableDuringLearning();
	if (errorGraph!=null) errorGraph.show();
    }
    public void setSamples()
    {
	Vector input;
	Vector output;
	perceptron.removeSamples();
    
	Enumeration e = functionCanvas.input.elements();
	while(e.hasMoreElements())
	    {
		output = new Vector();
		output.addElement(new Double(0.0));
		input  = new Vector();
		input.addElement((Double)e.nextElement());
		input.addElement((Double)e.nextElement());
		perceptron.addSample(input,output);
	    }
	e = functionCanvas.output.elements();
	while(e.hasMoreElements())
	    {
		output = new Vector();
		output.addElement(new Double(1.0));
		input  = new Vector();
		input.addElement((Double)e.nextElement());
		input.addElement((Double)e.nextElement());
		perceptron.addSample(input,output);
	    }
    }
    public void drawSpace()
    {
	functionCanvas.repaint();
    }
    /**
     * Disables the text fields and controls during training.
     */

    public void disableDuringLearning() {
	parameters.setEnabled(false);
	topPanel.setEnabled(false);
    }

    /**
     * Enables the text fields.
     */

    public void enableDuringLearning() {
	parameters.setEnabled(true);
	topPanel.setEnabled(true);
    }

    /**
     * Return the contents of a textfield as an int.
     * @param TextField t - the textfield component.
     * @return int.
     * @exception NumberFormatException.
     */

    public int getFieldAsInt(Label t) {
	try {
	    return (Integer.valueOf(t.getText())).intValue();
	}
	catch (NumberFormatException e) {
	    t.setText("    0");
	    return 0;
	}
    }
    public void graphClose () {
	errorGraph.dispose();
	errorGraph = null;
    }
}
