/////////////////////////////////////////////////////////
// Class	    	:   BCell
// Author	    	:	F. Meyer
// Description	    :   - simple cell object
//						- borders and content can be personalized
// Last Modified    :	03.02.1998
/////////////////////////////////////////////////////////

import java.awt.*;
import java.applet.Applet;

class BCell {

    // Public variables
    public static final int VALUE = 0;
    public static final int LABEL = 1;
    public static final int LEFT = 2;
    public static final int CENTER = 3;
    public static final int RIGHT = 4;
    
    // Private varialbes
    Applet app;
    int width, height;
    boolean hasLeftBorder = false;
    boolean hasRightBorder = false;
    boolean hasTopBorder = false;
    boolean hasBottomBorder = false;
    Color borderColor;
    
    private String lab ="vide";
    Color labelColor;
    int labLoc = LEFT;
    
    
    //////////////////////////////////////////////////////
    // Constructor
    //////////////////////////////////////////////////////

    public BCell(Applet app, int width, int height) {
	this.width = width;
	this.height = height;
	this.app = app;
	
	borderColor = Color.black;
	labelColor = Color.black;
    }


    //////////////////////////////////////////////////////
    // Get... and Set... Procedures
    //////////////////////////////////////////////////////

    public void setBorder(boolean left, 
			  boolean top, 
			  boolean right, 
			  boolean bottom) {
    
	hasLeftBorder = left;
	hasRightBorder = right;
	hasTopBorder = top;
	hasBottomBorder = bottom;
    }
    
    public boolean[] getBorder() {
	boolean b[] = {hasLeftBorder, hasTopBorder, hasRightBorder, hasBottomBorder};
	return b ;
    }
    
    public void setBorderColor(Color color) {
	borderColor = color;
    }

    public void setLabel(float val) {
	lab = Float.toString(val);
    }
    
    public void setLabel(int val) {
	lab = Integer.toString(val);
    }
    
    public void setLabel(String s) {
	lab = s;
    }
    
    public String getLabel() {
	return lab;
    }
    
    public void setLabelColor(Color col) {
	labelColor = col;
    }
    
    public void setLabelLocation (int where) {
	if (where>=LEFT && where<=RIGHT)
	    labLoc = where;
	else
	    labLoc = LEFT; // Default
    }
    
    public int getLabelLocation() {
	return labLoc;
    }
    
    public int getWidth() {
	return width;
    }
    
    public int getHeight() {
	return height;
    }
    
    
    //////////////////////////////////////////////////////
    // Method		:	paint   
    // Descrition	:   draw the current cell
    //						* draw the borders (if they exist)
    //						* print the content at the right place
    //////////////////////////////////////////////////////
 
    public void paint(Graphics g, int x, int y) {
	int labWidth;
	int posx, posy;
	
	// Draw the borders
	g.setColor(borderColor);
	if (hasLeftBorder)
	    g.drawLine(x, y, x, y+height);
	if (hasTopBorder)
	    g.drawLine(x, y, x+width, y);
	if (hasRightBorder)
	    g.drawLine(x+width, y, x+width, y+height);
	if (hasBottomBorder)
	    g.drawLine(x, y+height, x+width, y+height);
	
	// Print the string
	g.setColor(labelColor);
	labWidth = g.getFontMetrics().stringWidth(lab);
	switch(labLoc) {
	case CENTER :
	    posx = x + (width - labWidth)/2;
	    break;
	case RIGHT :
	    posx = (x + width - labWidth - 2);
	    break;
	case LEFT :
	default :    
	    posx = x + 2;
	    break; 		 
	}
	posy = y+height-2; //(y + height - g.getFontMetrics().stringHeight(lab)) / 2;
	g.drawString(lab, posx, posy);
    }
}
