/////////////////////////////////////////////////////////
// Class	    	:   BGame
// Author	    	:	F. Meyer
// Description	    :   - Black Jack table
//						- 
//						from here
// Last Modified    :	03.02.1998
/////////////////////////////////////////////////////////

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;


public class BGame extends Panel implements Runnable {

    // Private constants
    private final int MAX_ACTION = 5;
    private final int DISTRIBUTE = 0;
    private final int PLAYERS = 1;
    private final int DEALER = 2;
    private final int COUNT = 3;
    private final int WAIT = 4;
    
    // Private variables
    private Applet applet;
    
    private Options optionWindow;	// dealer and players options
    
    // interface objects
    private BGameCanvas bgc;
    private Button deal, hit, stand, options;
    private Label lab;
    private TextField bet;
	
    private Panel pb;
    private CardLayout cl;
    private Panel pGame, pPrefs;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstr;
    
    
    private int selectedPanel;  
    private boolean deal_pressed;
    private int curCard;
    private int curAction;
    private int playerPt, dealerPt;	// player and dealer points
    private int dealerLimit;	// usually 17 points

    private boolean goOn = true;
    
    
    // thread used when a game is running
    Thread thisThread;
    Thread player[];


    /////////////////////////////////////////////////////////
    // Constructor
    // Description : - creation of the panel interface
    /////////////////////////////////////////////////////////

    public BGame(Applet a) {
		
	Dimension d = getSize();
	
    	applet = a;
	
	// size of the BGame panel
	setSize(500,400);
	setLayout(null);
	
	// Create the area where cards wil be drawn
	bgc = new BGameCanvas(this);
	bgc.setBounds(0,0,500,30);
	bgc.setBackground(Color.white);
	
	// Panel
	pb = new Panel();
	pb.setBounds(0, 30, 500, 365);
	pb.setBackground(Color.white);
	cl = new CardLayout(5, 0);
	pb.setLayout(cl);
	pGame = new Panel();
	gbLayout = new GridBagLayout();
    	gbConstr = new GridBagConstraints();
    	pGame.setLayout( gbLayout );
	pGame.setBackground(Color.gray);
	
	// Create the players...
	BPlayers.dealer = new BPlayer(BPlayer.DEALER, applet);
	BPlayers.player = new BPlayer [BPlayer.MAX_PLAYER];
	BPlayers.player[0] = new BPlayer(BPlayer.COMPUTER, applet);		
	BPlayers.player[1] = new BPlayer(BPlayer.HUMAN, applet);
	
	buildConstraints(gbConstr, 0, 0, 1, 1, 100, 30);
    	gbLayout.setConstraints(BPlayers.dealer, gbConstr);
	pGame.add(BPlayers.dealer);
	buildConstraints(gbConstr, 0, 1, 1, 1, 100, 30);
    	gbLayout.setConstraints(BPlayers.player[0], gbConstr);
	pGame.add(BPlayers.player[0]);
	buildConstraints(gbConstr, 0, 2, 1, 1, 100, 30);
    	gbLayout.setConstraints(BPlayers.player[1], gbConstr);
	pGame.add(BPlayers.player[1]);
	
	deal = new Button("Deal");
	ActionListener dealListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		if (curAction == WAIT)
		    deal_pressed = true;
	    }	
	};
	deal.addActionListener(dealListener);
    	deal.setBackground(Color.lightGray);
    	buildConstraints(gbConstr, 0, 3, 1, 1, 100, 10);
    	gbConstr.anchor = GridBagConstraints.CENTER;
    	gbLayout.setConstraints(deal, gbConstr);
    	pGame.add(deal);
				
	pPrefs = new Panel();
	optionWindow = new Options(this);
	optionWindow.setBackground(Color.gray);
	pb.add("game", pGame);
	pb.add("preference", optionWindow);
		
	add(bgc);
	add(pb);	       
	
    	// initialize variables
    	curCard = 0;
    	curAction = DISTRIBUTE;
    	Cards.shuffle();
    	deal_pressed = false;
	selectedPanel = 1;
	dealerLimit = 17;
	start();	// start the game
    }



    //////////////////////////////////////////////////////
    // Method		:  	BuildConstraints 
    // Descrition	:  	allows to place interface components
    //					
    //////////////////////////////////////////////////////
  
    void buildConstraints(GridBagConstraints gbc, int gx, int gy,
			  int gw, int gh, int wx, int wy) {
		
    	gbc.gridx = gx;
    	gbc.gridy = gy;
    	gbc.gridwidth = gw;
    	gbc.gridheight = gh;
    	gbc.weightx = wx;
    	gbc.weighty = wy;					
    }



    //////////////////////////////////////////////////////
    // Method		:	displayCard
    // Descrition	:   select the right panel (table or preferences)
    // In			: 	c : the panel to display
    //////////////////////////////////////////////////////
   
    public void displayCard(int c) {
	selectedPanel = c;
	if (c==1) {					// show the game panel
	    cl.show(pb, "game");
	}
	else if (c==2) {			// show the preferences panel
	    cl.show(pb, "preference");
	}
    }
    
    
    
    //////////////////////////////////////////////////////
    // Method		:	setDealerLimit 
    // Descrition	:   changer the dealer limit
    // In			:	l : the new limit (0 <= l <= 21 )
    //////////////////////////////////////////////////////

    public void setDealerLimit(int l) {
	if (l>=0 && l<=21)
	    dealerLimit = l;
    }

    
    //////////////////////////////////////////////////////
    // Method		:	getDealerLimit 
    // Descrition	:   find the dealer limit
    // out			:	the current dealer limit
    //////////////////////////////////////////////////////

    public int getDealerLimit() {
	return dealerLimit;
    }   


    //////////////////////////////////////////////////////
    // Method		:	restart   
    // Descrition	:   start a new play
    //////////////////////////////////////////////////////
     
    public void restart() {
	curAction = DISTRIBUTE;
    }
    
    
    
    //////////////////////////////////////////////////////
    // Method		:  doAction 
    // Descrition	:  - handle the correct action following 
    //					the current step of the game
    // In			: a : the current step of the game
    //////////////////////////////////////////////////////

    synchronized void doAction(int a) {
	int i, j;
	int n = BPlayers.getPlayerNumber();
	switch (a) {
	case DISTRIBUTE : 
	    {
		// shuffle the cards
		Cards.shuffle();
				
				// clear the hand of all players
		BPlayers.dealer.clearHand();
		BPlayers.player[0].clearHand();
		BPlayers.player[1].clearHand();
		
		BPlayers.dealer.setShowScore(false);
		BPlayers.player[0].setShowScore(false);
		BPlayers.player[1].setShowScore(false);
		BPlayers.player[0].enableButton();
		BPlayers.player[1].enableButton();
		
				// distribute new cards
		for (i=0; i<2; i++) {
		    BPlayers.dealer.addCard(Cards.next());
		    for (j=0; j<2; j++) {
			if (BPlayers.player[j].getType() != BPlayer.NONE)
			    BPlayers.player[j].addCard(Cards.next());
		    }
		}
				
				// the dealer can't show his first card
		BPlayers.dealer.setShowFirst(false);
				
				// are the players playing ??
		BPlayers.player[0].setCanPlay(BPlayers.player[0].isPlaying() &&
					      (BPlayers.player[0].calcPoints()!=0)); // isPlaying AND no blackjack
		BPlayers.player[1].setCanPlay(BPlayers.player[1].isPlaying() &&
					      (BPlayers.player[1].calcPoints()!=0));
		repaint();
		break;
	    }
	    
	case PLAYERS : {
	    break;
				// nothing to do
				// the class BPlayer does it alone
	}
	    
	case DEALER : {
	    // let the dealer play
	    BPlayers.player[0].disableButton();
	    BPlayers.player[1].disableButton();
	    BPlayers.dealer.setShowFirst(true);
	    BPlayers.dealer.drawCards();
	    while (BPlayers.dealer.calcPoints() < dealerLimit &&
		   BPlayers.dealer.calcPoints() != 0) {
		BPlayers.dealer.addCard(Cards.next());
		BPlayers.dealer.drawCards();
	    }
	    break;
	}
	    
	case COUNT : {
	    int dealer_pts, player1_pts, player2_pts;
		
				// show the scores
	    BPlayers.dealer.setShowScore(true);
	    BPlayers.player[0].setShowScore(true);
	    BPlayers.player[1].setShowScore(true);
		    	
	    // count the points
	    dealer_pts = BPlayers.dealer.calcPoints();
	    player1_pts = BPlayers.player[0].calcPoints();
	    player2_pts = BPlayers.player[1].calcPoints();
		
				// determine if the players win or lose
				
				// Player 1
	    if (BPlayers.player[0].isPlaying())   {
		if ((player1_pts == 0) ||	 // he has a black-jack
		    (player1_pts>dealer_pts && player1_pts <= 21 && !(dealer_pts==0)) ||
		    (player1_pts<=21 && dealer_pts>21)) 
		    { 
			BPlayers.player[0].incWonGames();
			BPlayers.player[0].win();
		    }
		else
		    BPlayers.player[0].lose();
			
		BPlayers.player[0].incPlayedGames();
		BPlayers.player[0].updateInfo();
	    }
		
				// Player 2
	    if (BPlayers.player[1].isPlaying()) {
		if ((player2_pts == 0)  ||	 // he has a black-jack
		    (player2_pts>dealer_pts && player2_pts <= 21 && !(dealer_pts==0)) ||
		    (player2_pts<=21 && dealer_pts>21))
		    { 
			BPlayers.player[1].incWonGames();
			BPlayers.player[1].win();
		    }
		else
		    BPlayers.player[1].lose();

		BPlayers.player[1].incPlayedGames();
		BPlayers.player[1].updateInfo();

	    }
	    repaint();
		    
	}
	default : {
	}
	}
    }
    
    
    //////////////////////////////////////////////////////
    // Method		:	start   
    // Descrition	:   start the game
    //////////////////////////////////////////////////////

    public void start() {
	thisThread = new Thread(this);
	thisThread.start();
    }
    
    
    
    //////////////////////////////////////////////////////
    // Method		:	stop  
    // Descrition	:   stop the game
    //////////////////////////////////////////////////////
    
    public void stop() {
	goOn = false;
    }
           
    //////////////////////////////////////////////////////
    // Method		:	run 
    // Descrition	:  	run the game
    //////////////////////////////////////////////////////

    public void run() {
	int k;
	curAction = DISTRIBUTE;

	while (goOn) {
	    try {
		thisThread.sleep(100);
	    } catch (InterruptedException e) {
		System.out.println("Interrupted...");
	    }
	    	
	    // do the current action
	    doAction(curAction);
	    
	    
	    // choose the next action
	    switch (curAction) {
	    case DISTRIBUTE : {
		if (BPlayers.player[0].isPlaying())
		    curAction = PLAYERS;
		else if (BPlayers.player[1].isPlaying())
		    curAction = PLAYERS;
		else {
		    curAction = DEALER;
		}
		break;
	    }
	    case PLAYERS : {
		if (!BPlayers.player[0].canPlay() && 
		    !BPlayers.player[1].canPlay()){	
		    curAction = DEALER;
		}
		break;
	    } 
	    case DEALER : {
		curAction = COUNT;
		break;
	    }
	    case COUNT : {
		   
		curAction = WAIT;
		break;
	    }
	    case WAIT :
		if (deal_pressed) {
		    curAction = DISTRIBUTE;
		    deal_pressed = false;
		    BPlayers.dealer.setShowFirst(false);
		}
	    default : {
	    }
	    }
	}
    }
    
    
    
    //////////////////////////////////////////////////////
    // Method		:   paint
    // Descrition	:   paint the players cards...
    //////////////////////////////////////////////////////

    public void paint (Graphics g) {
	BPlayers.repaint();
    }
	
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class BGameCanvas extends Canvas implements  MouseListener{

    // canvas with the two index ("Black Jack" and "Preferences)
    // allows to navigate between the two panels associated to these index

    int select;
    BGame parent;
    
    final int N = 2;
    final int LENGTH = 120;
    final int RIGHT = 10;
    final int TOP = 5;
    final int HEIGHT = 25;
    // the name of the two panels
    final String lab[] = {"Black Jack", "Preferences"};
    
    //////////////////////////////////////////////////////
    // Constructor
    //////////////////////////////////////////////////////
        
    public BGameCanvas(BGame parent) {
	this.select = 1;
	this.parent = parent;
	this.addMouseListener(this);
    }
    
    
    
    //////////////////////////////////////////////////////
    // Method		:   mouseClicke
    // Descrition	:   - handle mouse down event
    //					- display the selected panel
    //////////////////////////////////////////////////////

    public void mouseClicked(MouseEvent e) {
	int x = e.getX();
	int y = e.getY();
	if (x>RIGHT && x <RIGHT + N*LENGTH && y>TOP && y<TOP+HEIGHT) {
	    select = (x - RIGHT) / LENGTH + 1;
	}
	repaint();
	parent.displayCard(select);
    }
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}       

    //////////////////////////////////////////////////////
    // Method		:   update
    // Descrition	:   repaint the canvas
    //////////////////////////////////////////////////////

    public void update(Graphics g){
	paint(g);
    }
    

    //////////////////////////////////////////////////////
    // Method		:	paint
    // Descrition	:   - paint the canvas 
    //					- show the selected panel
    //////////////////////////////////////////////////////

    public void paint(Graphics g) {
	doSelect(select, g);
    }
    
    
    //////////////////////////////////////////////////////
    // Method		:	doSelect
    // Descrition	:   
    //////////////////////////////////////////////////////

    public void doSelect(int s, Graphics g) {
	int i;
	int x, y;
	g.setFont(new Font(g.getFont().getName(), Font.PLAIN, g.getFont().getSize()));
	for (i=1; i<=N; i++) {
	    if (i==s) {
		
	    }
	    else {
		g.setColor(Color.lightGray);
		x = RIGHT + (i-1)*LENGTH;
		y = TOP;
		g.fillRoundRect(x, y, LENGTH, y+HEIGHT, 8, 8);
		g.setColor(Color.gray);
		g.drawRoundRect(x, y, LENGTH, y+HEIGHT, 8, 8);
		g.drawString(lab[i-1], x+5, y+HEIGHT-8);
	    }
	}
	g.setFont(new Font(g.getFont().getName(), Font.BOLD, g.getFont().getSize()));
	g.setColor(Color.gray);
	x = RIGHT + (s-1)*LENGTH;
	y = TOP;
	g.fillRoundRect(x, y, LENGTH, y+HEIGHT, 8, 8);
	g.setColor(Color.white);
	g.drawString(lab[s-1],x+5, y+HEIGHT-8);
	
    }
}

//////////////////////////////////////////////////////////////////////////
