/////////////////////////////////////////////////////////
// Class	    	:   BGraph2D
// Author	    	:	F. Meyer
// Description	    :   - simple graph object that display for a
//						certain number of x values a corresponding 
//						percentage
//						- axe x -> 0 to N (defined by user)
//						- axe y -> 0 to 100 (percentage)
// Last Modified    :	03.02.1998
/////////////////////////////////////////////////////////

import java.awt.*;

public class BGraph2D extends Canvas {

    public static final int LINE = 0;
    public static final int POINT = 1;
    public static final int OFFSET = 30;

    // Public Variables

    public double data[];
    public int dataNb;

    // Private Variables
    private Color lineColor;
    private Color backColor;
    private Color axesColor;

    private int curPt;
    private boolean repaintAll;
    private int old_x, old_y;
    private int new_x, new_y;
	
    private String xLabel, yLabel;



    /////////////////////////////////////////////////////////
    // Constructor
    /////////////////////////////////////////////////////////

    public BGraph2D(int n) {
	int i;
		
	setBounds(0,0,200,200);
	setBackground(Color.gray);
		
	data = new double[2*n];
	dataNb = n;
	for (i=0; i<2*n; i+=2) {
	    data[i] = i;
	    data[i+1] = -1;
	}
		
	// default colors
	lineColor = Color.black;
	backColor = Color.gray;
	axesColor = Color.black;
		
	xLabel = "";
	yLabel = "";
		
	curPt = 0;
	repaintAll = true;
    }



    //////////////////////////////////////////////////////
    // Method		:	paint
    // Descrition	:   draw the axes and the graph
    /////////////////////////////////////////////////////////

    public void paint(Graphics g) {
	g.setColor(axesColor);
	drawAxes(g);
	g.setColor(lineColor);
	draw(g);
    }

	

    //////////////////////////////////////////////////////
    // Method		:   addPoint
    // Descrition	:   add a new point to the graph
    /////////////////////////////////////////////////////////

    public void addPoint(int x, int y) { // where y = f(x)
	if (x>=0 && x< dataNb) 
	    if (y>=0 && y<= 100)
		data[x*2 + 1] = y;
    }
	
    //////////////////////////////////////////////////////
    // Method		:   nextPoint
    // Descrition	:   add a new point to the graph 
    //					after the last one
    /////////////////////////////////////////////////////////
	
    public void nextPoint(double y) {
	data[curPt*2 + 1] = y;
	curPt++;
	repaintAll = false;
	repaint();
    }
	
    //////////////////////////////////////////////////////////////////////
    // Set Methods
    //////////////////////////////////////////////////////////////////////	

    public void setLineColor(Color col) {
	lineColor = col;
	repaint();
    }
    public void setBackColor(Color col) {
	backColor = col;	 
	setBackground(col);
	repaint();
    }	
    public void setAxesColor(Color col) {
	axesColor = col;
	repaint();
    }
    public void setXLabel(String str) {
	if (str != null)
	    xLabel = str;
    }
    public void setYLabel(String str) {
	if (str != null)
	    yLabel = str;
    }

	
    //////////////////////////////////////////////////////
    // Method		:   drawAxes
    // Descrition	:   draw the axes!!!
    //////////////////////////////////////////////////////

    protected void drawAxes(Graphics g) {
	drawXaxe(g);
	drawYaxe(g);
    }

	
    protected void drawXaxe(Graphics g) {
	int x, y, val;
	int i;
	// one step every twenty points
	Rectangle r = getBounds();
	int yp = r.height - OFFSET;
	int xdelta = calcXdelta(r.width - OFFSET*2);

	g.drawLine(5, yp, r.width - 5, yp);

	if(xdelta!=0) {
	    y = r.height -OFFSET + 15;
	    x = OFFSET + xdelta;
	    val = 0;
	    for (i=0; i<10; i++) {
		val+=dataNb/10;
		g.drawString(Integer.toString(val), x-10, y);
		g.drawLine(x,yp+2, x, yp-2);
		x+=xdelta;
	    }
	}		
	i = g.getFontMetrics().stringWidth(xLabel);

	g.drawString(xLabel, r.width - i - 10 , r.height - 40);
    }


	
    protected void drawYaxe(Graphics g) {
	int x, y, val = 0;
	int i;
	Rectangle r = getBounds();
	int xp = OFFSET;
	int ystep = calcYstep(r.height - OFFSET*2);

	g.drawLine(xp, 25, xp, r.height - 5);
		
	if (ystep!=0) {
	    x = 2;
	    y=r.height-OFFSET-ystep;
	    for (i=0; i<10; i++) {	
		val += 10;
		g.drawString(Integer.toString(val),x,y+5);
		g.drawLine(OFFSET - 2, y, OFFSET + 2, y);
		y-=ystep;
	    }
	}
	g.drawString(yLabel, 10, 20);
    }

    //////////////////////////////////////////////////////
    // Method		:	calcYstep  
    // Descrition	:   calculate the step between two 
    //					successive mark for the y-axe
    //////////////////////////////////////////////////////

    private int calcYstep(int height) {
	int i, nstep = 10;
	
	i = height / nstep;
	if (i<10) i = 0;

	return i;
    }

    
    private int calcXdelta(int w) {
	// between 2 succesing mark
	int i, nstep =10;

	i = w / nstep;
	if (i<20) i = 0;
		
	return i;
    }

    //////////////////////////////////////////////////////
    // Method		:	draw   
    // Descrition	:   draw the graph
    //////////////////////////////////////////////////////

    protected void draw(Graphics g) {
	int i;
	Rectangle r = getBounds();

	double x, y;
	double oldx, oldy;
	double deltax, deltay;

	deltax = ((float)(r.width - 2*OFFSET)) / (float)dataNb;
	deltay = ((float)(r.height -2*OFFSET)) / 100.0;

	oldx = OFFSET;
	oldy = r.height - OFFSET - (int)(deltay * data[1]);

		
	x = oldx + deltax;
	y = r.height - OFFSET - (int)(deltay * data[3]);
	if (data[3] != -1) {
	    g.drawLine((int)oldx, (int)oldy, (int)x, (int)y);
	}
	for (i=2; i<dataNb; i++) {
	    oldx = x;
	    oldy = y;
	    x += deltax;
	    y = r.height - OFFSET - (int)(deltay * data[i*2+1]);
	    if (data[i*2+1] != -1) {
		g.drawLine((int)oldx, (int)oldy, (int)x, (int)y);
	    }
	}
    }
}
