/////////////////////////////////////////////////////////
// Class	    	:   BStrategy
// Author	    	:	F. Meyer
// Description	    :   - contains the strategy for the reinforcement learning
//						(typically the Q-values table)
// Last Modified    :	03.02.1998
/////////////////////////////////////////////////////////

public class BStrategy {

    // the 2 possible actions
    public static final int NB_ACTIONS = 2;
    public static final int HIT = 0;
    public static final int STAND = 1;
    
    // Private variables
    private String name;
    private int actionNb;
    private int stateNb;
    private double table [][];
    private String info;
    
    
    //////////////////////////////////////////////////////
    // Constructor
    //////////////////////////////////////////////////////

    public BStrategy(int stateNb) {
	this.stateNb = stateNb;
	table = new double [stateNb][NB_ACTIONS];
	this.name = "Unknown";
    }
    
    
    //////////////////////////////////////////////////////
    // Method		:	clear   
    // Descrition	:   set all table values to 0
    //////////////////////////////////////////////////////

    public void clear() {
	int i, j;
	for (i=0; i<stateNb; i++) {
	    for (j=0; j<NB_ACTIONS; j++) {
		table[i][j] = 0;
	    }
	}
    }
    
    
    
    //////////////////////////////////////////////////////
    // set and get methods
    //////////////////////////////////////////////////////

    public void setName(String name) {
	this.name = name;
    }
    public String getName() {
	return this.name;
    }
    
    
    
    //////////////////////////////////////////////////////
    // Method		:   set
    // Descrition	:   set Q(s, a) to new value
    //////////////////////////////////////////////////////

    public synchronized void set(int s, int a, double value) {
	table[s][a] = value;
    }
    
    
    //////////////////////////////////////////////////////
    // Method		:	get   
    // Descrition	:   get the Q(s, a) value
    //////////////////////////////////////////////////////

    public synchronized double get(int s, int a) {
	return table[s][a];
    }



    //////////////////////////////////////////////////////
    // Method		:	selectAction   
    // Descrition	:   - select an action depending on the state
    //					- method used during the game, not the learning,
    //					so select always he best action
    //////////////////////////////////////////////////////

    public int selectAction(int s) {	
	double f = get(s, HIT), g = get(s, STAND);
	if (f>g) return HIT;
	else if (f==g) return ((int)(Math.random()*2));
	else return STAND;
    }
}
