/////////////////////////////////////////////////////////
// Class	    	:   BTable
// Author	    	:	F. Meyer
// Description	    :   - a simple table build using cells
//						from here
// Last Modified    :	03.02.1998
/////////////////////////////////////////////////////////

import java.awt.*;
import java.applet.Applet;

public class BTable extends Canvas {
    
    private Applet app;
    private int nRow, nCol;
    private BCell table[][];
    private boolean existCell[][];
    private int cellXSize, cellYSize;
    
    
    ///////////////////////////////////////////////////////////////////////
    // Constructor
    ///////////////////////////////////////////////////////////////////////
    
    public BTable(Applet app) {
	int i, j;
	this.app = app;
	this.nRow = 0;
	this.nCol = 0;
    }
    
  

    //////////////////////////////////////////////////////
    // Method		:   createCells
    // Descrition	:   - create nRow x nCol cells
    //					- compute the size of each cell
    //////////////////////////////////////////////////////

    public void createCells(int nRow, int nCol) {
	Dimension d = this.getSize();
	int cellXSize, cellYSize;
	int i, j;
	
	// create the table
	this.nRow = nRow;
	this.nCol = nCol;
	table = new BCell [nRow][nCol];
	existCell = new boolean [nRow][nCol];
	
	// compute the size of each cell
	cellXSize = d.width / nCol;
	cellYSize = d.height / nRow;
	
	// create all cells
	for (i=0; i<nRow; i++)
	    for (j=0; j<nCol; j++) {
		table[i][j] = new BCell(app, cellXSize, cellYSize);
		existCell[i][j] = true;
	    }	
    }
    
 
    //////////////////////////////////////////////////////
    // set and get method  
    // Descrition	:  set or get the cells values, borders or colors  
    //////////////////////////////////////////////////////

    public void setCellValue (int x, int y, String value, int where) {
	table[x][y].setLabel(value);	
	table[x][y].setLabelLocation(where);	
    }

    
    public void setCellValue (int x, int y, int value, int where) {
	table[x][y].setLabel(value);	
	table[x][y].setLabelLocation(where);	
    }
    
   
    public void setCellValue (int x, int y, float value, int where) {
	table[x][y].setLabel(value);	
	table[x][y].setLabelLocation(where);	
    }
    
    
    public void setCellBorder (int x, int y,
			       boolean left, boolean top, boolean right, boolean bottom) {
	table[x][y].setBorder(left, top, right, bottom);
    }
    
    
    public void setCellBorderColor(int x, int y, Color col) {
	table[x][y].setBorderColor(col);
    }

    
    public void setCellLabelColor(int x, int y, Color col) {
	table[x][y].setLabelColor(col);
    }
    
    
    
    //////////////////////////////////////////////////////
    // Method		:	groupCell   
    // Descrition	:   group some cells into one bigger cell
    //////////////////////////////////////////////////////
         
    public void groupCells (int fromrow, int fromcol, int torow, int tocol) {
	BCell temp;
	int cellXSize, cellYSize;
	Dimension d;
	int i, j;
	
	fromrow = Math.max(0, fromrow);
	fromcol = Math.max(0, fromcol);
	torow = Math.min(torow, nRow);
	tocol = Math.min(tocol, nCol);
	
	if (fromrow <= torow && fromcol <= tocol) {
	    d = getSize();
	    cellXSize = d.width / nCol;
	    cellYSize = d.height / nRow;
	    cellXSize *= (tocol - fromcol + 1);
	    cellYSize *= (torow - fromrow + 1);
	    
	    temp = new BCell(app, cellXSize, cellYSize);    
	    temp.setLabel(table[fromrow][fromcol].getLabel());
	    temp.setBorder(table[fromrow][fromcol].getBorder()[0],
			   table[fromrow][fromcol].getBorder()[1],
			   table[fromrow][fromcol].getBorder()[2],
			   table[fromrow][fromcol].getBorder()[3]);
	    temp.setLabelLocation(table[fromrow][fromcol].getLabelLocation());
	    
	    for (i=fromrow; i<=torow; i++)
		for (j=fromcol; j<=tocol; j++) {
		    table[i][j] = temp;
		    existCell[i][j] = false;
		}       
	    existCell[fromrow][fromcol] = true;
	}
    }
    
    
    public void groupColumns(int fromcol, int tocol) {
	groupCells(0, fromcol, nRow - 1, tocol);
    }

    
    public void groupRows(int fromrow, int torow) {
	groupCells(fromrow, 0, torow, nCol - 1);
    }
    
    
    
    //////////////////////////////////////////////////////
    // Method		:	paint   
    // Descrition	:   draw the table with all cells
    //////////////////////////////////////////////////////

    public void paint(Graphics g) {
	int i, j;
	int cellXSize, cellYSize;
	Dimension d = getSize();
	
	cellXSize = d.width / nCol;
	cellYSize = d.height / nRow;
	
	// draw each cell
	for (i=0; i<nRow; i++)
	    for (j=0; j<nCol; j++) 
		if (existCell[i][j])
		    table[i][j].paint(g, cellXSize * j, cellYSize * i);
        
    }
}

