/////////////////////////////////////////////////////////
// Class	    	:   BlackJack
// Author	    	:	F. Meyer
// Description	    :   - main program
//						- initilisation : everything is created
//						from here
// Last Modified    :	03.02.1998
/////////////////////////////////////////////////////////

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class BlackJack extends Applet {

    private CardLayout cardManager;
    private Panel p1, p2;
    private BGame gameArea;
    private Canvas temp;
    private Button game, stat;
	
    private BRLPanel brlp;
	
	
	
    //////////////////////////////////////////////////////
    // Method		:   init
    // Descrition	:   - starting point of the applet
    //		    		- initialisation of the two main parts
    //						* the game
    //						* the learning algorithm
    //		    		- loading of the cards
    //////////////////////////////////////////////////////

    public void init () {

	int i;
	Image im;
		
	// Size of the applet window
	resize(600, 400);
		
	setLayout(null);
	setBackground(Color.white);
		
	// Load the images
	Cards.card = new Image [Cards.number];
	for (i=0; i<Cards.number; i++) {
	    im = getImage( getCodeBase(),
			   "images/"+(i/13)+"-"+(i%13+1)+".gif");
	    Cards.card[i] = im;
	}
	im = getImage ( getCodeBase(),
			"images/00.gif");
	Cards.back = im;

	// Create the game table
	p1 = new Panel();
	p1.setSize(500, 400);
	p1.setLocation(100, 0);
	cardManager = new CardLayout();
	p1.setLayout(cardManager);
	add("East", p1);
	gameArea = new BGame(this);	// new Game area
	p1.add("Game Area", gameArea);
		
	// Create the area with learn options and commands
	brlp = new BRLPanel(this);
	p1.add("RL Panel", brlp);
	cardManager.last(p1);
		
	// Create the buttons for navigation between game and learning
	game = new Button("Play");
	ActionListener gameListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		cardManager.first(p1);
	    }
	};
	game.addActionListener(gameListener);
	stat = new Button("Learn");
	ActionListener statListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		cardManager.last(p1);
	    }
	};
	stat.addActionListener(statListener);
	p2 = new Panel();
	p2.setSize(100, 400);
	p2.setLocation(0, 0);
	p2.setLayout(new GridLayout(10, 1, 8, 8));
	p2.setBackground(Color.white);
	p2.add("Center", game);
	p2.add("Center", stat);
	add("West", p2);
    }

    //////////////////////////////////////////////////////
    // Method	:   paint
    // Descrition	:   draw the game area in the game panel
    // In		:   
    // Out		:   
    public void paint(Graphics g) {
	gameArea.repaint();
    }

    //////////////////////////////////////////////////////
    // Method	:   
    // Descrition	:   
    // In		:   
    // Out		:   
}
