/////////////////////////////////////////////////////////
// Class	    :   Cards
// Author	    :	F. Meyer
// Description	    :   - contains informations about cards :
//			    * images
//			    * values
//			- contains some cards utilities :
//			    * shuffle
//			    * deal
// Last Modified    :	03.02.1998
/////////////////////////////////////////////////////////

import java.awt.Image;

public class Cards {

    public static final int number = 52;
    public static Image card [];  // gifs images
    public static Image back;
    private static int deck [];  // ref to a card
    private static int current;
    // values of the 52 cards
    public static int points [] = {11, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 10,
				   11, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 10,
				   11, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 10,
				   11, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 10};
	
	
			    
    //////////////////////////////////////////////////////
    // Method		:   shuffle
    // Descrition	:   shuffle the cards
    //////////////////////////////////////////////////////

    public static void shuffle() {
    	
	int i, c1, c2, tmp;
	    
	if (deck == null)
	    deck = new int [number];
		
	for (i=0; i<number; i++) 
	    deck[i] = i;

	for (i=0; i<100; i++) {
	    c1 = (int) (Math.random()*number);
	    c2 = (int) (Math.random()*number);
	    tmp = deck[c1];
	    deck[c1] = deck [c2];
	    deck[c2] = tmp;
	}
	current = -1;
    }


    //////////////////////////////////////////////////////
    // Method		:   next 
    // Descrition	:   get the next card in the shuffled deck
    //////////////////////////////////////////////////////
   
    public static synchronized int next() {
    	current++;
	if (current >= number ) {
	    shuffle(); 
	    current = 0;
	}
	return deck[current];
    }
}
