/////////////////////////////////////////////////////////
// Class	    :   Options
// Author	    :	F. Meyer
// Description	    :   - this panel contains all informations
//			about the game, the three players and
//			their attributes
//			- this panel allows to change these attributes
// Last Modified    :	03.02.1998
/////////////////////////////////////////////////////////

import java.awt.*;
import java.awt.event.*;

public class Options extends Panel {
    
    public static final int MAX_PLAYER = 2;

    BGame parent;
    
    GridBagLayout gbl;
    GridBagConstraints gbc;
    
    Button OK;
    
    // dealer fields
    Label title;
    Label beg;
    Label end;
    TextField pt;
    
    // players fields
    Label player_title[];
    Label player_attr[];
    Choice player_choice[];
    TextField player_name[];
    Choice player_strategy[];
    Panel player_panel[];
    Panel player_human[];
    Panel player_computer[];
    CardLayout player_layout[];
    
    // old values
    int dealer_pt;
    int player1_type;
    int player2_type;
    int player1_strat;
    int player2_strat;
    String player1_name;
    String player2_name;
    
    
    /////////////////////////////////////////////////////////
    // CONSTRUCTOR
    /////////////////////////////////////////////////////////

    public Options (BGame parent) {	
	
	int s;

	setSize(500, 370);
	
	this.parent = parent;
	
	gbl = new GridBagLayout();
	gbc = new GridBagConstraints();
	setLayout(gbl);
	// Button
	OK = new Button ("Set");
	ActionListener OKListener = new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		int dl;
	
		BPlayers.player[0].setType(player1_type);
		BPlayers.player[1].setType(player2_type);
		BPlayers.player[0].setStrategy(player1_strat);
		BPlayers.player[1].setStrategy(player2_strat);
		try {
		    dl = Integer.parseInt(pt.getText());
		    if (dl >= 0 && dl<=21)
			getBGameParent().setDealerLimit(dl);
		}
		catch (Exception ex)
		    {
			System.out.println("Error in the dealer limit field");
			pt.setText(Integer.toString(getBGameParent().getDealerLimit()));
		    }
		BPlayers.player[0].reset();
		BPlayers.player[1].reset();
		getBGameParent().restart();	    
	    }
	};
	OK.addActionListener(OKListener);
	buildConstraints(gbc, 0, 4, 2, 1, 25, 25);
	gbl.setConstraints(OK , gbc);
	add(OK);
	    
	// Dealer
	title = new Label("Dealer : ");
	buildConstraints(gbc, 0, 1, 1, 1, 25, 25);
        gbl.setConstraints(title, gbc);
	add(title);
	
	beg = new Label("Stop when ");
	buildConstraints(gbc, 1, 1, 1, 1, 25, 25);
        gbl.setConstraints(beg, gbc);
	add(beg);
	
	end = new Label(" points or more.");
	buildConstraints(gbc, 3, 1, 1, 1, 25, 25);
        gbl.setConstraints(end, gbc);
	add(end);
	
	pt = new TextField("17", 2);
	buildConstraints(gbc, 2, 1, 1, 1, 25, 25);
        gbl.setConstraints(pt, gbc);
	add(pt);
	
	// Players
	player_title = new Label [2];
	player_attr = new Label [2];
	player_choice = new Choice [2];
	player_name = new TextField [2]; //("Your name", 12);
	player_strategy = new Choice [2];
	player_panel = new Panel [2];
	player_human = new Panel [2];
	player_computer = new Panel [2];
	player_layout = new CardLayout [2];
	
	for (int i=0; i<MAX_PLAYER; i++) {
	
	    player_title[i] = new Label("Player "+(i+1)+" :");
	    buildConstraints(gbc, 0, i+2, 1, 1, 25, 25);
	    gbl.setConstraints(player_title[i], gbc);
	    add(player_title[i]);
	    
	    player_choice[i] = new Choice();
	    player_choice[i].addItem("None");
	    player_choice[i].addItem("Human");
	    player_choice[i].addItem("Computer");
	    
	    
	    buildConstraints(gbc, 1, i+2, 1, 1, 25, 25);
	    gbl.setConstraints(player_choice[i], gbc);
	    add(player_choice[i]);
	    
	    player_attr[i] = new Label();
	    buildConstraints(gbc, 2, i+2, 1, 1, 25, 25);
	    gbl.setConstraints(player_attr[i], gbc);
	    add(player_attr[i]);
	    
	    player_panel[i] = new Panel();
	    player_layout[i] = new CardLayout();
	    player_panel[i].setLayout(player_layout[i]);
	    buildConstraints(gbc, 3, i+2, 1, 1, 25, 25);
	    gbl.setConstraints(player_panel[i], gbc);
	    
	    player_name[i] = new TextField("Your name", 12);
	    
    	    player_strategy[i] = new Choice();
	    player_strategy[i].addItem("Random");
	    player_strategy[i].addItem("Current");

	    ItemListener choiceListener = new ItemListener() {
		public void itemStateChanged(ItemEvent e) {
		    player1_type = player_choice[0].getSelectedIndex();
		    player2_type = player_choice[1].getSelectedIndex();
		    player1_strat = player_strategy[0].getSelectedIndex();
		    player2_strat = player_strategy[1].getSelectedIndex();
		    updateWindow();
		    repaint();
		}
	    };
	    player_choice[i].addItemListener(choiceListener);
	    player_strategy[i].addItemListener(choiceListener);
	    
	    player_panel[i].add("human", player_name[i]);
	    player_panel[i].add("computer", player_strategy[i]);
	    
	    add(player_panel[i]);
	}	
	
	dealer_pt = 17;
	player1_type = BPlayer.COMPUTER;
	player2_type = BPlayer.HUMAN;
	player1_strat = 0;
	player2_strat = 0;
	player1_name = "Your name";
	player2_name = "Your name";
	
	updateWindow();
    }

    ////////////////////////////////////////////////////////////////////////////
    
    void buildConstraints(GridBagConstraints gbc, int gx, int gy,
			  int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }
    
    
    
    //////////////////////////////////////////////////////
    // Method		:   updateWindow
    // Descrition	:   display the right components on the
    //					preferences panel depending on the type
    //					of the different players
    //////////////////////////////////////////////////////

    public void updateWindow() {
	int i, s;
	// Player 1
	switch (player1_type) {//(BPlayers.player[0].getType()) {
	case BPlayer.HUMAN : {
	    player_choice[0].select(BPlayer.HUMAN);
	    player_attr[0].setVisible(true);
	    player_attr[0].setText("Name : ");
	    player_layout[0].show(player_panel[0], "human");
	    break;
	}
	case BPlayer.COMPUTER : {
	    player_choice[0].select(BPlayer.COMPUTER);		
	    player_attr[0].setVisible(true);
	    player_attr[0].setText("Strategy : ");
	    s=2;
	    player_layout[0].show(player_panel[0], "computer");
	    break;
	}
	case BPlayer.NONE : {
	    player_choice[0].select(BPlayer.NONE);
	    player_attr[0].setVisible(false);
	    player_name[0].setVisible(false);
	    player_strategy[0].setVisible(false);
	    break;
	}
	default : {
	}
	}
	
	// Player 2
	switch (player2_type) { // (BPlayers.player[1].getType()) {
	case BPlayer.HUMAN : {
	    player_choice[1].select(BPlayer.HUMAN);
	    player_attr[1].setVisible(true);
	    player_attr[1].setText("Name : ");
	    player_layout[1].show(player_panel[1], "human");
	    break;
	}
	case BPlayer.COMPUTER : {
	    player_choice[1].select(BPlayer.COMPUTER);		
	    player_attr[1].setVisible(true);
	    player_attr[1].setText("Strategy : ");
	    player_layout[1].show(player_panel[1], "computer");		
	    break;
	}
	case BPlayer.NONE : {
	    player_choice[1].select(BPlayer.NONE);
	    player_attr[1].setVisible(false);
	    player_name[1].setVisible(false);
	    player_strategy[1].setVisible(false);
	    break;
	}
	default : {
	}
	}
    }     
    
    ////////////////////////////////////////////////////////////////////////////

    public Insets getInsets() {
	return new Insets(20, 5, 5, 5);
    }

    //GETTER
    public BGame getBGameParent() {
	return parent;
    }
    
}
