/**
 * Package which manipulate Animated Image in order to draw them on a canvas.
 * @author Sebastien Baehni
 * @version 1.0
 */
package DrawableSurface;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;

import Forms.*;
import AnimatedImage.*;

/**
 * This is the base class. We can draw an animated Image on it.
 * @author Sebastien Baehni
 * @version 1.0
 */
public class DrawableSurface extends Canvas {
     
    /**
     * This is the animated image of the surface.
     * @serial
     */
    protected AnimatedImage animatedImage;
    /**
     * This is the boolean preventing from the nullpointer exception
     * @serial
     */
    protected boolean painted = false; 
    /**
     * The width of the animatedImage
     * @serial
     */
    protected int width;
    /**
     * The height of the animatedimage
     * @serial
     */
    protected int height;
    
    /**
     * The constructor.
     * @param width           The width of our drawable surface.
     * @param height          The height of our drawable surface.
     * @param backgroundColor The background color of our drawable surface.
     */
    public DrawableSurface(int width,
			   int height,		
			   Color backgroundColor) {
	
	/**
	 * Initialisation of our variables.
	 */
	this.width = width;
	this.height = height;
	/**
	 * We set the size of our drawable surface.
	 */
	this.setSize(this.width,this.height);
	
	/**
	 * We create a new animated image.
	 */
	animatedImage = new AnimatedImage(this.width,this.height,backgroundColor);
    }
    
    /**
     * The second constructor. It is identic to the first one except that the background color
     * is white.
     * @param width  The width of our drawable surface.
     * @param height The height of our drawable surface.
     */
    public DrawableSurface(int width,
			   int height) {
	
	this(width,height,Color.white);	

    }

    /**
     * Method which set the boolean to true. We can now without problems draw our image.
     */
    public void start() {
	this.painted = true;       
	this.repaint();
    }  

    /**
     * The paint method. It draw an image (animated image) on the drawable surface.
     * @param g The graphics context.
     */
    public void paint(Graphics g) {
	if (painted) {
	    g.drawImage(this.animatedImage.image(),0,0,this);	   
	}
    }

    /**
     * The update method. It calls paint only when it has the right to do so.
     */
    public void update(Graphics g) {
 	if (painted) {
	    paint(g);
	}
    }

    /**
     * This method erase the drawable surface whith the color defined in parameter.
     * @param color The new backgroundColor.
     */
    public void eraseSurface(Color color) {
	this.animatedImage().init(color);
    }   

    /**
     * This method returns the width of our drawable surface.
     * @return The width of the drawableSurface.
     */
    public int width() {
	return this.width;
    }

    /**
     * This method returns the height of our drawable surface.
     * @return The height of the drawableSurface.
     */
    public int height() {
	return this.height;
    }
    
    /**
     * This method returns the animated image of our drawable surface.
     * @see AnimatedImage.AnimatedImage
     * @return The animatedImage of the drawableSurface.
     */
    public AnimatedImage animatedImage() {
	return this.animatedImage;
    }          

}
	
	
	
