/**
 * This package provides useful primitives to draw forms like circles, polygon or rectangle.
 * @author Sebastien Baehni
 * @version 1.0
 */
package Forms;

import java.awt.Color;
import java.awt.Rectangle;

/**
 * This abstract class declares the basic methods for creating and manipulating forms.
 * @author Sebastien Baehni
 * @version 1.0
 */
public abstract class Forms {

    /**
     * This is the bounding rectangle.
     */
    protected Rectangle rectangle;
	
    /**
     * The first constructor.
     *@param xOrigin The x origin of the bounding rectangle.
     *@param yOrigin The y origin of the bounding rectangle.
     *@param width   The width of the bounding rectangle.
     *@param height  The height of the bounding rectangle.
     */
    public Forms(int xOrigin, int yOrigin, int width, int height) {
	/**
	 * We create a new rectangle with the parameters specified upper.
	 */
  	rectangle = new Rectangle(xOrigin,
				  yOrigin,
				  width,
				  height);	 
    }
    
    /**
     * The second constructor. It creates a new bounding rectangle with no parameters.
     */
    public Forms() {
  	rectangle = new Rectangle();
    }
    
    /**
     * This fonction set the bounding rectangle to a new rectangle in parameter.
     * @param rectangle The new bounding rectangle.
     */
    public void rectangle(Rectangle rectangle) {
	this.rectangle = rectangle;
    }
    
    /**
     * This method returns the x origin of the bounding rectangle.
     * @return  The x origin of the bounding rectangle.
     */
    public int xOrigin() {
	return this.rectangle.x;
    }

    /**
     * This method set the new x origin of the bounding rectangle.
     * @param xOrigin The new x origin.
     */
    public void xOrigin(int xOrigin) {
	this.rectangle.x = xOrigin;
    }

    /**
     * This method returns the y origin of the bounding rectangle.
     * @return  The y origin of the bounding rectangle.
     */
    public int yOrigin() {
	return this.rectangle.y;
    }

    /**
     * This method set the new y origin of the bounding rectangle.
     *@param yOrigin The new y origin.
     */
    public void yOrigin(int yOrigin) {
	this.rectangle.y = yOrigin;
    }
       
    /**
     * The width of the bounding rectangle.
     * @return  The width of the bounding rectangle.
     */
    public int width() {
	return this.rectangle.width;
    }

    /**
     * This methods set the new width of the bounding rectangle.
     *@param width The new width of the bounding rectangle.
     */
    public void width(int width) {
	this.rectangle.width = width;
    }

    /**
     * This method returns the height of the bounding rectangle.
     * @return  The height of the bounding rectangle.
     */
    public int height() {
	return this.rectangle.height;
    }

    /**
     * We set the new height of the bounding rectangle.
     */
    public void height(int height) {
	this.rectangle.height=height;
    }    

    /**
     * Abstract method. The implementing classes must tell if the forms is selected or not with the specified point.
     * @param x The x coordinate of the point.
     * @param y The y coordinate of the point.
     * @return True if the point is in the forms false otherwise.
     */
    public abstract boolean isSelected(int x, int y);

    /**
     * Abstract method. The implementing classes can translate themselves.
     * @param x        The x point coordinate where the implementing classes must translate.
     * @param y        The y point coordinate where the implementing classes must translate.
     * @param maxWidth  The forms can be translated util maxWidth (after they go out of the window scope).
     * @param maxHeight The forms can be translated util maxHeight (after they go out of the window scope).
     */
    public abstract void translate(int x, int y, int maxWidth, int maxHeight);

}
