/**
 * This package provides useful primitives to draw forms like circles, polygon or rectangle.
 * @author Sebastien Baehni
 * @version 1.0
 */
package Forms;

import java.util.Vector;

/**
 * This class provides tools to administrate the forms. The forms are in a vector and we can manipulate
 * them.
 * @author Sebastien Baehni
 * @see Forms.Forms
 * @see Forms.FormsError
 * @see Forms.FormsAdministratorError
 * @see Forms.MyCircle
 * @see Forms.MyRectangle
 * @see Forms.MyPolygon
 * @version 1.0
 */
public class FormsAdministrator {
	
    /**
     *The circle vector.
     */
    protected Vector circleVector;
    /**
     *The rectangle vector.
     */
    protected Vector rectangleVector;
    /**
     *The polygon vector.
     */
    protected Vector polygonVector;
	
    /**
     * The constructor. It initialize the vectors.
     */
    public FormsAdministrator() {		
	this.circleVector = new Vector();
	this.rectangleVector = new Vector();
	this.polygonVector = new Vector();	
    }
	
    /**
     * We remove all the elements from the different vector.
     */
    public void clearAll() {
	this.circleVector.removeAllElements();
	this.rectangleVector.removeAllElements();
	this.polygonVector.removeAllElements();
    }
	
    /**
     * We add a circle in the bag of circles.
     * @param xCenter The x center of the circle.
     * @param yCenter The y center of the circle.
     * @param radius  The radius of the circle.
     */     
    public void addCircle(int xCenter, int yCenter, int radius) {
	/**
	 * We create a new circle and we add it to the vector.
	 */
	MyCircle circle = new MyCircle(xCenter,yCenter,radius);
	this.circleVector.insertElementAt(circle,this.indexCircle());
    }
	
    /**
     * We add a rectangle in the bag of rectangles.
     * @param xOrigin The x coordinate of the first corner of the rectangle.
     * @param yOrigin The y coordinate of the first corner of the rectangle.
     * @param width   The width of the rectangle.
     * @param height  The height of the rectangle.
     */  
    public void addRectangle(int xOrigin, int yOrigin, int width, int height) {
	/**
	 * We create a new rectangle and we add it to the vector.
	 */
	MyRectangle rectangle = new MyRectangle(xOrigin,yOrigin,width,height);
	this.rectangleVector.insertElementAt(rectangle,this.indexRectangle());
    }

    /**
     * We add a polygon in the bag of polygons.
     * @param precision The final point of the segment will be taken has the final point if it is in a circle of radius precision, center first point.
     */
    public void addPolygon(int precision) {
	/**
	 * We add a new polygon in the bag of polygons.
	 */
	MyPolygon myPolygon = new MyPolygon(precision);
	this.polygonVector.insertElementAt(myPolygon,this.indexPolygon());
    }
	
    /**
     * We remove a circle in the bag of circles.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the circle doesn't exist.
     * @param indexCircle The index of the circle we want to remove.
     */
    public void removeCircle(int indexCircle) throws FormsAdministratorError {
	/**
	 * We test if the parameter is a valid parameter.
	 */
	if (indexCircle >= this.indexCircle() || indexCircle < 0) {
	    throw new FormsAdministratorError("The circle you want to remove doesn't exist");
	}
	else {
	    /**
	     * We remove the circle.
	     */
	    this.circleVector.removeElementAt(indexCircle);
	}
    }
	
    /**
     * We remove a rectangle in the bag of rectangles.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the rectangle doesn't exist.
     * @param indexRectangle The index of the rectangle we want to remove.
     */
    public void removeRectangle(int indexRectangle) throws FormsAdministratorError {
	/**
	 * We test if the parameter is a valid parameter.
	 */ 
	if (indexRectangle >= this.indexRectangle() || indexRectangle < 0) {
	    throw new FormsAdministratorError("The rectangle you want to remove doesn't exist");
	}
	else {
	    /**
	     * We remove the rectangle.
	     */
	    this.rectangleVector.removeElementAt(indexRectangle);
	}
    }
	
    /**
     * We remove a polygon in the bag of polygons.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the polygon doesn't exist.
     * @param indexPolygon The index of the polygon we want to remove.
     */
    public void removePolygon(int indexPolygon) throws FormsAdministratorError {
	/**
	 * We test if the parameter is a valid parameter.
	 */ 
	if (indexPolygon >= this.indexPolygon() || indexPolygon < 0) {
	    throw new FormsAdministratorError("The polygon you want to remove doesn't exist");
	}
	else {
	    /**
	     * We remove the polygon.
	     */
	    this.polygonVector.removeElementAt(indexPolygon);
	}
    }	
	
    /**
     * This fonction return a circle in the bag of circles.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the circle doesn't exist.
     * @param indexCircle The circle we want to return is at position indexCircle.
     * @return The circle specified by the index or throw an exception if there is no circle at the specified index.
     */
    public MyCircle returnCircle(int indexCircle) throws FormsAdministratorError {
	/**
	 * We test if the parameter is a valid parameter.
	 */ 
	if (indexCircle >= this.indexCircle() || indexCircle < 0) {
	    throw new FormsAdministratorError("The circle you want to return doesn't exist");
	}
	else {
	    /**
	     * We return the circle.
	     */
	    return (MyCircle)circleVector.elementAt(indexCircle);			
	}
    }
	
    /**
     * This method return the circle (his index in the bag) if it contains the point specified in parameters.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the circle doesn't exist.
     * @param x The x coordinate of the point to test if it is in the circle.
     * @param y The y coordinate of the point to test if it is in the circle.
     * @return The index of the circle that contains the point or Integer.MIN_VALUE if there is no circle that contains the point.
     */
    public int returnIndexCircle(int x, int y) throws FormsAdministratorError {
	/**
	 * We return the first circle that contains the point.
	 */
	for (int i=0; i<circleVector.size(); i++) {
	    if (this.returnCircle(i).isSelected(x,y)) {
		return i;
	    }
	}
	return Integer.MIN_VALUE;
    }
	
    /**
     * Return the radius of the circle at index indexCircle.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the circle doesn't exist.
     * @param indexCircle The index of the circle we want to have the radius.
     * @return The radius of the specified circle or an error (if the specified index is not a valid one).
     */
    public int returnRadius(int indexCircle) throws FormsAdministratorError {
	return ((this.returnCircle(indexCircle)).radius());
    }
	
    /**
     * This method return the center of a circle.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the circle doesn't exist.
     * @param indexCircle The index of the circle we want to have the center.
     * @return The center of the specified circle or an error (if the specified index is not a valid one).
     */
    public int[] returnCircleCenter(int indexCircle) throws FormsAdministratorError {
	int[] center = new int[2];
	center[0] = (this.returnCircle(indexCircle)).xCenter;
	center[1] = (this.returnCircle(indexCircle)).yCenter;
		
	return center;
    }
	
    /**
     * This fonction return a rectangle in the bag of rectangles.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the rectangle doesn't exist.
     * @param indexRectangle The rectangle we want to return is at position indexRectangle.
     */
    public MyRectangle returnRectangle(int indexRectangle) throws FormsAdministratorError {
	/**
	 * We test if the parameter is a valid parameter.
	 */ 
	if (indexRectangle >= this.indexRectangle() || indexRectangle < 0) {
	    throw new FormsAdministratorError("The rectangle you want to return doesn't exist");
	}
	else {
	    /**
	     * We return the rectangle.
	     */
	    return (MyRectangle)rectangleVector.elementAt(indexRectangle);
	}
    }
	
    /**
     * This method return the rectangle (his index in the bag) if it contains the point specified in parameters.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the rectangle doesn't exist.
     * @param x The x coordinate of the point to test if it is in the rectangle.
     * @param y The y coordinate of the point to test if it is in the rectangle.
     * @return  The index of the rectangle that contains the point or Integer.MIN_VALUE if there is no rectangle that contains the point.
     */
    public int returnIndexRectangle(int x, int y) throws FormsAdministratorError {
	/**
	 * We return the first rectangle that contains the point.
	 */
	for (int i=0; i<rectangleVector.size(); i++) {
	    if (this.returnRectangle(i).isSelected(x,y)) {
		return i;
	    }
	}
	return Integer.MIN_VALUE;
    }
	
    /**
     * This method return the width of a rectangle.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the rectangle doesn't exist.
     * @param indexRectangle The rectangle we want to return it's width is at position indexRectangle.
     * @return The width of the rectangle or an error if the indexRectangle isn't a valide parameters.
     */
    public int returnRectangleWidth(int indexRectangle) throws FormsAdministratorError {
	return ((this.returnRectangle(indexRectangle)).width());
    }
	
    /**
     * This method return the height of a rectangle.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the rectangle doesn't exist.
     * @param indexRectangle The rectangle we want to return it's height is at position indexRectangle.
     * @return The height of the rectangle or an error if the indexRectangle isn't a valide parameters.
     */
    public int returnRectangleHeight(int indexRectangle) throws FormsAdministratorError {
	return ((this.returnRectangle(indexRectangle)).height());
    }
	
    /**
     * This fonction return a polygon in the bag of polygons.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the rectangle doesn't exist.
     * @param indexPolygon The polygon we want to return is at position indexPolygon.
     */
    public MyPolygon returnPolygon(int indexPolygon) throws FormsAdministratorError {
	/**
	 * We test if the parameter is a valid parameter.
	 */ 
	if (indexPolygon >= this.indexPolygon() || indexPolygon < 0) {
	    throw new FormsAdministratorError("The polygon you want to return doesn't exist");
	}
	else {
	    /**
	     * We return the polygon.
	     */
	    return (MyPolygon)polygonVector.elementAt(indexPolygon);
	}
    }

    /**
     * This method return the polygon (his index in the bag) if it contains the point specified in parameters.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the polygon doesn't exist.
     * @param x The x coordinate of the point to test if it is in the polygon.
     * @param y The y coordinate of the point to test if it is in the polygon.
     * @return  The index of the polygon that contains the point or Integer.MIN_VALUE if there is no polygon that contains the point.
     */	
    public int returnIndexPolygon(int x, int y) throws FormsAdministratorError {
	/**
	 * We return the first polygon that contains the point.
	 */
	for (int i=0; i<polygonVector.size(); i++) {
	    if (this.returnPolygon(i).isSelected(x,y)) {
		return i;
	    }
	}
	return Integer.MIN_VALUE;
    }	

    /**
     * This method return the width of a polygon.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the polygon doesn't exist.
     * @param indexPolygon The polygon we want to return it's width is at position indexPolygon.
     * @return The width of the polygon or an error if the indexPolygon isn't a valide parameters.
     */	
    public int returnPolygonWidth(int indexPolygon) throws FormsAdministratorError {
	return ((this.returnPolygon(indexPolygon)).width());
    }

    /**
     * This method return the height of a polygon.
     * @see Forms.FormsAdministratorError
     * @throws Forms.FormsAdministratorError A new error that said that the polygon doesn't exist.
     * @param indexPolygon The polygon we want to return it's height is at position indexPolygon.
     * @return The height of the polygon or an error if the indexPolygon isn't a valide parameters.
     */	
    public int returnPolygonHeight(int indexPolygon) throws FormsAdministratorError {
	return ((this.returnPolygon(indexPolygon)).height());
    }

    /**
     * This method return the size of the circle vector.
     * @return The size of the circle vector.
     */
    public int indexCircle() {
	return this.circleVector.size();
    }

    /**
     * This method return the size of the rectangle vector.
     * @return The size of the rectangle vector.
     */	
    public int indexRectangle() {
	return this.rectangleVector.size();
    }
	
    /**
     * This method return the size of the polygon vector.
     * @return The size of the polygon vector.
     */
    public int indexPolygon() {
	return this.polygonVector.size();
    }
}
