/**
 * This package implements a gray color chooser.
 * @author Sebastien Baehni
 * @version 1.0
 */
package GrayColorChooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.*;
import java.awt.Frame;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.util.Vector;

/** 
 * This class create a gray color chooser.
 * @author Sebastien Baehni
 * @version 1.0
 */
public class GrayColorChooser extends Frame implements MouseListener,
						       WindowListener,					    
						       MouseMotionListener {   
    
    /**
     * The Label for the current gray value.
     * @serial
     */
    protected Label gray;  
    /**
     * The Label for the choosen gray value.
     * @serial
     */
    protected Label gray_choosen;
    
    /**
     * The label for the choosen color.
     * @serial
     */
    protected Label choosen_color;
    /**
     * The label for the current color.
     * @serial
     */
    protected Label current_color;  
    
    /**
     * The information Label.
     * @serial
     */
    protected Label informations;           
    
    /**
     * The canvas containing the gray palette.
     * @serial
     */
    protected GrayCanvas gray_canvas;
    
    /**
     * Tells if the frame is open or not.
     * @serial
     */
    protected boolean colorFrameOpen = false; 
    /**
     * The value of the color that the user has clicked on.
     * @serial
     */
    protected int colorClicked=128;
    /**
     * Tells if the user has clicked or not on a color.
     * @serial
     */
    protected boolean clicked = false;								         
    
    /**
     * The main constructor. It places the different fields of the frame to have a estetic view of the all.     
     */
    public GrayColorChooser() {
	
	/**
	 * Title Bar.
	 */
	super("GRAY COLOR CHOOSER");
	
	/**
	 * The layout of the frame will be a BorderLayout so all the parts of the borderlayout are panels (except the east one).
	 * Then we can add component like we want.
	 */
	Panel center;
	Panel north; 
	Panel south;	
	Panel south_west;
	Panel south_east;
	
	/** 
	 * Initialization of all the variables.
	 */
	north = new Panel();
	south = new Panel();
	south_west = new Panel();
	south_east = new Panel();
	center = new Panel();
	gray = new Label("GRAY: 128");
	gray_choosen = new Label("GRAY: 128");
	/**
	 * We must have space because of a jdk bug (I suppose). Even if we set the size it didn't resize itself. So we must
	 *   add space to have the right size.
	 */
	current_color = new Label("       ");	
	choosen_color = new Label("       ");
	informations = new Label("          PLEASE WAIT          ",Label.CENTER);
	/**
	 * The constructor of the canvas with the mouselistener and the mousemotionlistener in parameters.
	 * This is the canvas in which we draw the palette.
	 */
	gray_canvas = new GrayCanvas(this,this);
	
	/**
	 * North Panel.
	 */
	north.setLayout(new FlowLayout(FlowLayout.CENTER));
	north.add(informations);
	
	/**
	 * South Panel.
	 */
	south.setLayout(new GridLayout(1,2));
	south.add(south_west);
	south.add(south_east);
	
	south_west.setLayout(new FlowLayout(FlowLayout.CENTER));
	south_west.add(gray);
	south_west.add(current_color);
	south_east.setLayout(new FlowLayout(FlowLayout.CENTER));
	south_east.add(gray_choosen);
	south_east.add(choosen_color);
	
	/**
	 * Center Panel.
	 */
	center.setLayout(new FlowLayout(FlowLayout.CENTER));
	center.add(gray_canvas);
	
	/**
	 * The labels.
	 */
	gray.setForeground(Color.black);
	choosen_color.setBackground(new Color(128,128,128));
	current_color.setBackground(new Color(128,128,128));
	
	/**
	 * Principal layout of the window.
	 */
	this.setLayout(new BorderLayout());
	
	/** 
	 * We add the different panel in the frame.
	 */
	this.add(north,BorderLayout.NORTH);	
	this.add(center,BorderLayout.CENTER);	
	this.add(south,BorderLayout.SOUTH);
	
	/**
	 * Last configuration of the window.
	 */
	this.addWindowListener(this);
	this.setResizable(false);
	this.setLocation(200,100);
	this.pack();
	
    }
    
    /**
     * We show the window and then we paint the canvas.
     */
    public void start() {			       
	Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
	this.setLocation(Math.abs((dimension.width-this.getSize().width)/2),Math.abs((dimension.height-this.getSize().height)/2));
	this.show();  	
	
	gray_canvas.start();
	
	informations.setText("CHOOSE A GRAY COLOR");
  	
  	this.colorFrameOpen = true;
	
    } 
    
    /**
     * This method capture the mouse clicked event and then we refresh the choosen color. 
     * @param e The mouse event.
     */
    public void mouseClicked(MouseEvent e){	
	gray_choosen.setText("GRAY: "+new Integer(e.getX()).toString());
	choosen_color.setBackground(new Color(e.getX(),e.getX(),e.getX()));	
  	this.colorClicked=e.getX();
  	this.clicked = true;	
    }        
    
    /**
     * When the mouse is pressed.
     * @param e The mouse event.
     */
    public void mousePressed(MouseEvent e){}
    /**
     * When the mouse is released.
     * @param e The mouse event.
     */
    public void mouseReleased(MouseEvent e){}
    
    /**
     * When we enter the canvas, we refresh the gray label and the current color. 
     * @param e The mouse event.
     */
    public void mouseEntered(MouseEvent e){       
	gray.setText("GRAY: "+new Integer(e.getX()).toString());
	current_color.setBackground(new Color(e.getX(),e.getX(),e.getX()));	
    }
    
    /**
     * When we exit the canvas, we refresh the gray label.   
     * @param e The mouse event. 
     */
    public void mouseExited(MouseEvent e){	
	gray.setText("GRAY: N\\A");	
    }
    
    /**
     * The different functions re-implemented for a dragging mouse.    
     * @param e The mouse event.
     */
    public void mouseDragged(MouseEvent e) {}              
    /**
     * If the mouse is moved in the canvas, we refresh the label and the current color.
     * @param e The mouse event.
     */
    public void mouseMoved(MouseEvent e) {	
	
	gray.setText("GRAY: "+new Integer(e.getX()).toString());
	current_color.setBackground(new Color(e.getX(),e.getX(),e.getX()));
	
    }
    
    /**
     * To close the window.
     * @param e The window event.
     */
    public void windowClosing(WindowEvent e) {	
	this.dispose();
  	this.colorFrameOpen=false;	
    }
    
    /**
     * When you open the window.    
     * @param e The window event.
     */     
    public void windowOpened(WindowEvent e){}
    /**
     * When you iconify the window.    
     * @param e The window event.
     */     
    public void windowIconified(WindowEvent e) {}
    /**
     * When you deiconify the window.    
     * @param e The window event.
     */     
    public void windowDeiconified(WindowEvent e) {}
    /**
     * When you deactivate the window.    
     * @param e The window event.
     */     
    public void windowDeactivated(WindowEvent e) {}
    /**
     * When you close the window.    
     * @param e The window event.
     */     
    public void windowClosed(WindowEvent e) {}
    /**
     * When you active the window.    
     * @param e The window event.
     */     
    public void windowActivated(WindowEvent e) {} 
    
    /**
     * This method returns if the frame is open or not.
     * @return True is the frame is open, false otherwise.
     */
    public boolean colorFrameOpen() {
	return this.colorFrameOpen;
    }
    
    /**
     * This method returns the rgb value of the color choosen by the user.
     * @return The rgb value of the color choosen by the user.
     */
    public int colorClicked() {
	return this.colorClicked;
    }
    
    /**
     * This method returns if the user has clicked on the frame in order to choose a color or not.
     * @return True if the user has clicked on the color frame.
     */
    public boolean clicked() {
	return this.clicked;
    }
    
    /**
     * This method set the clicked parameters.
     * @param set Set the clicked parameters to the set value.
     */
    public void clicked(boolean set) {
	this.clicked = set;
    }
    
}
