/**
 * This package provides tools to draw the help in a frame from a simple file.
 * @author Sebastien Baehni
 * @version 1.0
 */
package Help;

import java.awt.Color;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import PanelConfiguration.ImageCanvas;

/**
 * This class provides a canvas in which we draw the help image.
 * @see PanelConfiguration.ImageCanvas
 * @author Sebastien Baehni
 * @version 1.0
 */
public class HelpImageCanvas extends ImageCanvas {	
	
    /**
     * The main constructor. It just calls the super one.
     */
    public HelpImageCanvas() {
	super();				
    }
	
    /**
     * The init method. It just calls the super one.
     * @param image The help image.
     */
    public void init(Image image) {							
	super.init(image);			
    }
	
    /**
     * Update method. Not finished
     */
    public void update(int i) {
	this.repaint();
    }
	
    /**
     * Paint method. Not finished.
     */
    public void paint(Graphics g) {	
	g.clearRect(0,0,this.WIDTH,this.HEIGHT);
	super.paint(g);
	g.setColor(Color.black);
	//g.fillOval(i,i,10,10);
    }
	
}
