/**
 * This package provides tools to draw the help in a frame from a simple file.
 * @author Sebastien Baehni
 * @version 1.0
 */
package Help;

import java.io.Serializable;

/**
 * This class provides the menus structure. The menu contains a name, text and, if so, an array of submenu.
 * @author Sebastien baehni
 * @version 1.0
 */
public class MyMenu implements Serializable{
    
    /**
     * The name of the menu.
     * @serial
     */
    protected String name;
    /**
     * The text of the menu
     * @serial
     */
    protected String text;

    /**
     * The array of sub menu.
     * @serial
     */
    protected MyMenu[] subMenu;

    /**
     * The main constructor. It initialises the instances variables with the
     * parameters.
     * @param name The name of the menu.
     * @param text The text of the menu.
     * @param subMenu The array of sub menus.
     */
    public MyMenu(String name, String text, MyMenu[] subMenu) {
	this.name = name;
	this.text = text;
	this.subMenu = subMenu;
    }

    /**
     * The other constructor. This menu has no sub menu.
     * @param name The name of the menu.
     * @param text The text of the menu.
     */
    public MyMenu(String name, String text) {
	this.name = name;
	this.text = text;
	this.subMenu = null;
    }
	
    /**
     * This method return the name of the menu.
     * @return The name of the menu.
     */
    public String name() {
	return this.name;
    }
	
    /**
     * This method return the text of the menu.
     * @return The text of the menu.
     */
    public String text() {
	return this.text;
    }
	
    /**
     * This method return if the menu has sub menu or not.
     * @return True if the menu has sub menu, False otherwise.
     */
    public boolean hasSubMenu() {
	if (this.subMenu == null) {
	    return false;
	}
	else {
	    return true;
	}
    }
	
    /**
     * Return the array of submenus of a menu.
     * @return The sub menus of a menu.
     */
    public MyMenu[] subMenu() {
	return this.subMenu;
    }		

}

