/**
 * This package provides some tools to create and manipulate a panel.
 * @author Sebastien baehni
 * @version 1.0
 */
package PanelConfiguration;

import java.awt.Canvas;
import java.awt.event.*;
import java.awt.Image;
import java.awt.Graphics;

/**
 * This class provides a canvas in order to paint an image on it.
 * @author Sebastien baehni
 * @version 1.0
 */
public class ImageCanvas extends Canvas implements ComponentListener {
    
    /** 
     * The initial image.
     * @serial
     */
    protected Image image;
    /**
     * The current image (it changes when the image is resized).
     * @serial
     */
    protected Image currentImage;
    /**
     * A boolean to prevent java form drawing an unitialized image.
     * @serial
     */
    protected boolean painted = false;

    /**
     * The constructor. Do nothing.
     */
    public ImageCanvas() {}		

    /**
     * The initialization method. 
     * @param image The image we want to paint on the canvas.
     */
    public void init(Image image) {
	this.setSize(image.getWidth(this),image.getHeight(this));	
	this.image = image;
	this.addComponentListener(this);	
	this.update();
    }

    /**
     * This method take in account it the user is resizing the applet.
     * If it is then we resize the image.
     */
    public void update() {
	int width = this.getBounds().width;	
	int height = this.getBounds().height;	
	this.currentImage = this.image.getScaledInstance(width,height,Image.SCALE_SMOOTH);	
	this.painted = true;
    }

    /**
     * This method update the image that is shown in the canvas.
     * @param image The image that we must show in the cavnas.
     */
    public void update(Image image) {	
	int width = this.getBounds().width;	
	int height = this.getBounds().height;
	this.currentImage = image.getScaledInstance(width,height,Image.SCALE_SMOOTH);
	this.painted = true;
	this.repaint();
    }

    /**
     * The paint method. We draw the image on a graphic.
     * @see java.awt.Graphics
     * @param g The graphics context.
     */
    public void paint(Graphics g) {			 							      
	if (painted) {
	    g.drawImage(this.currentImage,0,0,this);				
	}
    }

    /**
     * When the component is hidden.
     * @param e The ComponentEvent
     */
    public void componentHidden(ComponentEvent e) {}                
    /**
     * When the component is moved.
     * @param e The ComponentEvent
     */
    public void componentMoved(ComponentEvent e) {}
    /**
     * When the component is resized.
     * @param e The ComponentEvent
     */
    public void componentResized(ComponentEvent e) {
	this.painted = false;
	this.update();
    }
    /**
     * When the component is shown.
     * @param e The ComponentEvent
     */
    public void  componentShown(ComponentEvent e) {}
 
	

}
	
	
