/**
 * This package provides some tools to create and manipulate a panel.
 * @author Sebastien baehni
 * @version 1.0
 */
package PanelConfiguration;

import java.awt.Color;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.awt.FlowLayout;
import java.awt.Panel;

import java.lang.Thread;

import DrawableSurface.ModifiedPaintSurface;

/**
 * This class provides the panel in order to add a modifiedPaintSurface on it.
 * @see DrawableSurface.ModifiedPaintSurface
 * @see PanelConfiguration.PanelConfiguration
 * @author Sebastien baehni
 * @version 1.0
 */ 
public class ModifiedPaintSurfacePanel extends PanelConfiguration implements MouseListener,
									     ComponentListener {
    
    /**
     * The surface that we are going to add to the panel.
     * @see DrawableSurface.PaintSurface
     * @serial
     */
    protected ModifiedPaintSurface modifiedPaintSurface;
    
    /**
     * The panel on which we display a help message.
     * @see PanelConfiguration.ToolPanel
     * @serial
     */
    protected ToolPanel toolPanel; 
    
    /**
     * The first constructor. It create a ModifiedPaintSurfacePanel with a background color.
     * @see DrawableSurface.ModifiedPaintSurface
     * @param width  The width of the modifiedPaintSurface.
     * @param height The height of the modifiedPaintSurface.
     * @param backgroundColor The backgroundColor of the ModifiedPaintSurfacePanel.
     */
    public ModifiedPaintSurfacePanel(int width, int height, Color backgroundColor) {
	super(backgroundColor);
	modifiedPaintSurface = new ModifiedPaintSurface(width,height);		
	this.setLayout(new FlowLayout(FlowLayout.CENTER));		
    }
    
    /**
     * The second constructor. It create a ModifiedPaintSurfacePanel with a white background.
     * @see DrawableSurface.ModifiedPaintSurface
     * @param width  The width of the ModifiedPaintSurface.
     * @param height The height of the ModifiedPaintSurface.  
     */
    public ModifiedPaintSurfacePanel(int width, int height) {
	this(width,height,Color.white);
    }
    
    /**
     * Initialization of the ModifiedPaintSurfacePanel.
     * @see PanelConfiguration.ToolPanel
     * @see PanelConfiguration.PaintSurfacePanel
     * @param toolPanel         The panel on which we display the help message.
     * @param paintSurfacePanel The panel we are going to get the stimuli for the algorithme.
     */
    public void init(ToolPanel toolPanel,PaintSurfacePanel paintSurfacePanel) {
	this.toolPanel = toolPanel;	
	this.addMouseListener(this);
	this.addComponentListener(this);
	this.modifiedPaintSurface.init(paintSurfacePanel.paintSurface(),this.toolPanel);
	this.add(modifiedPaintSurface);
    }
    
    /**
     * This method call the start method of the ModifiedPaintSurface.
     * @see DrawableSurface.ModifiedPaintSurface
     */
    public void start() {
	modifiedPaintSurface.start();
    }
    
    /**
     * This method init the simulation in taking in account the different parameters for the different layer of the filter.
     * @param coneSynapticResistanceFloat        The value for the synaptic resistance of the cone layer.
     * @param coneMembranarResistanceFloat       The value for the membranar resistance of the cone layer.
     * @param coneMembranarCapacityFloat         The value for the membranar capacity of the cone layer.
     * @param coneJonctionResistanceFloat        The value for the jonction resistance of the cone layer.
     * @param horizontalSynapticResistanceFloat  The value for the synaptic resistance of the horizontal layer.
     * @param horizontalMembranarResistanceFloat The value for the membranar resistance of the horizontal layer.
     * @param horizontalMembranarCapacityFloat   The value for the membranar capacity of the horizontal layer.
     * @param horizontalJonctionResistanceFloat  The value for the jonction resistance of the horizontal layer.
     * @param numberOfMillisToSleepLong          The value of which we ara going to sleep in the algorithme.
     */
    public void initSimulation(float coneSynapticResistanceFloat,
			       float coneMembranarResistanceFloat,
			       float coneMembranarCapacityFloat,
			       float coneJonctionResistanceFloat,
			       float horizontalSynapticResistanceFloat,
			       float horizontalMembranarResistanceFloat,
			       float horizontalMembranarCapacityFloat,
			       float horizontalJonctionResistanceFloat,
			       long numberOfMillisToSleepLong)
    {
	this.modifiedPaintSurface.initSimulation(coneSynapticResistanceFloat,
						 coneMembranarResistanceFloat,
						 coneMembranarCapacityFloat,
						 coneJonctionResistanceFloat,
						 horizontalSynapticResistanceFloat,
						 horizontalMembranarResistanceFloat,
						 horizontalMembranarCapacityFloat,
						 horizontalJonctionResistanceFloat,
						 numberOfMillisToSleepLong);
    }
		
	
    /**
     * Method that start the simulation.
     */
    public void startSimulation() {				
	new Thread(this.modifiedPaintSurface).start();				
    }
	
    /**
     * That method stop the simulation.
     */
    public void stopSimulation() {
	this.modifiedPaintSurface.stop();
    }

    /**
     * When the mouse is clicked.
     * @param e The MouseEvent.
     */
    public void mouseClicked(MouseEvent e) {}
	
    /**
     * When the mouse enters.
     * @param e The MouseEvent.
     */
    public void mouseEntered(MouseEvent e) {
	this.toolPanel.setText("In the white area you can see the output of the retina with the above input stimuli.");
    }
	
    /**
     * When the mouse exits.
     * @param e The MouseEvent.
     */
    public void mouseExited(MouseEvent e) {}
	
    /**
     * When the mouse is pressed.
     * @param e The MouseEvent.
     */
    public void mousePressed(MouseEvent e) {}
	
    /**
     * When the mouse is released.
     * @param e The MouseEvent.
     */
    public void mouseReleased(MouseEvent e) {}

    /**
     * When the component is hidden.
     * @param e The ComponentEvent
     */
    public void componentHidden(ComponentEvent e) {}                
    /**
     * When the component is moved.
     * @param e The ComponentEvent
     */
    public void componentMoved(ComponentEvent e) {}
    /**
     * When the component is resized.
     * @param e The ComponentEvent
     */
    public void componentResized(ComponentEvent e) {	
	this.modifiedPaintSurface.setLocation((this.getBounds().width-this.modifiedPaintSurface.width())/2,
					      (this.getBounds().height-this.modifiedPaintSurface.height())/2);	
    }
    /**
     * When the component is shown.
     * @param e The ComponentEvent
     */
    public void  componentShown(ComponentEvent e) {}
    
}
