/**
 * This package provides some tools to create and manipulate a panel.
 * @author Sebastien baehni
 * @version 1.0
 */
package PanelConfiguration;

import java.awt.Color;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Rectangle;

import DrawableSurface.PaintSurface;

/**
 * This class provides the panel in order to add a paintSurface on it.
 * @see DrawableSurface.PaintSurface
 * @see PanelConfiguration.PanelConfiguration
 * @author Sebastien baehni
 * @version 1.0
 */ 
public class PaintSurfacePanel extends PanelConfiguration implements MouseListener,
								     ComponentListener {
    
    /**
     * The surface that we are going to add to the panel.
     * @see DrawableSurface.PaintSurface
     * @serial
     */
    protected PaintSurface paintSurface;	
    /**
     * The panel on which we display a help message.
     * @see PanelConfiguration.ToolPanel
     * @serial
     */
    protected ToolPanel toolPanel;
    
    /**
     * The first constructor. It create a PaintSurfacePanel with a background color.
     * @see DrawableSurface.PaintSurface
     * @param width  The width of the PaintSurface.
     * @param height The height of the PaintSurface.
     * @param backgroundColor The backroundColor of the PaintSurfacePanel.
     */
    public PaintSurfacePanel(int width, int height, Color backgroundColor) {
	super(backgroundColor);
	this.paintSurface = new PaintSurface(width,height);
	this.setLayout(new FlowLayout(FlowLayout.CENTER));		
    }
	
    /**
     * The second constructor. It create a PaintSurfacePanel with a white background.
     * @see DrawableSurface.PaintSurface
     * @param width  The width of the PaintSurface.
     * @param height The height of the PaintSurface.  
     */
    public PaintSurfacePanel(int width, int height) {
	this(width,height,Color.white);
    }
    
    /**
     * Initialization of the PaintSurfacePanel.
     * @see PanelConfiguration.ToolPanel
     * @see PanelConfiguration.FormsMakerPanel
     * @param toolPanel       The panel on which we display the help message.
     * @param formsMakerPanel The panel we are going to get the different variables (type of forms choosen, texture, color) for drawing on a PaintSurface.
     */
    public void init(ToolPanel toolPanel, FormsMakerPanel formsMakerPanel) {	
	this.toolPanel = toolPanel;
	this.addMouseListener(this);
	this.addComponentListener(this);
	this.paintSurface.init(this.toolPanel,formsMakerPanel);      
	this.add(this.paintSurface);  				    	
    }	
    
    /**
     * This method call the start method of the PaintSurface.
     * @see DrawableSurface.PaintSurface
     */
    public void start(){
	this.paintSurface.start();
    }	
    
    /**
     * Return the PaintSurface of the panel.,
     * @see DrawableSurface.PaintSurface
     * @return The PaintSurface of the panel.
     */     
    public PaintSurface paintSurface() {
	return this.paintSurface;
    }
	
    /**
     * When the mouse is clicked. 
     * @param e The MouseEvent.
     */
    public void mouseClicked(MouseEvent e) {}
    /**
     * When the mouse enters. 
     * @param e The MouseEvent.
     */
    public void mouseEntered(MouseEvent e) {	
	this.toolPanel.setText("The white area is the surface on which you can draw shapes and move them.\nTo clear the surface click on it with the right mouse button.");  		   	
    }
    /**
     * When the mouse exits. 
     * @param e The MouseEvent.
     */
    public void mouseExited(MouseEvent e) {}
    /**
     * When the mouse is pressed. 
     * @param e The MouseEvent.
     */
    public void mousePressed(MouseEvent e) {}
    /**
     * When the mouse is released. 
     * @param e The MouseEvent.
     */
    public void mouseReleased(MouseEvent e) {}	 

    
    /**
     * When the component is hidden.
     * @param e The ComponentEvent
     */
    public void componentHidden(ComponentEvent e) {}                
    /**
     * When the component is moved.
     * @param e The ComponentEvent
     */
    public void componentMoved(ComponentEvent e) {}
    /**
     * When the component is resized.
     * @param e The ComponentEvent
     */
    public void componentResized(ComponentEvent e) {	
	this.paintSurface.setLocation((this.getBounds().width-this.paintSurface.width())/2,
				      (this.getBounds().height-this.paintSurface.height())/2);	
    }
    /**
     * When the component is shown.
     * @param e The ComponentEvent
     */
    public void  componentShown(ComponentEvent e) {}
	
}
