/**
 * This package provides some tools to create and manipulate a panel.
 * @author Sebastien baehni
 * @version 1.0
 */
package PanelConfiguration;

import java.awt.Color;
import java.awt.Panel;

/**
 * This class provide some tools to create and manipulate a panel.
 * @see java.awt.Panel
 * @author Sebastien baehni
 * @version 1.0
 */
public class PanelConfiguration extends Panel {
    
    /**
     * The constructor.
     * @param backgroundColor The background color of the panel.
     */
    public PanelConfiguration(Color backgroundColor) {
	this.setBackground(backgroundColor);
    }	
    
    /**
     * The second constructor. This constructor set the panel's background color to the white color.
     */
    public PanelConfiguration() {
	this.setBackground(Color.white);
    }
    
    /**
     * This method enable the panel.
     */
    public void Enable() {
	this.setEnabled(true);
    }
    
    /** 
     * This method disable the panel.
     */
    public void Disable() {
	this.setEnabled(false);
    }
    
}
	
	
