/**
 * This package provides some tools to create and manipulate a panel.
 * @author Sebastien baehni
 * @version 1.0
 */
package PanelConfiguration;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.*;
import java.awt.Image;
import java.awt.Graphics;

/**
 * This class create a panel on which we can draw an image for the title of the applet.
 * @author Sebastien baehni
 * @see PanelConfiguration.FormsMakerPanel
 * @version 1.0
 */
public class RCImagePanel extends PanelConfiguration implements MouseListener {
       	   
    /**
     * The panel that display help messages.
     * @serial
     */
    protected ToolPanel toolPanel;
    /**
     * The canvas on which we draw the image.
     * @serial
     */
    protected ImageCanvas rcImageCanvas; 
	
    /**
     * To know if we had a nullpointerexception.
     * @serial
     */
    protected boolean nullpointer = false;
    
    /**
     * The constructor. It creates a new RCImagePanel with a ImageCanvas and an image on it.
     * @param backgroundColor The background color of the panel.
     */
    public RCImagePanel(Color backgroundColor) {
	super(backgroundColor);	       
	this.rcImageCanvas = new ImageCanvas();
	this.setLayout(new BorderLayout());
    }
    
    /**
     * Second constructor. It creates a new RCImagePanel with a ImageCanvas and an image on it.
     * the background color of the panel is white.
     */
    public RCImagePanel() {
	this(Color.white);
    }
    
    /**
     * Initialization method. We add the canvas and the mouse listener. At the end of the initialisation, we repaint 
     * the image.
     * @see PanelConfiguration.ToolPanel
     * @param toolPanel The panel in which we display the help.
     * @param rcFilterImages The image that show what the algorithm is based on.
     */
    public void init(ToolPanel toolPanel, Image rcFilterImages) {	
	this.toolPanel = toolPanel;	
	this.add(this.rcImageCanvas);	
	this.rcImageCanvas.init(rcFilterImages);       	
	this.addMouseListener(this);	
	this.rcImageCanvas.addMouseListener(this);
	this.rcImageCanvas.repaint();			
    }	 		     
    /**
     * Initialization method used when we catch a nullpointer exception.
     * @see PanelConfiguration.ToolPanel
     * @param toolPanel The panel in which we display the help.
     */
    public void init(ToolPanel toolPanel) {	
	this.toolPanel = toolPanel;				  	
	this.addMouseListener(this);		
	this.nullpointer = true;
	this.repaint();	
    }
	
    /**
     * This method paint a message when the user try to run the applet in netscape.
     * The netscape browser doesn't support the media tracker and nor to read a help
     * message. We just put a message to the user to inform it.
     * @param g The graphic context.
     */
    public void paint(Graphics g) {
	if (this.nullpointer) {
	    g.setColor(Color.red);
	    g.drawString("Your browser doesn't support the media tracker.",10,this.getBounds().height/3);
	    g.drawString("To have help see the bottom of the page.",20,this.getBounds().height/2);
	}
    }

    /**
     * This method update the image that is shown in the panel.
     * @param image The image that we must show in the panel.
     */
    public void update(Image image) {
	this.rcImageCanvas.update(image);
    }
    
    /**
     * When the mouse is clicked.    
     * @param e The MouseEvent.
     */
    public void mouseClicked(MouseEvent e) {}
    /**
     * When the mouse enters.    
     * @param e The MouseEvent.
     */
    public void mouseEntered(MouseEvent e) {
  	this.toolPanel.setText("This is the image of the filters that are used for the retina algorithm.\nThere are two layers (cone and horizontal) each with the synaptic resistance r, the junction resistance R, the membrane resistance Rm and the membrane capacity C.");
    }
    /**
     * When the mouse exits.    
     * @param e The MouseEvent.
     */
    public void mouseExited(MouseEvent e) {}
    /**
     * When the mouse is pressed.    
     * @param e The MouseEvent.
     */
    public void mousePressed(MouseEvent e) {}
    /**
     * When the mouse is released.    
     * @param e The MouseEvent.
     */
    public void mouseReleased(MouseEvent e) {}
    
}
