/**
 * This package provides some tools to create and manipulate a panel.
 * @author Sebastien baehni
 * @version 1.0
 */
package PanelConfiguration;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.*;
import java.awt.Image;
import java.awt.Graphics;

/**
 * This class create a panel on which we can draw an image for the title of the applet.
 * @author Sebastien baehni
 * @see PanelConfiguration.FormsMakerPanel
 * @version 1.0
 */
public class TitlePanel extends PanelConfiguration implements MouseListener {
       	   
    /**
     * The panel that display help messages.
     * @serial
     */
    protected ToolPanel toolPanel;
    /**
     * The canvas on which we draw the image.
     * @serial
     */
    protected ImageCanvas titleCanvas;
    
    /**
     * The constructor. It creates a new TitlePanel with a ImageCanvas and an image on it.
     * @param backgroundColor The background color of the panel.
     */
    public TitlePanel(Color backgroundColor) {
	super(backgroundColor);	       
	this.titleCanvas = new ImageCanvas();
	this.setLayout(new BorderLayout());
    }
    
    /**
     * Second constructor. It creates a new TitlePanel with a ImageCanvas and an image on it.
     * the background color of the panel is white.
     */
    public TitlePanel() {
	this(Color.white);
    }
    
    /**
     * Initialization method. We add the canvas and the mouse listener. At the end of the initialisation, we repaint 
     * the image.
     * @see PanelConfiguration.ToolPanel
     * @param toolPanel The panel in which we are going to display the help text.
     * @param image The title image.
     */
    public void init(ToolPanel toolPanel, Image image) {	
	this.toolPanel = toolPanel;	
	this.add(this.titleCanvas);	
	this.titleCanvas.init(image);  
	this.addMouseListener(this);	
	this.titleCanvas.addMouseListener(this);
	this.titleCanvas.repaint();			
    }	 		     
	
    /**
     * Initialization method used when we catch a nullpointerexception. 
     * We add the canvas and the mouse listener. 
     * @see PanelConfiguration.ToolPanel
     * @param toolPanel The panel in which we are going to display the help text.
     */
    public void init(ToolPanel toolPanel) {	
	this.toolPanel = toolPanel;			
	this.addMouseListener(this);			
    }
    
    /**
     * When the mouse is clicked.
     * @param e The MouseEvent.
     */
    public void mouseClicked(MouseEvent e) {}
    /**
     * When the mouse enters.
     * @param e The MouseEvent.
     */
    public void mouseEntered(MouseEvent e) {
  	this.toolPanel.setText("This is the title. Nothing to say...");
    }
    /**
     * When the mouse exits.
     * @param e The MouseEvent.
     */
    public void mouseExited(MouseEvent e) {}
    /**
     * When the mouse is pressed.
     * @param e The MouseEvent.
     */
    public void mousePressed(MouseEvent e) {}
    /**
     * When the mouse is released.
     * @param e The MouseEvent.
     */
    public void mouseReleased(MouseEvent e) {}
    
}
