/**
 * This package provides some tools to create and manipulate a panel.
 * @author Sebastien baehni
 * @version 1.0
 */
package PanelConfiguration;

import java.applet.*;
import java.awt.Button;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.*;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.TextArea;
import java.awt.Panel;
import java.net.*;

import Help.*;

/**
 * This class provides a panel where we can have help.
 * @author Sebastien baehni
 * @see PanelConfiguration.FormsMakerPanel
 * @version 1.0
 */
public class ToolPanel extends PanelConfiguration implements MouseListener {
	
    /**
     * A help button.
     * @serial
     */
    protected Button helpButton;
    /**
     * The area on which we draw help messages.
     * @serial
     */
    protected TextArea textArea;
    /**
     * The panel for the help.
     * @serial
     */
    protected Panel helpPanel;
	
    /**
     * The help frame.
     * @see Help.Help
     * @serial
     */
    protected Help help;	
    
    /**
     * The mouse listener for the help button.
     * @serial
     */ 
    protected MouseListener helpMouseListener;

    /**
     * The first constructor. It adds the area and the button and 
     * set the layout of the ToolPanel.
     * @param backgroundColor The background color of the panel.
     */
    public ToolPanel(Color backgroundColor) {
	super(backgroundColor);	
	this.helpPanel = new Panel(new FlowLayout(FlowLayout.CENTER));
	this.helpButton = new Button("HELP");	
	this.textArea = new TextArea("Tips on how to manipulate this applet will appear here.",3,50,TextArea.SCROLLBARS_NONE);
	this.initMouseListener();
	this.setLayout(new BorderLayout());
    }
    
    /**
     * The second constructor. It adds the area and the button and 
     * set the layout of the ToolPanel. The background color of the panel is white.
     */
    public ToolPanel() { 
	this(Color.white);
    }  
    
    /**
     * Initialisation of the mouse listener. 
     */
    protected void initMouseListener() {
	this.helpMouseListener = new MouseListener() {
	    public void mouseClicked(MouseEvent e) {			
		if (!helpFrameOpen()) {
		    help().start();
		}
		else {
		    help().toFront();
		}						
	    }
	    public void mouseEntered(MouseEvent e) {
		setText("Click on this button to have more help on the applet.");
	    }
	    public void mouseExited(MouseEvent e) {}
	    public void mousePressed(MouseEvent e) {}
	    public void mouseReleased(MouseEvent e) {}
	};
    }
    
    /**
     * Initialisation of the panel. This method adds the mouse listener, and set the different 
     * properties for the TextArea ...
     * @param image The help image.
     * @param fileName The help file name.
     */
    public void init(Image image,URL fileName) {   
	/**
	 * We create the help frame.
	 */
	this.help = new Help(fileName);		
	this.helpButton.addMouseListener(helpMouseListener);
	this.helpPanel.addMouseListener(this);
	this.textArea.addMouseListener(this);
	this.addMouseListener(this);
	this.help.init(image);
	this.textArea.setEditable(false);	
	this.textArea.setBackground(Color.white);	
	this.helpPanel.add(helpButton);	
	this.add(helpPanel,BorderLayout.NORTH);		
	this.add(textArea,BorderLayout.CENTER);
    }

   /**
     * Initialisation of the panel. This method adds the mouse listener, and set the different 
     * properties for the TextArea ...
     * @param image The help image.
     * @param fileName The help file name.
     */
    public void init(Image image,String fileName) {   
	/**
	 * We create the help frame.
	 */
	this.help = new Help(fileName);		
	this.helpButton.addMouseListener(helpMouseListener);
	this.helpPanel.addMouseListener(this);
	this.textArea.addMouseListener(this);
	this.addMouseListener(this);
	this.help.init(image);
	this.textArea.setEditable(false);	
	this.textArea.setBackground(Color.white);	
	this.helpPanel.add(helpButton);	
	this.add(helpPanel,BorderLayout.NORTH);		
	this.add(textArea,BorderLayout.CENTER);
    }

	
	
    /**
     * Initialisation of the panel used when we catch a nullpointerexception.       
     */
    public void init() {	
	this.helpPanel.addMouseListener(this);
	this.textArea.addMouseListener(this);
	this.addMouseListener(this);	
	this.textArea.setEditable(false);	
	this.textArea.setBackground(Color.white);			
	this.add(helpPanel,BorderLayout.NORTH);		
	this.add(textArea,BorderLayout.CENTER);
    }
    
    /**
     * This method set a help message on the TextArea.
     * @param string The help message.
     */
    public void setText(String string) {	
	this.textArea.setForeground(Color.black);
	this.textArea.setText(string);
    }
	
    /**
     * This method set a help message on the TextArea with a specified color.
     * @param string The help message.
     * @param color  The color of the help message.
     */
    public void setText(String string, Color color) {
	this.textArea.setForeground(color);
	this.textArea.setText(string);
    }
	
    /**
     * This method returns if the help frame is open or not.
     * @see Help.Help
     * @return True if the help frame is open. False otherwise.
     */
    public boolean helpFrameOpen() {
	return this.help.helpFrameOpen();
    }
	
    /**
     * This method returns the help frame.
     * @see Help.Help
     * @return The help frame.
     */
    public Help help() {
	return this.help;
    }
    /**
     * When the mouse is clicked.
     * @param e The MouseEvent.
     */
    public void mouseClicked(MouseEvent e) {}
    /**
     * When the mouse enters.
     * @param e The MouseEvent.
     */
    public void mouseEntered(MouseEvent e) {
  	this.setText("Tips on how to manipulate this applet will appear here.");
    }
    /**
     * When the mouse exits.
     * @param e The MouseEvent.
     */
    public void mouseExited(MouseEvent e) {}
    /**
     * When the mouse is pressed.
     * @param e The MouseEvent.
     */
    public void mousePressed(MouseEvent e) {}
    /**
     * When the mouse is released.
     * @param e The MouseEvent.
     */
    public void mouseReleased(MouseEvent e) {}
    
}
