import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.*;
import java.awt.Frame;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;

import java.net.URL;
import java.net.MalformedURLException;

import PanelConfiguration.*;

/**
 * This class is the main class of the retina algorithme. It put all the panel in the right place and initialise them.
 * @see PanelConfiguration
 */
public class RetineSimulation extends Applet implements  ComponentListener {	
	
    /**
     * The width of the PaintSurface and the ModifiedPaintSurface.
     * @see DrawableSurface.PaintSurface
     * @see DrawableSurface.ModifiedPaintSurface
     * @serial
     */
    protected final int width = 250;
    /**
     * The height of the PaintSurface and the ModifiedPaintSurface.
     * @see DrawableSurface.PaintSurface
     * @see DrawableSurface.ModifiedPaintSurface
     * @serial
     */
    protected final int height = 150;
	    
    // All the panel.
    /**
     * The paintsurface panel.
     * @see PanelConfiguration.PaintSurfacePanel
     * @serial
     */
    protected PaintSurfacePanel paintSurfacePanel;
    /**
     * The modified paintsurface panel.
     * @see PanelConfiguration.ModifiedPaintSurfacePanel
     * @serial
     */
    protected ModifiedPaintSurfacePanel modifiedPaintSurfacePanel;
    /**
     * The forms maker panel.
     * @see PanelConfiguration.FormsMakerPanel
     * @serial
     */
    protected FormsMakerPanel formsMakerPanel;
    /**
     * The retine configuration panel.
     * @see PanelConfiguration.PaintSurfacePanel
     * @serial
     */
    protected RetineConfigurationPanel retineConfigurationPanel;
    /**
     * The title panel.
     * @see PanelConfiguration.TitlePanel
     * @serial
     */
    protected TitlePanel titlePanel;
    /**
     * The tool panel.
     * @see PanelConfiguration.ToolPanel
     * @serial
     */
    protected ToolPanel toolPanel;
    /**
     * The RC image panel.
     * @see PanelConfiguration.RCImagePanel
     * @serial
     */
    protected RCImagePanel rcImagePanel;

    // The different panels to add the upper panels.     
    /**
     * The north panel (see code for more informations).
     * @serial 
     */
    protected Panel northPanel;
    /**
     * The north east panel (see code for more informations).
     * @serial 
     */
    protected Panel northEastPanel;
    /**
     * The north west panel (see code for more informations).
     * @serial 
     */
    protected Panel northWestPanel;
    /**
     * The center panel (see code for more informations).
     * @serial 
     */
    protected Panel centerPanel;
    /**
     * The center east panel (see code for more informations).
     * @serial 
     */
    protected Panel centerEastPanel;    
    /**
     * The center west panel (see code for more informations).
     * @serial 
     */
    protected Panel centerWestPanel;    	
	
	
    /**
     * The constructor. It creates all the panel with the right parameters.
     */
    public RetineSimulation() {	
	this.toolPanel = new ToolPanel();
	this.titlePanel = new TitlePanel();
	this.rcImagePanel = new RCImagePanel();
	this.paintSurfacePanel = new PaintSurfacePanel(this.width,this.height,new Color(150,150,150));
	this.modifiedPaintSurfacePanel = new ModifiedPaintSurfacePanel(this.width,this.height,new Color(100,100,100));
	this.formsMakerPanel = new FormsMakerPanel();
	this.retineConfigurationPanel = new RetineConfigurationPanel();
	
	this.northPanel = new Panel(new BorderLayout());
	this.northEastPanel = new Panel(new FlowLayout(FlowLayout.CENTER));
	this.northWestPanel = new Panel(new FlowLayout(FlowLayout.CENTER));
	this.centerPanel = new Panel(new BorderLayout());
	this.centerEastPanel = new Panel(new GridLayout(2,1));
	this.centerWestPanel = new Panel(new BorderLayout());
			
	this.setLayout(new BorderLayout());
    }
	
    /**
     * Initialisation of all the panel with the right parameters.
     */
    public void	init(){								
	/**
	 * We load the images that we will display on the applet
	 */
	try {
	    Image titleImage = this.getImage(this.getCodeBase(),"images/title.gif");
	    Image generalImage =  this.getImage(this.getCodeBase(),"images/generalImage.gif");
	    Image helpImage = this.getImage(this.getCodeBase(),"images/helpImage.gif");
		
	    /**
	     * The media tracker to get the image without having a null pointer exception.
	     */
	    MediaTracker mediaTracker = new MediaTracker(this);
	    mediaTracker.addImage(titleImage,0);
	    mediaTracker.addImage(generalImage,0);
	    mediaTracker.addImage(helpImage,0);
	    try {
		mediaTracker.waitForAll();
	    }
	    catch (InterruptedException error) {
		System.out.println("Error in loading the images. Please try again");
		System.exit(-1);
	    }	

	    this.addComponentListener(this);
		
	    /**
	     * We get the help file that we will display when the user hit the help button.
	     */
	    try {
		this.toolPanel.init(helpImage,new URL(this.getCodeBase(),"HelpFiles/help.txt.str"));		
	    }
	    catch (MalformedURLException e) {
		System.out.println("Error in loading the file.Please mail to Sebastien.Baehni@epfl.ch with this string:");
		e.printStackTrace();
	    }
	    catch (Exception e) {	
		this.toolPanel.init();	
	    }
	    this.titlePanel.init(this.toolPanel,titleImage);
	    this.rcImagePanel.init(this.toolPanel, generalImage);
	    this.formsMakerPanel.init(this.toolPanel);
			
	}
	/**
	 * We have a nullpointerexception because of netscape and it's media tracker.
	 * We paint a message when the user try to run the applet in netscape.
	 * We just put a message to the user to inform it.
	 */
	catch (Exception exception) {			
	    this.toolPanel.init();		
	    this.titlePanel.init(this.toolPanel);
	    this.rcImagePanel.init(this.toolPanel);
	    this.formsMakerPanel.init(this.toolPanel);			
	}
	this.paintSurfacePanel.init(this.toolPanel,this.formsMakerPanel);			
	this.modifiedPaintSurfacePanel.init(this.toolPanel,this.paintSurfacePanel);		
	this.retineConfigurationPanel.init(this.toolPanel,this.formsMakerPanel,this.modifiedPaintSurfacePanel);	
    }	

    /**
     * This method initialize the retina algorithm with the right values when we want to
     * start it in a frame.
     * @param myFrame The frame in which we want to show the retina applet.
     */
    public void initMain(Frame myFrame) {			
	Toolkit toolkit = Toolkit.getDefaultToolkit();
	Image titleImage = toolkit.getImage("./images/title.gif");
	Image generalImage = toolkit.getImage("./images/generalImage.gif");
	Image helpImage = toolkit.getImage("./images/helpImage.gif");
	
	MediaTracker mediaTracker = new MediaTracker(myFrame);
	mediaTracker.addImage(titleImage,0);
	mediaTracker.addImage(generalImage,0);
	mediaTracker.addImage(helpImage,0);
	try {
	    mediaTracker.waitForAll();
	}
	catch (InterruptedException error) {
	    System.out.println("Error in loading the images");
	    System.exit(-1);
	}	

	this.addComponentListener(this);
	
	this.toolPanel.init(helpImage,"HelpFiles/help.txt.str");
	this.titlePanel.init(this.toolPanel,titleImage);
	this.rcImagePanel.init(this.toolPanel, generalImage);
	this.formsMakerPanel.init(this.toolPanel);
	this.paintSurfacePanel.init(this.toolPanel,this.formsMakerPanel);			
	this.modifiedPaintSurfacePanel.init(this.toolPanel,this.paintSurfacePanel);		
	this.retineConfigurationPanel.init(this.toolPanel,this.formsMakerPanel,this.modifiedPaintSurfacePanel);
    }

    /**
     * We start the applet. This method add all the panel.
     */
    public void	start(){					  
	this.add(this.northPanel,BorderLayout.NORTH);
	this.add(this.centerPanel,BorderLayout.CENTER);
	
	this.northPanel.add(this.titlePanel,BorderLayout.WEST);
	this.northPanel.add(this.toolPanel,BorderLayout.CENTER);
	
	this.centerPanel.add(this.centerEastPanel,BorderLayout.WEST);
	this.centerPanel.add(this.centerWestPanel,BorderLayout.CENTER);
	
	this.centerEastPanel.add(this.paintSurfacePanel);
	this.centerEastPanel.add(this.modifiedPaintSurfacePanel);

	this.centerWestPanel.add(this.formsMakerPanel,BorderLayout.NORTH);
	this.centerWestPanel.add(this.retineConfigurationPanel,BorderLayout.WEST);  
	this.centerWestPanel.add(this.rcImagePanel,BorderLayout.CENTER);  
	  	
  	this.paintSurfacePanel.start();
  	this.modifiedPaintSurfacePanel.start();

	this.centerElements(this);	
		
    }
    
    /**
     * This method is called when the applet is stopped.
     */
    public void stop(){}
  
    /**
     * This method is called when the applet is destroyed.
     */
    public void destroy(){
	this.formsMakerPanel.grayColorChooser().dispose();
	this.toolPanel.help().dispose();
    } 
	
    /**
     * This method center the paintsurface and the modifiedpaintsurface
     * @param retineSimulation this class.
     */
    public void centerElements(RetineSimulation retineSimulation) {
	retineSimulation.componentResized(new ComponentEvent(retineSimulation,ComponentEvent.COMPONENT_RESIZED));		
    }

    /**
     * Method to know if the component is hidden.
     * @param e The ComponentEvent
     */
    public void componentHidden(ComponentEvent e) {}   
    /**
     * Method to know if the component is moved.
     * @param e The ComponentEvent
     */
    public void componentMoved(ComponentEvent e) {}
    /**
     * Method to know if the component is resized.
     * @param e The ComponentEvent
     */
    public void componentResized(ComponentEvent e) {
	this.paintSurfacePanel.componentResized(e);
	this.modifiedPaintSurfacePanel.componentResized(e);
    }
    /**
     * Method to know if the component is shown.
     * @param e The ComponentEvent
     */
    public void componentShown(ComponentEvent e) {}	

    /**
     * Main method. Called when the user want to start the applet in a 
     * frame.
     * @param args The argument of the command line.
     */
    public static void main(String[] args) {

	Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
	Frame myFrame = new Frame("THE RETINA SIMULATION");
	RetineSimulation retineSimulation = new RetineSimulation();
	WindowListener windowListener = new WindowListener() {
	    public void windowActivated(WindowEvent e) {}             
	    public void windowClosed(WindowEvent e) {}
	    public void windowClosing(WindowEvent e) {
		System.exit(0);
	    }
	    public void windowDeactivated(WindowEvent e) {}
	    public void windowDeiconified(WindowEvent e) {}
	    public void windowIconified(WindowEvent e) {} 
	    public void windowOpened(WindowEvent e) {}
	};
	myFrame.addWindowListener(windowListener);


	retineSimulation.initMain(myFrame);
	myFrame.add(retineSimulation);
	retineSimulation.start();
	myFrame.pack();	
	myFrame.setLocation(Math.abs((dimension.width-myFrame.getSize().width)/2),Math.abs((dimension.height-myFrame.getSize().height)/2));
	myFrame.show();	
	/**
	 * We center the paintsurface and the modifiedpaintsurface.
	 */
	retineSimulation.centerElements(retineSimulation);	
    } 

}
