/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron;

import com.objectspace.jgl.Pair;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import spikingneuron.drawable.LineOfPoints;
import spikingneuron.generators.CircularGenerator;
import spikingneuron.generators.DiscreteNoisyGenerator;
import spikingneuron.generators.NoisyGenerator;
import spikingneuron.generators.PositiveGenerator;
import spikingneuron.generators.PulsesGenerator;
import spikingneuron.generators.RandomPulsesGenerator;
import spikingneuron.generators.SignalGenerator;
import spikingneuron.generators.SquareGenerator;
import spikingneuron.generators.StepGenerator;
import spikingneuron.math.Coordinate2D;
import spikingneuron.neurons.IFDrawable;
import spikingneuron.neurons.NetworkView;
import spikingneuron.neurons.NeuronBaseModel;
import spikingneuron.neurons.PopulationActivity;
import spikingneuron.neurons.SRMLongDrawable;
import spikingneuron.neurons.SRMShortDrawable;
import spikingneuron.tools.Clock;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.GraphCanvas;
import spikingneuron.tools.PrimitiveTypeGroup;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.CircularGeneratorGI;
import spikingneuron.userinterface.DiscreteNoisyGeneratorGI;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.IntegrateAndFireGI;
import spikingneuron.userinterface.LongGI;
import spikingneuron.userinterface.NeuronBaseModelGI;
import spikingneuron.userinterface.NoisyGeneratorGI;
import spikingneuron.userinterface.PositiveGeneratorGI;
import spikingneuron.userinterface.PulsesGeneratorGI;
import spikingneuron.userinterface.RandomPulsesGeneratorGI;
import spikingneuron.userinterface.SRMLongMemoryGI;
import spikingneuron.userinterface.SRMShortMemoryGI;
import spikingneuron.userinterface.SignalGeneratorGI;
import spikingneuron.userinterface.SquareGeneratorGI;
import spikingneuron.userinterface.StepGeneratorGI;

public class NeuralNetwork
extends JApplet
implements Runnable {
    public static final double EPSILON = 1.0E-15;
    public boolean isAnApplet = false;
    public Container cp;
    SignalGenerator generator;
    SignalGenerator initialGenerator;
    PopulationActivity populationActivity;
    NeuronBaseModel[][] network;
    int netX;
    int netY;
    JTabbedPane tabbedPane;
    public Font defaultFont;
    public Font boldFont;
    public Font bigFont;
    public Font bigBoldFont;
    public Font smallMonoFont;
    public Border loweredBorder;
    public Border raisedBorder;
    StartJButton computeBtn;
    StopJButton stopBtn;
    DoubleGI time;
    DoubleGI tMax;
    DoubleGI deltaT;
    DoubleGI durationInitialPhase;
    NetworkView networkView;
    TitleCanvas headerCnv;
    NetworkUI networkUI;
    ExternalUI externalUI;
    InitialExternalUI initialExternalUI;
    ActivityUI activityUI;
    GraphCanvas activityCnv;
    LineOfPoints activityCurve;
    LineOfPoints holdedActivityCurve;
    NeuralNetwork neuralNetwork;

    public final void init() {
        this.isAnApplet = true;
        this.realInit();
    }

    public static void main(String[] stringArray) {
        NeuralNetwork neuralNetwork;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        NeuralNetwork neuralNetwork2 = neuralNetwork = new NeuralNetwork();
        neuralNetwork2.getClass();
        PrimaryFrame primaryFrame = neuralNetwork2.new PrimaryFrame("Reseau de spiking neurones");
        neuralNetwork.realInit();
        primaryFrame.getContentPane().add("Center", neuralNetwork);
        primaryFrame.pack();
        ((Component)primaryFrame).setLocation(Math.abs((dimension.width - primaryFrame.getSize().width) / 2), Math.abs((dimension.height - primaryFrame.getSize().height) / 2));
        primaryFrame.show();
    }

    public final void realInit() {
        this.defaultFont = new Font("SanSerif", 0, 11);
        this.boldFont = new Font("SanSerif", 1, 11);
        this.bigFont = new Font("Dialog", 0, 10);
        this.bigBoldFont = new Font("Dialog", 1, 10);
        this.smallMonoFont = new Font("Monospaced", 0, 9);
        this.loweredBorder = BorderFactory.createLoweredBevelBorder();
        this.raisedBorder = BorderFactory.createRaisedBevelBorder();
        this.network = null;
        this.netX = 0;
        this.netY = 0;
        this.populationActivity = new PopulationActivity(0, 0.0);
        this.cp = this.getContentPane();
        this.cp.setLayout(new GridBagLayout());
        this.headerCnv = new TitleCanvas();
        this.headerCnv.addActionListener(this.headerCnv);
        this.computeBtn = new StartJButton();
        this.stopBtn = new StopJButton();
        this.time = new DoubleGI(0.0, 5, "Temps courant", 1, 0);
        this.time.setFontLabels(this.defaultFont);
        this.time.setDecimales(5);
        this.time.setLimitedDecimales(true);
        this.time.field.setOpaque(true);
        this.time.field.setEditable(false);
        this.time.field.setHorizontalAlignment(0);
        this.time.setToolTipText("Horloge de la simulation.");
        this.tMax = new DoubleGI(200.0, 10, "Temps [ms]", 3, 2);
        this.tMax.setFontLabels(this.defaultFont);
        this.tMax.setValidityDomaine(1.0E-15, Double.MAX_VALUE);
        this.tMax.setToolTipText("Temps maximum de la simulation.");
        this.deltaT = new DoubleGI(0.5, 10, "delta t [ms]", 3, 2);
        this.deltaT.onBack();
        this.deltaT.setFontLabels(this.defaultFont);
        this.deltaT.setValidityDomaine(1.0E-15, Double.MAX_VALUE);
        this.deltaT.setToolTipText("Pas d'integration (discretisation).");
        PrimitiveTypeGroup primitiveTypeGroup = new PrimitiveTypeGroup();
        primitiveTypeGroup.add(this.tMax);
        primitiveTypeGroup.add(this.deltaT);
        this.networkView = new NetworkView(500, 300, this.defaultFont);
        this.networkView.setBorder(new EtchedBorder());
        this.networkUI = new NetworkUI();
        this.externalUI = new ExternalUI();
        this.initialExternalUI = new InitialExternalUI();
        this.activityUI = new ActivityUI();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(this.networkUI.getTitle(), this.networkUI.getIcon(), this.networkUI, this.networkUI.getToolTip());
        this.tabbedPane.addTab(this.externalUI.getTitle(), this.externalUI.getIcon(), this.externalUI, this.externalUI.getToolTip());
        this.tabbedPane.addTab(this.initialExternalUI.getTitle(), this.initialExternalUI.getIcon(), this.initialExternalUI, this.initialExternalUI.getToolTip());
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.setFont(this.defaultFont);
        Constraints constraints = new Constraints();
        this.cp.add((Component)this.headerCnv, constraints.setAndGet(0, 0, 1, 1, 2, 0, 0, 0, 0, 0, 0, 17, 0.1, 0.0));
        this.cp.add((Component)primitiveTypeGroup, constraints.setAndGet(1, 0, 1, 1, 2, 0, 0, 0, 0, 4, 4, 10, 0.4, 0.0));
        this.cp.add((Component)this.time, constraints.setAndGet(2, 0, 1, 1, 2, 0, 0, 0, 0, 4, 4, 17, 0.2, 0.0));
        this.cp.add((Component)this.computeBtn, constraints.setAndGet(3, 0, -1, 1, 2, 0, 0, 0, 0, 1, 0, 13, 0.3, 0.0));
        this.cp.add((Component)this.stopBtn, constraints.setAndGet(4, 0, 0, 1, 2, 0, 0, 0, 0, 1, 0, 13, 0.3, 0.0));
        this.cp.add((Component)this.networkView, constraints.setAndGet(0, 1, 0, 1, 1, 0, 0, 2, 2, 2, 2, 10, 1.0, 0.3));
        this.cp.add((Component)this.tabbedPane, constraints.setAndGet(0, 2, 1, 1, 0, 0, 0, 2, 0, 2, 2, 10, 0.0, 1.0));
        this.cp.add((Component)this.activityUI, constraints.setAndGet(1, 2, 0, 1, 1, 0, 0, 2, 0, 2, 2, 10, 1.0, 1.0));
        ToolTipManager.sharedInstance().setEnabled(true);
        ToolTipManager.sharedInstance().setInitialDelay(1000);
        ToolTipManager.sharedInstance().setDismissDelay(8000);
        ToolTipManager.sharedInstance().setReshowDelay(2000);
        this.neuralNetwork = this;
    }

    public void run() {
        int n;
        int n2;
        int n3;
        double d = this.durationInitialPhase.getValue() * -0.001;
        double d2 = this.tMax.getValue() * 0.001;
        double d3 = this.deltaT.getValue() * 0.001;
        Graphics graphics = this.time.signifiant.getGraphics();
        boolean bl = d < 0.0;
        this.populationActivity.setDeltaT(d3);
        Clock.sharedInstance.setDeltaT(d3);
        this.initialExternalUI.applyGenerator();
        if (bl) {
            Clock.sharedInstance.setInitialTime(this.durationInitialPhase.getValue() * -0.001);
            Clock.sharedInstance.setMaximalTime(0.0);
            this.initialGenerator.resetTime();
        } else {
            Clock.sharedInstance.setInitialTime(0.0);
            Clock.sharedInstance.setMaximalTime(d2);
            this.generator.resetTime();
        }
        Clock.sharedInstance.resetTime();
        this.populationActivity.resetTime();
        this.activityCurve.resetTime();
        int n4 = this.network.length;
        while (n4 > 0) {
            --n4;
            int n5 = this.network[0].length;
            while (n5 > 0) {
                this.network[n4][--n5].resetTime();
            }
        }
        this.activityCnv.changeVirtualBounds(0.02, 0.0, d2, 0.05, 0.0, 1.0 / d3);
        this.activityCurve.ensureCapacity((int)(d2 / d3));
        this.activityCnv.update();
        double d4 = 0.0;
        if (bl) {
            while (Clock.sharedInstance.tic()) {
                this.initialGenerator.computeNextTic();
                d4 = Clock.sharedInstance.getTime();
                n3 = this.network.length;
                while (n3 > 0) {
                    --n3;
                    n2 = this.network[0].length;
                    while (n2 > 0) {
                        this.network[n3][--n2].computeNextTic();
                    }
                }
                Clock.sharedInstance.updateOutput();
                this.initialGenerator.updateOutput();
                n2 = this.network.length;
                while (n2 > 0) {
                    --n2;
                    n = this.network[0].length;
                    while (n > 0) {
                        this.network[n2][--n].updateOutput();
                    }
                }
                this.time.setValue(d4 * 1000.0);
                this.time.signifiant.repaint();
                this.networkView.repaintNeurons();
            }
            Clock.sharedInstance.setInitialTime(0.0);
            Clock.sharedInstance.setMaximalTime(d2);
            this.generator.resetTime();
        }
        NeuronBaseModel.resetFireCounter();
        this.externalUI.applyGenerator();
        while (Clock.sharedInstance.tic()) {
            this.generator.computeNextTic();
            d4 = Clock.sharedInstance.getTime();
            this.populationActivity.computeNextTic();
            this.activityCurve.computeNextTic();
            n3 = this.network.length;
            while (n3 > 0) {
                --n3;
                n2 = this.network[0].length;
                while (n2 > 0) {
                    this.network[n3][--n2].computeNextTic();
                }
            }
            Clock.sharedInstance.updateOutput();
            this.generator.updateOutput();
            this.populationActivity.updateOutput();
            n2 = this.network.length;
            while (n2 > 0) {
                --n2;
                n = this.network[0].length;
                while (n > 0) {
                    this.network[n2][--n].updateOutput();
                }
            }
            this.time.setValue(d4 * 1000.0);
            this.time.signifiant.repaint();
            this.networkView.repaintNeurons();
        }
        this.time.setValue(d4 * 1000.0);
        Coordinate2D coordinate2D = this.activityCurve.getVerticalBounds();
        Coordinate2D coordinate2D2 = this.holdedActivityCurve.getVerticalBounds();
        coordinate2D.setC0(Math.min(0.0, coordinate2D.getC0()));
        coordinate2D.setC1(Math.max(0.0, coordinate2D.getC1()));
        coordinate2D.setC0(Math.min(coordinate2D.getC0(), coordinate2D2.getC1()));
        coordinate2D.setC1(Math.max(coordinate2D.getC1(), coordinate2D2.getC1()));
        if (coordinate2D.getC1() - coordinate2D.getC0() < 1.0E-15 && Math.abs(coordinate2D.getC0()) < 1.0E-15) {
            coordinate2D.setC1(1.0);
            coordinate2D.setC0(0.0);
        }
        this.activityCnv.changeVirtualBounds(0.02, 0.0, d2, 0.1, coordinate2D.getC0(), coordinate2D.getC1());
        this.repaint();
    }

    public final void start() {
    }

    private class ExternalUI
    extends JPanel
    implements ItemListener,
    ListSelectionListener {
        public JComboBox generatorsChoice;
        public JList list;
        public DefaultListModel connected = new DefaultListModel();
        JPanel cards;
        JRadioButton allRb;
        JRadioButton noneRb;
        JRadioButton customRb;
        ButtonGroup neuronSelectionMode;
        NeuronSelectMode listener;
        CircularGenerator circularGenerator;
        CircularGeneratorGI circularGenInterface;
        PositiveGenerator positiveGenerator;
        PositiveGeneratorGI positiveGenInterface;
        SquareGenerator squareGenerator;
        SquareGeneratorGI squareGenInterface;
        PulsesGenerator pulsesGenerator;
        PulsesGeneratorGI pulsesGenInterface;
        RandomPulsesGenerator randomPulsesGenerator;
        RandomPulsesGeneratorGI randomPulsesGenInterface;
        NoisyGenerator noisyGenerator;
        NoisyGeneratorGI noisyGenInterface;
        StepGenerator stepGenerator;
        StepGeneratorGI stepGenInterface;
        DiscreteNoisyGenerator discreteNoisyGenerator;
        DiscreteNoisyGeneratorGI discreteNoisyGenInterface;
        SignalGeneratorGI generatorInterface;

        ExternalUI() {
            this.setLayout(new GridBagLayout());
            Constraints constraints = new Constraints();
            TitledBorder titledBorder = new TitledBorder(new EmptyBorder(0, 0, 0, 0), "Parametre du courant externe", 2, 0, NeuralNetwork.this.bigFont);
            this.setBorder(titledBorder);
            this.init();
            NeuralNetwork.this.generator = this.circularGenerator;
            this.generatorInterface = this.circularGenInterface;
            this.generatorsChoice.setSelectedItem(this.generatorInterface.getSymbolic());
            this.allRb = new JRadioButton("Tous");
            this.allRb.setFont(NeuralNetwork.this.defaultFont);
            this.allRb.setMnemonic('T');
            this.noneRb = new JRadioButton("Aucun");
            this.noneRb.setFont(NeuralNetwork.this.defaultFont);
            this.noneRb.setMnemonic('A');
            this.customRb = new JRadioButton("Personnalise");
            this.customRb.setFont(NeuralNetwork.this.defaultFont);
            this.customRb.setMnemonic('P');
            this.allRb.setVerticalTextPosition(3);
            this.allRb.setHorizontalTextPosition(0);
            this.noneRb.setVerticalTextPosition(3);
            this.noneRb.setHorizontalTextPosition(0);
            this.customRb.setVerticalTextPosition(3);
            this.customRb.setHorizontalTextPosition(0);
            this.neuronSelectionMode = new ButtonGroup();
            this.neuronSelectionMode.add(this.allRb);
            this.neuronSelectionMode.add(this.customRb);
            this.neuronSelectionMode.add(this.noneRb);
            this.noneRb.setSelected(true);
            this.listener = new NeuronSelectMode();
            this.allRb.addActionListener(this.listener);
            this.noneRb.addActionListener(this.listener);
            this.customRb.addActionListener(this.listener);
            this.list = new JList(this.connected);
            this.list.setSelectionMode(2);
            this.list.addListSelectionListener(this);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            this.netSizeChange();
            this.add((Component)this.generatorsChoice, constraints.setAndGet(0, 0, 1, 1, 0, 0, 0, 0, 0, 2, 2, 11, 0.75, 0.0));
            this.add((Component)this.cards, constraints.setAndGet(0, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 10, 0.75, 1.0));
            this.add((Component)new JSeparator(), constraints.setAndGet(1, 0, 1, 0, 3, 0, 0, 2, 2, 4, 4, 10, 0.1, 1.0));
            this.add((Component)this.allRb, constraints.setAndGet(2, 0, 1, 1, 0, 0, 0, 0, 0, 2, 0, 10, 0.05, 0.0));
            this.add((Component)this.noneRb, constraints.setAndGet(3, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0.05, 0.0));
            this.add((Component)this.customRb, constraints.setAndGet(4, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0.05, 0.0));
            this.add((Component)jScrollPane, constraints.setAndGet(2, 1, 0, 0, 1, 0, 0, 5, 0, 2, 2, 10, 0.15, 1.0));
        }

        public void applyGenerator() {
            this.generatorInterface.synchronizeSignifie(NeuralNetwork.this.generator);
            int n = 0;
            int n2 = 0;
            while (n2 < NeuralNetwork.this.netY) {
                int n3 = 0;
                while (n3 < NeuralNetwork.this.netX) {
                    NeuralNetwork.this.network[n2][n3].removeExternalInputs();
                    if (this.list.isSelectedIndex(n++)) {
                        NeuralNetwork.this.network[n2][n3].addExternalInput(NeuralNetwork.this.generator);
                    }
                    ++n3;
                }
                ++n2;
            }
        }

        public Icon getIcon() {
            return null;
        }

        public String getTitle() {
            return "Courant externe";
        }

        public String getToolTip() {
            return "Panneau de controle de la source externe.";
        }

        public void init() {
            this.generatorsChoice = new JComboBox();
            this.generatorsChoice.setBorder(new CompoundBorder(this.generatorsChoice.getBorder(), new EmptyBorder(2, 2, 2, 2)));
            this.generatorsChoice.setRenderer(new MyCellRenderer());
            this.generatorsChoice.setMaximumRowCount(4);
            this.generatorsChoice.setLightWeightPopupEnabled(true);
            this.generatorsChoice.addItemListener(this);
            this.cards = new JPanel();
            this.cards.setLayout(new CardLayout());
            this.circularGenerator = new CircularGenerator();
            this.circularGenerator.init(1.1E-7, 1.0E-8, 100.0, 0.0);
            this.circularGenInterface = new CircularGeneratorGI(this.circularGenerator);
            this.circularGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.circularGenInterface.getInterface(), Integer.toString(this.circularGenInterface.getSymbolic().hashCode()));
            this.stepGenerator = new StepGenerator();
            this.stepGenerator.init(1.1E-7, 1.0E-7, 0.5);
            this.stepGenInterface = new StepGeneratorGI(this.stepGenerator);
            this.stepGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.stepGenInterface.getInterface(), Integer.toString(this.stepGenInterface.getSymbolic().hashCode()));
            this.pulsesGenerator = new PulsesGenerator(1.1E-7, 3, 1.0E-8, 1);
            this.pulsesGenInterface = new PulsesGeneratorGI(this.pulsesGenerator);
            this.pulsesGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.pulsesGenInterface.getInterface(), Integer.toString(this.pulsesGenInterface.getSymbolic().hashCode()));
            this.randomPulsesGenerator = new RandomPulsesGenerator(1.1E-7, 75.0, 1.0E-8, 1, System.currentTimeMillis());
            this.randomPulsesGenInterface = new RandomPulsesGeneratorGI(this.randomPulsesGenerator);
            this.randomPulsesGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.randomPulsesGenInterface.getInterface(), Integer.toString(this.randomPulsesGenInterface.getSymbolic().hashCode()));
            this.noisyGenerator = new NoisyGenerator(1.1E-7, 5.0E-7, 10, System.currentTimeMillis());
            this.noisyGenInterface = new NoisyGeneratorGI(this.noisyGenerator);
            this.noisyGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.noisyGenInterface.getInterface(), Integer.toString(this.noisyGenInterface.getSymbolic().hashCode()));
            this.discreteNoisyGenerator = new DiscreteNoisyGenerator();
            this.discreteNoisyGenerator.setOffset(1.1E-7);
            this.discreteNoisyGenerator.setAmplitude(5.0E-7);
            this.discreteNoisyGenInterface = new DiscreteNoisyGeneratorGI(this.discreteNoisyGenerator);
            this.discreteNoisyGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.discreteNoisyGenInterface.getInterface(), Integer.toString(this.discreteNoisyGenInterface.getSymbolic().hashCode()));
            this.positiveGenerator = new PositiveGenerator();
            this.positiveGenerator.init(1.1E-7, 3.0E-7, 100.0, 0.0);
            this.positiveGenInterface = new PositiveGeneratorGI(this.positiveGenerator);
            this.positiveGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.positiveGenInterface.getInterface(), Integer.toString(this.positiveGenInterface.getSymbolic().hashCode()));
            this.squareGenerator = new SquareGenerator();
            this.squareGenerator.init(1.1E-7, 5.0E-6, 0.0, new double[]{0.03, 0.01, 0.02, 0.01, 0.03, 0.01, 0.02, 0.01});
            this.squareGenInterface = new SquareGeneratorGI(this.squareGenerator);
            this.squareGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.squareGenInterface.getInterface(), Integer.toString(this.squareGenInterface.getSymbolic().hashCode()));
            this.generatorsChoice.addItem(this.circularGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.stepGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.pulsesGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.randomPulsesGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.noisyGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.positiveGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.squareGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.discreteNoisyGenInterface.getSymbolic());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ((CardLayout)this.cards.getLayout()).show(this.cards, Integer.toString(this.generatorsChoice.getSelectedItem().hashCode()));
            switch (this.generatorsChoice.getSelectedIndex()) {
                case 0: {
                    NeuralNetwork.this.generator = this.circularGenerator;
                    this.generatorInterface = this.circularGenInterface;
                    break;
                }
                case 1: {
                    NeuralNetwork.this.generator = this.stepGenerator;
                    this.generatorInterface = this.stepGenInterface;
                    break;
                }
                case 2: {
                    NeuralNetwork.this.generator = this.pulsesGenerator;
                    this.generatorInterface = this.pulsesGenInterface;
                    break;
                }
                case 3: {
                    NeuralNetwork.this.generator = this.randomPulsesGenerator;
                    this.generatorInterface = this.randomPulsesGenInterface;
                    break;
                }
                case 4: {
                    NeuralNetwork.this.generator = this.noisyGenerator;
                    this.generatorInterface = this.noisyGenInterface;
                    break;
                }
                case 5: {
                    NeuralNetwork.this.generator = this.positiveGenerator;
                    this.generatorInterface = this.positiveGenInterface;
                    break;
                }
                case 6: {
                    NeuralNetwork.this.generator = this.squareGenerator;
                    this.generatorInterface = this.squareGenInterface;
                    break;
                }
                case 7: {
                    NeuralNetwork.this.generator = this.discreteNoisyGenerator;
                    this.generatorInterface = this.discreteNoisyGenInterface;
                    break;
                }
            }
        }

        public void netSizeChange() {
            this.connected.removeAllElements();
            int n = 0;
            while (n < NeuralNetwork.this.netY) {
                int n2 = 0;
                while (n2 < NeuralNetwork.this.netX) {
                    this.connected.addElement(NeuralNetwork.this.network[n][n2].toString());
                    ++n2;
                }
                ++n;
            }
            this.noneRb.setSelected(true);
            this.list.clearSelection();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = this.list.getSelectedIndices();
            if (nArray.length == this.connected.getSize()) {
                this.allRb.setSelected(true);
            } else if (nArray.length == 0) {
                this.noneRb.setSelected(true);
            } else {
                this.customRb.setSelected(true);
            }
        }

        protected class NeuronSelectMode
        implements ActionListener {
            protected NeuronSelectMode() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (ExternalUI.this.allRb.isSelected()) {
                    ExternalUI.this.list.setSelectionInterval(0, ExternalUI.this.connected.getSize() - 1);
                } else {
                    ExternalUI.this.list.clearSelection();
                    ExternalUI.this.noneRb.setSelected(true);
                }
            }
        }
    }

    private class InitialExternalUI
    extends JPanel
    implements ItemListener,
    ListSelectionListener {
        public JComboBox generatorsChoice;
        public JList list;
        public DefaultListModel connected = new DefaultListModel();
        JPanel cards;
        JRadioButton allRb;
        JRadioButton noneRb;
        JRadioButton customRb;
        ButtonGroup neuronSelectionMode;
        NeuronSelectMode listener;
        CircularGenerator circularGenerator;
        CircularGeneratorGI circularGenInterface;
        PositiveGenerator positiveGenerator;
        PositiveGeneratorGI positiveGenInterface;
        SquareGenerator squareGenerator;
        SquareGeneratorGI squareGenInterface;
        PulsesGenerator pulsesGenerator;
        PulsesGeneratorGI pulsesGenInterface;
        RandomPulsesGenerator randomPulsesGenerator;
        RandomPulsesGeneratorGI randomPulsesGenInterface;
        NoisyGenerator noisyGenerator;
        NoisyGeneratorGI noisyGenInterface;
        StepGenerator stepGenerator;
        StepGeneratorGI stepGenInterface;
        DiscreteNoisyGenerator discreteNoisyGenerator;
        DiscreteNoisyGeneratorGI discreteNoisyGenInterface;
        SignalGeneratorGI generatorInterface;

        InitialExternalUI() {
            this.setLayout(new GridBagLayout());
            Constraints constraints = new Constraints();
            TitledBorder titledBorder = new TitledBorder(new EmptyBorder(0, 0, 0, 0), "Generateur de courant pour la phase initiale", 2, 0, NeuralNetwork.this.bigFont);
            this.setBorder(titledBorder);
            this.init();
            NeuralNetwork.this.initialGenerator = this.noisyGenerator;
            this.generatorInterface = this.noisyGenInterface;
            this.generatorsChoice.setSelectedItem(this.generatorInterface.getSymbolic());
            this.allRb = new JRadioButton("Tous");
            this.allRb.setFont(NeuralNetwork.this.defaultFont);
            this.noneRb = new JRadioButton("Aucun");
            this.noneRb.setFont(NeuralNetwork.this.defaultFont);
            this.customRb = new JRadioButton("Personnalise");
            this.customRb.setFont(NeuralNetwork.this.defaultFont);
            this.allRb.setMnemonic('T');
            this.noneRb.setMnemonic('A');
            this.customRb.setMnemonic('P');
            this.allRb.setVerticalTextPosition(3);
            this.allRb.setHorizontalTextPosition(0);
            this.noneRb.setVerticalTextPosition(3);
            this.noneRb.setHorizontalTextPosition(0);
            this.customRb.setVerticalTextPosition(3);
            this.customRb.setHorizontalTextPosition(0);
            this.neuronSelectionMode = new ButtonGroup();
            this.neuronSelectionMode.add(this.allRb);
            this.neuronSelectionMode.add(this.customRb);
            this.neuronSelectionMode.add(this.noneRb);
            this.noneRb.setSelected(true);
            NeuralNetwork.this.durationInitialPhase = new DoubleGI(0.0, 10, "Temps [ms]", 3, 2);
            NeuralNetwork.this.durationInitialPhase.setFontLabels(NeuralNetwork.this.defaultFont);
            NeuralNetwork.this.durationInitialPhase.setValidityDomaine(0.0, Double.MAX_VALUE);
            NeuralNetwork.this.durationInitialPhase.setToolTipText("Duree de la phase initiale (determination d'une activit\u00e9 initiale).");
            this.listener = new NeuronSelectMode();
            this.allRb.addActionListener(this.listener);
            this.noneRb.addActionListener(this.listener);
            this.customRb.addActionListener(this.listener);
            this.list = new JList(this.connected);
            this.list.setSelectionMode(2);
            this.list.addListSelectionListener(this);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            this.netSizeChange();
            this.add((Component)this.generatorsChoice, constraints.setAndGet(0, 0, 1, 1, 0, 0, 0, 0, 0, 2, 2, 11, 0.75, 0.0));
            this.add((Component)this.cards, constraints.setAndGet(0, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 10, 0.75, 0.85));
            this.add((Component)new JSeparator(), constraints.setAndGet(0, 2, 1, 1, 1, 0, 0, 2, 2, 2, 0, 10, 0.75, 0.05));
            this.add((Component)NeuralNetwork.this.durationInitialPhase, constraints.setAndGet(0, 3, 1, 1, 1, 0, 0, 0, 0, 2, 0, 10, 0.75, 0.1));
            this.add((Component)new JSeparator(), constraints.setAndGet(1, 0, 1, 0, 3, 0, 0, 2, 2, 4, 4, 10, 0.1, 1.0));
            this.add((Component)this.allRb, constraints.setAndGet(2, 0, 1, 1, 0, 0, 0, 0, 0, 2, 0, 10, 0.05, 0.0));
            this.add((Component)this.noneRb, constraints.setAndGet(3, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0.05, 0.0));
            this.add((Component)this.customRb, constraints.setAndGet(4, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0.05, 0.0));
            this.add((Component)jScrollPane, constraints.setAndGet(2, 1, 0, 0, 1, 0, 0, 5, 0, 2, 2, 10, 0.15, 1.0));
        }

        public void applyGenerator() {
            this.generatorInterface.synchronizeSignifie(NeuralNetwork.this.initialGenerator);
            int n = 0;
            int n2 = 0;
            while (n2 < NeuralNetwork.this.netY) {
                int n3 = 0;
                while (n3 < NeuralNetwork.this.netX) {
                    NeuralNetwork.this.network[n2][n3].removeExternalInputs();
                    if (this.list.isSelectedIndex(n++)) {
                        NeuralNetwork.this.network[n2][n3].addExternalInput(NeuralNetwork.this.generator);
                    }
                    ++n3;
                }
                ++n2;
            }
        }

        public Icon getIcon() {
            return null;
        }

        public String getTitle() {
            return "Phase initiale";
        }

        public String getToolTip() {
            return "Panneau de controle de la phase initiale.";
        }

        public void init() {
            this.generatorsChoice = new JComboBox();
            this.generatorsChoice.setBorder(new CompoundBorder(this.generatorsChoice.getBorder(), new EmptyBorder(2, 2, 2, 2)));
            this.generatorsChoice.setRenderer(new MyCellRenderer());
            this.generatorsChoice.setMaximumRowCount(4);
            this.generatorsChoice.setLightWeightPopupEnabled(true);
            this.generatorsChoice.addItemListener(this);
            this.cards = new JPanel();
            this.cards.setLayout(new CardLayout());
            this.circularGenerator = new CircularGenerator();
            this.circularGenerator.init(1.1E-7, 1.0E-8, 100.0, 0.0);
            this.circularGenInterface = new CircularGeneratorGI(this.circularGenerator);
            this.circularGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.circularGenInterface.getInterface(), Integer.toString(this.circularGenInterface.getSymbolic().hashCode()));
            this.stepGenerator = new StepGenerator();
            this.stepGenerator.init(1.1E-7, 1.0E-7, 0.5);
            this.stepGenInterface = new StepGeneratorGI(this.stepGenerator);
            this.stepGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.stepGenInterface.getInterface(), Integer.toString(this.stepGenInterface.getSymbolic().hashCode()));
            this.pulsesGenerator = new PulsesGenerator(1.1E-7, 3, 1.0E-8, 1);
            this.pulsesGenInterface = new PulsesGeneratorGI(this.pulsesGenerator);
            this.pulsesGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.pulsesGenInterface.getInterface(), Integer.toString(this.pulsesGenInterface.getSymbolic().hashCode()));
            this.randomPulsesGenerator = new RandomPulsesGenerator(1.1E-7, 75.0, 1.0E-8, 1, System.currentTimeMillis());
            this.randomPulsesGenInterface = new RandomPulsesGeneratorGI(this.randomPulsesGenerator);
            this.randomPulsesGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.randomPulsesGenInterface.getInterface(), Integer.toString(this.randomPulsesGenInterface.getSymbolic().hashCode()));
            this.noisyGenerator = new NoisyGenerator(1.1E-7, 5.0E-7, 10, System.currentTimeMillis());
            this.noisyGenInterface = new NoisyGeneratorGI(this.noisyGenerator);
            this.noisyGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.noisyGenInterface.getInterface(), Integer.toString(this.noisyGenInterface.getSymbolic().hashCode()));
            this.discreteNoisyGenerator = new DiscreteNoisyGenerator();
            this.discreteNoisyGenerator.setOffset(1.1E-7);
            this.discreteNoisyGenerator.setAmplitude(5.0E-7);
            this.discreteNoisyGenInterface = new DiscreteNoisyGeneratorGI(this.discreteNoisyGenerator);
            this.discreteNoisyGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.discreteNoisyGenInterface.getInterface(), Integer.toString(this.discreteNoisyGenInterface.getSymbolic().hashCode()));
            this.positiveGenerator = new PositiveGenerator();
            this.positiveGenerator.init(1.1E-7, 3.0E-7, 100.0, 0.0);
            this.positiveGenInterface = new PositiveGeneratorGI(this.positiveGenerator);
            this.positiveGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.positiveGenInterface.getInterface(), Integer.toString(this.positiveGenInterface.getSymbolic().hashCode()));
            this.squareGenerator = new SquareGenerator();
            this.squareGenerator.init(1.1E-7, 5.0E-6, 0.0, new double[]{0.03, 0.01, 0.02, 0.01, 0.03, 0.01, 0.02, 0.01});
            this.squareGenInterface = new SquareGeneratorGI(this.squareGenerator);
            this.squareGenInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.cards.add((Component)this.squareGenInterface.getInterface(), Integer.toString(this.squareGenInterface.getSymbolic().hashCode()));
            this.generatorsChoice.addItem(this.circularGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.stepGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.pulsesGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.randomPulsesGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.noisyGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.positiveGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.squareGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.discreteNoisyGenInterface.getSymbolic());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ((CardLayout)this.cards.getLayout()).show(this.cards, Integer.toString(this.generatorsChoice.getSelectedItem().hashCode()));
            switch (this.generatorsChoice.getSelectedIndex()) {
                case 0: {
                    NeuralNetwork.this.initialGenerator = this.circularGenerator;
                    this.generatorInterface = this.circularGenInterface;
                    break;
                }
                case 1: {
                    NeuralNetwork.this.initialGenerator = this.stepGenerator;
                    this.generatorInterface = this.stepGenInterface;
                    break;
                }
                case 2: {
                    NeuralNetwork.this.initialGenerator = this.pulsesGenerator;
                    this.generatorInterface = this.pulsesGenInterface;
                    break;
                }
                case 3: {
                    NeuralNetwork.this.initialGenerator = this.randomPulsesGenerator;
                    this.generatorInterface = this.randomPulsesGenInterface;
                    break;
                }
                case 4: {
                    NeuralNetwork.this.initialGenerator = this.noisyGenerator;
                    this.generatorInterface = this.noisyGenInterface;
                    break;
                }
                case 5: {
                    NeuralNetwork.this.initialGenerator = this.positiveGenerator;
                    this.generatorInterface = this.positiveGenInterface;
                    break;
                }
                case 6: {
                    NeuralNetwork.this.initialGenerator = this.squareGenerator;
                    this.generatorInterface = this.squareGenInterface;
                    break;
                }
                case 7: {
                    NeuralNetwork.this.initialGenerator = this.discreteNoisyGenerator;
                    this.generatorInterface = this.discreteNoisyGenInterface;
                    break;
                }
            }
        }

        public void netSizeChange() {
            this.connected.removeAllElements();
            int n = 0;
            while (n < NeuralNetwork.this.netY) {
                int n2 = 0;
                while (n2 < NeuralNetwork.this.netX) {
                    this.connected.addElement(NeuralNetwork.this.network[n][n2].toString());
                    ++n2;
                }
                ++n;
            }
            this.noneRb.setSelected(true);
            this.list.clearSelection();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = this.list.getSelectedIndices();
            if (nArray.length == this.connected.getSize()) {
                this.allRb.setSelected(true);
            } else if (nArray.length == 0) {
                this.noneRb.setSelected(true);
            } else {
                this.customRb.setSelected(true);
            }
        }

        protected class NeuronSelectMode
        implements ActionListener {
            protected NeuronSelectMode() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (InitialExternalUI.this.allRb.isSelected()) {
                    InitialExternalUI.this.list.setSelectionInterval(0, InitialExternalUI.this.connected.getSize() - 1);
                } else {
                    InitialExternalUI.this.list.clearSelection();
                    InitialExternalUI.this.noneRb.setSelected(true);
                }
            }
        }
    }

    private class NeuronUI
    extends JPanel {
        NeuronUI() {
        }

        public Icon getIcon() {
            return null;
        }

        public String getTitle() {
            return "Neuron Info";
        }

        public String getToolTip() {
            return "Non Impl\u00e9ment\u00e9! (Panneau de control d'un neurone)";
        }
    }

    private class NetworkUI
    extends JPanel
    implements ItemListener,
    ActionListener {
        String[] topologies = new String[]{"Global", "4 voisins", "8 voisins"};
        JComboBox topologieChoice;
        JButton validateBtn;
        LongGI netHeightCtrl;
        LongGI netWidthCtrl;
        DoubleGI JoCtrl;
        DoubleGI delayCtrl;
        int currentTopo;
        int currentModel;
        JComboBox neuronsChoice;
        JPanel cardsNeuron;
        NeuronBaseModelGI neuronInterface;
        IntegrateAndFireGI ifInterface;
        SRMLongMemoryGI srInterface;
        SRMShortMemoryGI srShortInterface;

        NetworkUI() {
            this.setLayout(new GridBagLayout());
            Constraints constraints = new Constraints();
            this.initNeuronUIs();
            this.initTopologieUIs();
            this.netHeightCtrl = new LongGI(5L, 5, "Nb. lines", 3, 2);
            this.netHeightCtrl.setFontLabels(NeuralNetwork.this.defaultFont);
            this.netHeightCtrl.setValidityDomaine(1L, Integer.MAX_VALUE);
            this.netHeightCtrl.setToolTipText("Taille du reseau: nombre de lignes.");
            this.netWidthCtrl = new LongGI(5L, 5, "Nb. cols.", 3, 2);
            this.netWidthCtrl.setFontLabels(NeuralNetwork.this.defaultFont);
            this.netWidthCtrl.setValidityDomaine(1L, Integer.MAX_VALUE);
            this.netWidthCtrl.setToolTipText("Taille du reseau: nombre de rangees.");
            this.JoCtrl = new DoubleGI(0.001, 10, "w (Jo)", 3, 2);
            this.JoCtrl.setFontLabels(NeuralNetwork.this.defaultFont);
            this.JoCtrl.setToolTipText("Coefficient d'efficacite des synapses.");
            this.delayCtrl = new DoubleGI(10.0, 10, "Delai [ms]", 3, 2);
            this.delayCtrl.setFontLabels(NeuralNetwork.this.defaultFont);
            this.delayCtrl.setValidityDomaine(0.0, Double.MAX_VALUE);
            this.delayCtrl.setToolTipText("Delai de transmission des axones.");
            PrimitiveTypeGroup primitiveTypeGroup = new PrimitiveTypeGroup();
            primitiveTypeGroup.add(this.netHeightCtrl);
            primitiveTypeGroup.add(this.netWidthCtrl);
            primitiveTypeGroup.add(this.JoCtrl);
            primitiveTypeGroup.add(this.delayCtrl);
            JLabel jLabel = new JLabel("Parametres du reseau");
            jLabel.setFont(NeuralNetwork.this.defaultFont);
            this.validateBtn = new JButton("Validation");
            this.validateBtn.setFont(NeuralNetwork.this.defaultFont);
            this.validateBtn.setBorderPainted(true);
            this.validateBtn.setOpaque(true);
            this.validateBtn.setFocusPainted(false);
            this.validateBtn.setRolloverEnabled(false);
            this.validateBtn.getAccessibleContext().setAccessibleName("NetValidate");
            this.validateBtn.setToolTipText("Generation du reseau.");
            this.validateBtn.addActionListener(this);
            this.setEnabled(true);
            JLabel jLabel2 = new JLabel("Parametres du reseau");
            jLabel2.setFont(NeuralNetwork.this.bigFont);
            JLabel jLabel3 = new JLabel("Parametres des neurones");
            jLabel3.setFont(NeuralNetwork.this.bigFont);
            this.add((Component)jLabel2, constraints.setAndGet(0, 0, 1, 1, 3, 0, 0, 0, 5, 2, 0, 10, 0.5, 0.0));
            this.add((Component)this.topologieChoice, constraints.setAndGet(0, 1, 1, 1, 1, 5, 2, 0, 5, 2, 0, 10, 0.5, 0.0));
            this.add((Component)jLabel, constraints.setAndGet(0, 2, 1, 1, 2, 0, 0, 2, 2, 2, 0, 17, 0.5, 0.0));
            this.add((Component)primitiveTypeGroup, constraints.setAndGet(0, 3, 1, 1, 1, 0, 0, 0, 0, 2, 0, 10, 0.5, 0.3));
            this.add((Component)this.validateBtn, constraints.setAndGet(0, 7, 1, 1, 0, 0, 0, 0, 0, 2, 0, 10, 0.5, 0.3));
            this.add((Component)new JSeparator(), constraints.setAndGet(1, 0, 1, 0, 3, 0, 0, 2, 2, 5, 5, 10, 0.1, 1.0));
            this.add((Component)jLabel3, constraints.setAndGet(2, 0, 1, 1, 0, 0, 0, 0, 0, 4, 0, 11, 0.4, 0.0));
            this.add((Component)this.neuronsChoice, constraints.setAndGet(2, 1, 1, 1, 0, 0, 0, 0, 0, 4, 0, 10, 0.4, 0.0));
            this.add((Component)this.cardsNeuron, constraints.setAndGet(2, 2, 1, 0, 1, 0, 0, 0, 0, 4, 0, 10, 0.4, 1.0));
            this.neuronInterface = this.ifInterface;
            this.currentTopo = -1;
            this.currentModel = -1;
            NeuralNetwork.this.netX = 0;
            NeuralNetwork.this.netY = 0;
            this.actionPerformed(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            this.setEnabled(false);
            int n3 = 0;
            int n4 = (int)this.netHeightCtrl.getValue();
            int n5 = (int)this.netWidthCtrl.getValue();
            boolean bl = n4 != NeuralNetwork.this.netX || n5 != NeuralNetwork.this.netY;
            boolean bl2 = this.topologieChoice.getSelectedIndex() != this.currentTopo;
            boolean bl3 = this.currentModel != this.neuronsChoice.getSelectedIndex();
            this.currentModel = this.neuronsChoice.getSelectedIndex();
            NeuralNetwork.this.netX = n4;
            NeuralNetwork.this.netY = n5;
            double d = this.delayCtrl.getValue() * 0.001;
            double d2 = this.JoCtrl.getValue() * 1.0E-6;
            if (bl || bl3) {
                if (bl) {
                    NeuralNetwork.this.populationActivity.setPopulationSize(NeuralNetwork.this.netX * NeuralNetwork.this.netY);
                    NeuralNetwork.this.network = new NeuronBaseModel[NeuralNetwork.this.netY][NeuralNetwork.this.netX];
                }
                NeuralNetwork.this.networkView.removeItems();
                NeuralNetwork.this.networkView.setNetworkSize(NeuralNetwork.this.netX, NeuralNetwork.this.netY);
                n2 = 0;
                while (n2 < NeuralNetwork.this.netY) {
                    n = 0;
                    while (n < NeuralNetwork.this.netX) {
                        switch (this.currentModel) {
                            case 0: {
                                NeuralNetwork.this.network[n2][n] = new IFDrawable(n3++, NeuralNetwork.this.networkView);
                                break;
                            }
                            case 1: {
                                NeuralNetwork.this.network[n2][n] = new SRMLongDrawable(n3++, NeuralNetwork.this.networkView);
                                break;
                            }
                            case 2: {
                                NeuralNetwork.this.network[n2][n] = new SRMShortDrawable(n3++, NeuralNetwork.this.networkView);
                                break;
                            }
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
            if (bl || bl2) {
                this.currentTopo = this.topologieChoice.getSelectedIndex();
                NeuralNetwork.this.networkView.setTopologie(this.currentTopo);
                n2 = 0;
                while (n2 < NeuralNetwork.this.netY) {
                    n = 0;
                    while (n < NeuralNetwork.this.netX) {
                        NeuralNetwork.this.network[n2][n].removeInputs();
                        ++n;
                    }
                    ++n2;
                }
                switch (this.currentTopo) {
                    case 0: {
                        int n6;
                        n = 0;
                        while (n < NeuralNetwork.this.netY) {
                            n6 = 0;
                            while (n6 < NeuralNetwork.this.netX) {
                                int n7 = 0;
                                while (n7 < NeuralNetwork.this.netY) {
                                    int n8 = 0;
                                    while (n8 < NeuralNetwork.this.netX) {
                                        NeuralNetwork.this.network[n][n6].addInput(NeuralNetwork.this.network[n7][n8], d2, d);
                                        ++n8;
                                    }
                                    ++n7;
                                }
                                ++n6;
                            }
                            ++n;
                        }
                        break;
                    }
                    case 2: {
                        int n6;
                        n = 0;
                        while (n < NeuralNetwork.this.netY) {
                            n6 = 0;
                            while (n6 < NeuralNetwork.this.netX) {
                                NeuralNetwork.this.network[n][n6].addInput(NeuralNetwork.this.network[(n + NeuralNetwork.this.netY - 1) % NeuralNetwork.this.netY][(n6 + NeuralNetwork.this.netX - 1) % NeuralNetwork.this.netX], d2, d);
                                NeuralNetwork.this.network[n][n6].addInput(NeuralNetwork.this.network[(n + 1) % NeuralNetwork.this.netY][(n6 + 1) % NeuralNetwork.this.netX], d2, d);
                                NeuralNetwork.this.network[n][n6].addInput(NeuralNetwork.this.network[(n + 1) % NeuralNetwork.this.netY][(n6 + NeuralNetwork.this.netX - 1) % NeuralNetwork.this.netX], d2, d);
                                NeuralNetwork.this.network[n][n6].addInput(NeuralNetwork.this.network[(n + NeuralNetwork.this.netY - 1) % NeuralNetwork.this.netY][(n6 + 1) % NeuralNetwork.this.netX], d2, d);
                                ++n6;
                            }
                            ++n;
                        }
                    }
                    case 1: {
                        int n6;
                        n = 0;
                        while (n < NeuralNetwork.this.netY) {
                            n6 = 0;
                            while (n6 < NeuralNetwork.this.netX) {
                                NeuralNetwork.this.network[n][n6].addInput(NeuralNetwork.this.network[(n + NeuralNetwork.this.netY - 1) % NeuralNetwork.this.netY][n6], d2, d);
                                NeuralNetwork.this.network[n][n6].addInput(NeuralNetwork.this.network[(n + 1) % NeuralNetwork.this.netY][n6], d2, d);
                                NeuralNetwork.this.network[n][n6].addInput(NeuralNetwork.this.network[n][(n6 + NeuralNetwork.this.netX - 1) % NeuralNetwork.this.netX], d2, d);
                                NeuralNetwork.this.network[n][n6].addInput(NeuralNetwork.this.network[n][(n6 + 1) % NeuralNetwork.this.netX], d2, d);
                                ++n6;
                            }
                            ++n;
                        }
                        break;
                    }
                }
            }
            n2 = 0;
            while (n2 < NeuralNetwork.this.netY) {
                n = 0;
                while (n < NeuralNetwork.this.netX) {
                    this.neuronInterface.synchronizeSignifie((Object)NeuralNetwork.this.network[n2][n]);
                    NeuralNetwork.this.network[n2][n].setInputs(d2, d);
                    ++n;
                }
                ++n2;
            }
            if (bl) {
                if (NeuralNetwork.this.externalUI != null) {
                    NeuralNetwork.this.externalUI.netSizeChange();
                }
                if (NeuralNetwork.this.initialExternalUI != null) {
                    NeuralNetwork.this.initialExternalUI.netSizeChange();
                }
            }
            if (bl || bl3 || bl2) {
                NeuralNetwork.this.networkView.repaint();
            }
            double d3 = 0.0;
            switch (this.currentTopo) {
                case 0: {
                    d3 = NeuralNetwork.this.netX * NeuralNetwork.this.netY;
                    break;
                }
                case 1: {
                    d3 = 4.0;
                    break;
                }
                case 2: {
                    d3 = 8.0;
                    break;
                }
            }
            this.setEnabled(true);
        }

        public Icon getIcon() {
            return null;
        }

        public String getTitle() {
            return "Parametres du reseau";
        }

        public String getToolTip() {
            return "Panneau de controle du reseau de neurones.";
        }

        protected void initNeuronUIs() {
            this.neuronsChoice = new JComboBox();
            this.neuronsChoice.setBorder(new CompoundBorder(this.neuronsChoice.getBorder(), new EmptyBorder(4, 4, 4, 4)));
            this.neuronsChoice.setRenderer(new MyCellRenderer());
            this.neuronsChoice.setLightWeightPopupEnabled(true);
            this.neuronsChoice.addItemListener(this);
            this.cardsNeuron = new JPanel();
            this.cardsNeuron.setLayout(new CardLayout());
            this.ifInterface = new IntegrateAndFireGI(0.1, 0.0, 0.005, 0.0, 1000000.0, 0.02, 0.02, 0.0, 0.0);
            this.ifInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.neuronsChoice.addItem(this.ifInterface.getSymbolic());
            this.cardsNeuron.add((Component)this.ifInterface.getInterface(), Integer.toString(this.ifInterface.getSymbolic().hashCode()));
            this.srInterface = new SRMLongMemoryGI(0.1, 0.0, 0.005, 0.0, 1000000.0, 0.02, -0.07, 0.05, 0.0);
            this.srInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.neuronsChoice.addItem(this.srInterface.getSymbolic());
            this.cardsNeuron.add((Component)this.srInterface.getInterface(), Integer.toString(this.srInterface.getSymbolic().hashCode()));
            this.srShortInterface = new SRMShortMemoryGI(0.1, 0.0, 0.005, 0.0, 1000000.0, 0.02, -0.07, 0.05, 0.0);
            this.srShortInterface.setFontLabels(NeuralNetwork.this.defaultFont);
            this.neuronsChoice.addItem(this.srShortInterface.getSymbolic());
            this.cardsNeuron.add((Component)this.srShortInterface.getInterface(), Integer.toString(this.srShortInterface.getSymbolic().hashCode()));
        }

        protected void initTopologieUIs() {
            this.topologieChoice = new JComboBox();
            this.topologieChoice.setFont(NeuralNetwork.this.defaultFont);
            this.topologieChoice.setBorder(new CompoundBorder(this.topologieChoice.getBorder(), new EmptyBorder(5, 5, 5, 5)));
            this.topologieChoice.setLightWeightPopupEnabled(true);
            this.topologieChoice.addItemListener(this);
            int n = 0;
            while (n < this.topologies.length) {
                this.topologieChoice.addItem(this.topologies[n]);
                ++n;
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this.neuronsChoice) {
                ((CardLayout)this.cardsNeuron.getLayout()).show(this.cardsNeuron, Integer.toString(this.neuronsChoice.getSelectedItem().hashCode()));
                switch (this.neuronsChoice.getSelectedIndex()) {
                    case 0: {
                        this.neuronInterface = this.ifInterface;
                        break;
                    }
                    case 1: {
                        this.neuronInterface = this.srInterface;
                        break;
                    }
                    case 2: {
                        this.neuronInterface = this.srShortInterface;
                        break;
                    }
                }
            }
        }

        public void setEnabled(boolean bl) {
            this.validateBtn.setEnabled(bl);
            this.validateBtn.setBorder(bl ? NeuralNetwork.this.raisedBorder : NeuralNetwork.this.loweredBorder);
        }
    }

    private class ActivityUI
    extends JPanel {
        HoldButton holdBtn;
        ResetHoldedButton resetBtn;

        ActivityUI() {
            this.setLayout(new GridBagLayout());
            Constraints constraints = new Constraints();
            this.holdBtn = new HoldButton();
            this.resetBtn = new ResetHoldedButton();
            NeuralNetwork.this.activityCnv = new GraphCanvas(400, 200, 0.02, 0.0, NeuralNetwork.this.tMax.getValue() * 0.001, 0.05, 0.0, 1.0 / (NeuralNetwork.this.deltaT.getValue() * 0.001));
            JLabel jLabel = new JLabel("Activite de la population [kHz]");
            jLabel.setFont(NeuralNetwork.this.bigFont);
            NeuralNetwork.this.activityCurve = new LineOfPoints(Color.red);
            NeuralNetwork.this.activityCurve.setInput(NeuralNetwork.this.populationActivity);
            NeuralNetwork.this.holdedActivityCurve = new LineOfPoints(Color.red);
            NeuralNetwork.this.activityCnv.setAxesLabelFactor(1000.0, 0.001);
            NeuralNetwork.this.activityCnv.setFontLabels(NeuralNetwork.this.smallMonoFont);
            NeuralNetwork.this.activityCnv.addItem(NeuralNetwork.this.holdedActivityCurve);
            NeuralNetwork.this.activityCnv.addSynchronizedItem(NeuralNetwork.this.activityCurve);
            this.add((Component)jLabel, constraints.setAndGet(0, 0, 1, 1, 2, 0, 0, 0, 3, 0, 5, 17, 1.0, 0.0));
            this.add((Component)this.holdBtn, constraints.setAndGet(1, 0, 1, 1, 0, 0, 0, 0, 3, 5, 5, 10, 0.0, 0.0));
            this.add((Component)this.resetBtn, constraints.setAndGet(2, 0, 1, 1, 0, 0, 0, 0, 3, 5, 5, 10, 0.0, 0.0));
            this.add((Component)NeuralNetwork.this.activityCnv, constraints.setAndGet(0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0));
        }

        public void enableHolding() {
            this.holdBtn.setEnabled(true);
        }

        private class HoldButton
        extends JButton
        implements ActionListener {
            HoldButton() {
                super("Memorise");
                this.setFont(((ActivityUI)ActivityUI.this).NeuralNetwork.this.defaultFont);
                this.setBorderPainted(true);
                this.setOpaque(true);
                this.setFocusPainted(false);
                this.setRolloverEnabled(false);
                this.addActionListener(this);
                this.getAccessibleContext().setAccessibleName("Memorise");
                this.setToolTipText("Memorise la courbe.");
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.setEnabled(false);
                this.repaint();
                ((ActivityUI)ActivityUI.this).NeuralNetwork.this.holdedActivityCurve.holdCurve(((ActivityUI)ActivityUI.this).NeuralNetwork.this.activityCurve);
                ActivityUI.this.resetBtn.setEnabled(true);
            }

            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                this.setBorder(bl ? ((ActivityUI)ActivityUI.this).NeuralNetwork.this.raisedBorder : ((ActivityUI)ActivityUI.this).NeuralNetwork.this.loweredBorder);
            }
        }

        private class ResetHoldedButton
        extends JButton
        implements ActionListener {
            ResetHoldedButton() {
                super("Efface");
                this.setFont(((ActivityUI)ActivityUI.this).NeuralNetwork.this.defaultFont);
                this.setBorderPainted(true);
                this.setOpaque(true);
                this.setFocusPainted(false);
                this.setRolloverEnabled(false);
                this.addActionListener(this);
                this.getAccessibleContext().setAccessibleName("Efface");
                this.setToolTipText("Efface la courbe memorisee.");
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((ActivityUI)ActivityUI.this).NeuralNetwork.this.holdedActivityCurve.resetTime();
                ((ActivityUI)ActivityUI.this).NeuralNetwork.this.activityCnv.update();
                this.setEnabled(false);
                ActivityUI.this.holdBtn.setEnabled(true);
            }

            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                this.setBorder(bl ? ((ActivityUI)ActivityUI.this).NeuralNetwork.this.raisedBorder : ((ActivityUI)ActivityUI.this).NeuralNetwork.this.loweredBorder);
            }
        }
    }

    private class StartJButton
    extends JButton
    implements ActionListener {
        StartJButton() {
            this.setIcon(Tools.loadImageIcon(this.getClass(), "/images/computeBtn_R.gif", ""));
            this.setPressedIcon(Tools.loadImageIcon(this.getClass(), "/images/computeBtn_P.gif", ""));
            this.setDisabledIcon(Tools.loadImageIcon(this.getClass(), "/images/computeBtn_D.gif", ""));
            this.setRolloverIcon(Tools.loadImageIcon(this.getClass(), "/images/computeBtn_S.gif", ""));
            this.setBorderPainted(false);
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
            this.getAccessibleContext().setAccessibleName("Start");
            this.setToolTipText("Demarre la simulation.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            new Thread(NeuralNetwork.this.neuralNetwork).start();
            this.setEnabled(true);
            NeuralNetwork.this.activityUI.enableHolding();
        }
    }

    private class StopJButton
    extends JButton
    implements ActionListener {
        StopJButton() {
            this.setIcon(Tools.loadImageIcon(this.getClass(), "/images/stop.gif", ""));
            this.setPressedIcon(Tools.loadImageIcon(this.getClass(), "/images/stop_p.gif", ""));
            this.setDisabledIcon(Tools.loadImageIcon(this.getClass(), "/images/stop_d.gif", ""));
            this.setRolloverIcon(Tools.loadImageIcon(this.getClass(), "/images/stop_r.gif", ""));
            this.setBorderPainted(false);
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
            this.getAccessibleContext().setAccessibleName("Stop");
            this.setToolTipText("Stoppe la simulation.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            Clock.sharedInstance.setTime(Clock.sharedInstance.getMaximalTime());
            this.setEnabled(true);
            NeuralNetwork.this.activityUI.enableHolding();
        }
    }

    private class TitleCanvas
    extends JButton
    implements ActionListener {
        private final int NB_STATES = 2;
        int state = 0;
        Icon[] icons = new Icon[2];

        TitleCanvas() {
            int n = 0;
            while (n < 2) {
                this.icons[n] = Tools.loadImageIcon(this.getClass(), "/images/Title_n_" + n + ".gif", null);
                ++n;
            }
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setRolloverEnabled(false);
            this.getAccessibleContext().setAccessibleName("Title");
            this.setIcon(this.icons[this.state]);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.state = (this.state + 1) % 2;
            this.setIcon(this.icons[this.state]);
        }
    }

    private class PrimaryFrame
    extends JFrame
    implements WindowListener {
        PrimaryFrame(String string) {
            super(string);
            this.addWindowListener(this);
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            System.exit(0);
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.dispose();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    public class MyCellRenderer
    implements ListCellRenderer {
        AbstractBorder border = new EmptyBorder(4, 4, 4, 4);

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = null;
            if (bl) {
                jLabel = (JLabel)((Pair)object).second;
                jLabel.setBackground(UIManager.getColor("ComboBox.selectedBackground"));
                jLabel.setForeground(UIManager.getColor("ComboBox.selectedForeground"));
            } else {
                jLabel = (JLabel)((Pair)object).first;
                jLabel.setBackground(UIManager.getColor("ComboBox.background"));
                jLabel.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            jLabel.setBorder(this.border);
            if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                jLabel.setOpaque(n != -1);
            } else {
                jLabel.setOpaque(true);
            }
            return jLabel;
        }
    }
}

