/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron;

import com.objectspace.jgl.Pair;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import spikingneuron.drawable.HLine;
import spikingneuron.drawable.LineOfPoints;
import spikingneuron.drawable.PotentialCurve;
import spikingneuron.drawable.SpikesCurve;
import spikingneuron.generators.CircularGenerator;
import spikingneuron.generators.DiscreteNoisyGenerator;
import spikingneuron.generators.NoisyGenerator;
import spikingneuron.generators.PositiveGenerator;
import spikingneuron.generators.PulsesGenerator;
import spikingneuron.generators.RandomPulsesGenerator;
import spikingneuron.generators.SignalGenerator;
import spikingneuron.generators.SquareGenerator;
import spikingneuron.generators.StepGenerator;
import spikingneuron.math.Coordinate2D;
import spikingneuron.neurons.IntegrateAndFire;
import spikingneuron.neurons.NeuronBaseModel;
import spikingneuron.neurons.SRMLongMemory;
import spikingneuron.neurons.SRMShortMemory;
import spikingneuron.tools.Clock;
import spikingneuron.tools.Constraints;
import spikingneuron.tools.GraphCanvas;
import spikingneuron.tools.Tools;
import spikingneuron.userinterface.CircularGeneratorGI;
import spikingneuron.userinterface.DiscreteNoisyGeneratorGI;
import spikingneuron.userinterface.DoubleGI;
import spikingneuron.userinterface.IntegrateAndFireGI;
import spikingneuron.userinterface.LongGI;
import spikingneuron.userinterface.NeuronBaseModelGI;
import spikingneuron.userinterface.NoisyGeneratorGI;
import spikingneuron.userinterface.PositiveGeneratorGI;
import spikingneuron.userinterface.PulsesGeneratorGI;
import spikingneuron.userinterface.RandomPulsesGeneratorGI;
import spikingneuron.userinterface.SRMLongMemoryGI;
import spikingneuron.userinterface.SRMShortMemoryGI;
import spikingneuron.userinterface.SignalGeneratorGI;
import spikingneuron.userinterface.SquareGeneratorGI;
import spikingneuron.userinterface.StepGeneratorGI;

public class SingleNeuron
extends JApplet
implements Runnable {
    public static final double EPSILON = 1.0E-15;
    private static final int NB_DOTS = 10000;
    public Container cp;
    NeuronBaseModel neuron;
    SignalGenerator generator;
    public Font defaultFont;
    public Font boldFont;
    public Font bigFont;
    public Font bigBoldFont;
    public Font smallMonoFont;
    StartJButton computeBtn;
    StopJButton stopBtn;
    DoubleGI tMax;
    LongGI spikeCounter;
    DoubleGI spikeFrequence;
    TitleCanvas headerCnv;
    NeuronUI neuronUI;
    StimulusUI stimulusUI;
    GraphCanvas stimulusCnv;
    GraphCanvas neuronCnv;
    HLine thresholdCurve;
    LineOfPoints stimulusCurve;
    SpikesCurve spikesCurve;
    PotentialCurve neuronCurve;
    PotentialCurve holdedCurve;
    HoldButton holdBtn;
    ResetHoldedButton resetBtn;
    SingleNeuron singleNeuron;
    SignalGeneratorGI generatorInterface;
    NeuronBaseModelGI neuronInterface;

    public SingleNeuron() {
        Tools.isAnApplet = false;
    }

    public final void init() {
        Tools.isAnApplet = true;
        this.realInit();
    }

    public static void main(String[] stringArray) {
        SingleNeuron singleNeuron;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        SingleNeuron singleNeuron2 = singleNeuron = new SingleNeuron();
        singleNeuron2.getClass();
        PrimaryFrame primaryFrame = singleNeuron2.new PrimaryFrame("Spiking: neurone simple");
        singleNeuron.realInit();
        primaryFrame.getContentPane().add("Center", singleNeuron);
        primaryFrame.pack();
        ((Component)primaryFrame).setLocation(Math.abs((dimension.width - primaryFrame.getSize().width) / 2), Math.abs((dimension.height - primaryFrame.getSize().height) / 2));
        primaryFrame.show();
    }

    public final void realInit() {
        this.defaultFont = new Font("SanSerif", 0, 11);
        this.boldFont = new Font("SanSerif", 1, 11);
        this.bigFont = new Font("Dialog", 0, 10);
        this.bigBoldFont = new Font("Dialog", 1, 10);
        this.smallMonoFont = new Font("Monospaced", 0, 9);
        this.cp = this.getContentPane();
        this.cp.setLayout(new GridBagLayout());
        this.holdBtn = new HoldButton();
        this.resetBtn = new ResetHoldedButton();
        this.headerCnv = new TitleCanvas();
        this.computeBtn = new StartJButton();
        this.stopBtn = new StopJButton();
        this.tMax = new DoubleGI(200.0, 10, "Temps  [ms]", 3, 2);
        this.tMax.setValidityDomaine(1.0E-15, Double.MAX_VALUE);
        this.tMax.setToolTipText("Temps maximum pour la simulation.");
        this.tMax.setFontLabels(this.defaultFont);
        this.spikeCounter = new LongGI(0L, 10, "Nb. de Spikes", 3, 2);
        this.spikeCounter.setFontLabels(this.defaultFont);
        this.spikeCounter.field.setOpaque(true);
        this.spikeCounter.field.setEditable(false);
        this.spikeCounter.field.setHorizontalAlignment(0);
        this.spikeCounter.setToolTipText("Nombre d'implusions.");
        this.spikeFrequence = new DoubleGI(0.0, 10, "Frequence [Hz]", 3, 2);
        this.spikeFrequence.setFontLabels(this.defaultFont);
        this.spikeFrequence.setLimitedDecimales(true);
        this.spikeFrequence.field.setOpaque(true);
        this.spikeFrequence.field.setEditable(false);
        this.spikeFrequence.field.setHorizontalAlignment(0);
        this.spikeFrequence.setToolTipText("Frequence des impulsions [Hz].");
        this.neuronUI = new NeuronUI();
        this.holdedCurve = new PotentialCurve(Color.gray, Color.gray, Color.gray);
        this.neuronCurve = new PotentialCurve(new Color(50, 50, 100), new Color(190, 70, 20), new Color(160, 160, 160));
        this.neuronCurve.enableRefractoryTrace();
        this.thresholdCurve = new HLine(new Color(50, 50, 200));
        this.neuronCnv = new GraphCanvas(400, 250, 0.02, 0.0, this.tMax.getValue() * 0.001, 0.1, 0.0, 0.07);
        this.neuronCnv.setAxesLabelFactor(1000.0, 1000.0);
        this.neuronCnv.setFontLabels(this.smallMonoFont);
        this.neuronCnv.setBorder(new TitledBorder(new EmptyBorder(0, 0, 0, 0), "Potentiel membranaire du neurone [mV]", 0, 0, this.bigFont));
        this.neuronCnv.addItem(this.holdedCurve);
        this.neuronCnv.addItem(this.thresholdCurve);
        this.neuronCnv.addSynchronizedItem(this.neuronCurve);
        this.stimulusUI = new StimulusUI();
        this.spikesCurve = new SpikesCurve(Color.lightGray);
        this.spikesCurve.setHeightLineRatio(0.9);
        this.stimulusCurve = new LineOfPoints(Color.red);
        this.stimulusCnv = new GraphCanvas(400, 250, 0.02, 0.0, this.tMax.getValue() * 0.001, 0.1, 0.0, 1.0E-5);
        this.stimulusCnv.setAxesLabelFactor(1000.0, 1000000.0);
        this.stimulusCnv.setFontLabels(this.smallMonoFont);
        this.stimulusCnv.setBorder(new TitledBorder(new EmptyBorder(0, 0, 0, 0), "Signal externe d'entree [uA]", 0, 0, this.bigFont));
        this.stimulusCnv.addSynchronizedItem(this.spikesCurve);
        this.stimulusCnv.addSynchronizedItem(this.stimulusCurve);
        Constraints constraints = new Constraints();
        this.cp.add((Component)this.headerCnv, constraints.setAndGet(0, 0, 1, 3, 1, 0, 0, 0, 0, 0, 0, 17, 0.8, 0.0));
        this.cp.add((Component)this.tMax.label, constraints.setAndGet(1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 0.05, 0.0));
        this.cp.add((Component)this.tMax.signifiant, constraints.setAndGet(2, 0, 1, 1, 1, 0, 0, 0, 0, 2, 2, 10, 0.1, 0.0));
        this.cp.add((Component)this.spikeCounter.label, constraints.setAndGet(1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 0.05, 0.0));
        this.cp.add((Component)this.spikeCounter.signifiant, constraints.setAndGet(2, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 10, 0.1, 0.0));
        this.cp.add((Component)this.spikeFrequence.label, constraints.setAndGet(1, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 10, 0.05, 0.0));
        this.cp.add((Component)this.spikeFrequence.signifiant, constraints.setAndGet(2, 2, 1, 1, 1, 0, 0, 0, 0, 2, 2, 10, 0.1, 0.0));
        this.cp.add((Component)this.computeBtn, constraints.setAndGet(3, 0, -1, 3, 1, 0, 0, 0, 0, 1, 0, 10, 0.05, 0.0));
        this.cp.add((Component)this.stopBtn, constraints.setAndGet(4, 0, 0, 3, 1, 0, 0, 0, 0, 1, 0, 10, 0.05, 0.0));
        this.cp.add((Component)this.stimulusCnv, constraints.setAndGet(0, 4, 2, 1, 1, 0, 0, 10, 5, 0, 0, 10, 0.85, 0.5));
        this.cp.add((Component)this.stimulusUI, constraints.setAndGet(2, 4, 0, 1, 1, 0, 0, 10, 5, 0, 0, 10, 0.15, 0.5));
        this.cp.add((Component)this.neuronCnv, constraints.setAndGet(0, 5, 2, 0, 1, 0, 0, 5, 0, 0, 0, 10, 0.85, 0.5));
        this.cp.add((Component)this.neuronUI, constraints.setAndGet(2, 5, 0, 0, 1, 0, 0, 5, 0, 0, 0, 10, 0.15, 0.5));
        ToolTipManager.sharedInstance().setEnabled(true);
        ToolTipManager.sharedInstance().setInitialDelay(1000);
        ToolTipManager.sharedInstance().setDismissDelay(8000);
        ToolTipManager.sharedInstance().setReshowDelay(2000);
        this.singleNeuron = this;
    }

    public void run() {
        long l = 0L;
        double d = this.tMax.getValue() * 0.001;
        double d2 = d / 10000.0;
        this.spikeCounter.setValue(0L);
        this.spikeFrequence.setValue(0.0);
        this.repaint();
        Clock.sharedInstance.setDeltaT(d2);
        Clock.sharedInstance.setMaximalTime(d);
        this.generatorInterface.synchronizeSignifie(this.generator);
        this.neuronInterface.synchronizeSignifie((Object)this.neuron);
        Clock.sharedInstance.resetTime();
        this.neuron.resetTime();
        this.generator.resetTime();
        this.spikesCurve.resetTime();
        this.neuronCurve.resetTime();
        this.stimulusCurve.resetTime();
        NeuronBaseModel.resetFireCounter();
        Coordinate2D coordinate2D = this.generator.getRange();
        Coordinate2D coordinate2D2 = this.neuron.getRange();
        double d3 = coordinate2D.getC1();
        double d4 = coordinate2D.getC0();
        double d5 = coordinate2D2.getC1();
        double d6 = coordinate2D2.getC0();
        if (d3 - d4 < 1.0E-15 && Math.abs(d3) < 1.0E-15) {
            d3 = 1.0E-6;
            d4 = -1.0E-6;
        } else {
            d3 = Math.max(0.0, d3);
            d4 = Math.min(0.0, d4);
        }
        d5 = Math.max(0.0, d5);
        d6 = Math.min(0.0, d6);
        coordinate2D2 = this.holdedCurve.getVerticalBounds();
        d5 = Math.max(d5, coordinate2D2.getC1());
        d6 = Math.min(d6, coordinate2D2.getC0());
        this.neuronCnv.changeVirtualBounds(0.02, 0.0, d, 0.1, d6, d5);
        this.stimulusCnv.changeVirtualBounds(0.02, 0.0, d, 0.1, d4, d3);
        this.thresholdCurve.setOrdonnee(this.neuron.getMeanThreshold());
        this.neuronCurve.setLimits(this.neuron.getMeanThreshold(), 0.0, 10);
        this.stimulusCurve.ensureCapacity(10000);
        this.neuronCurve.ensureCapacity(10000);
        this.neuronCnv.update();
        this.stimulusCnv.update();
        this.spikesCurve.setInput(this.neuron);
        this.neuronCurve.setInput(this.neuron);
        this.stimulusCurve.setInput(this.generator);
        this.neuron.removeExternalInputs();
        this.neuron.addExternalInput(this.generator);
        long l2 = 0L;
        while (Clock.sharedInstance.tic()) {
            ++l2;
            this.generator.computeNextTic();
            this.neuron.computeNextTic();
            this.spikesCurve.computeNextTic();
            this.neuronCurve.computeNextTic();
            this.stimulusCurve.computeNextTic();
            if (l2 % 50L == 0L) {
                this.spikeCounter.setValue(NeuronBaseModel.getFireCounter());
                this.spikeFrequence.setValue((double)NeuronBaseModel.getFireCounter() / Clock.sharedInstance.getTime());
                this.spikeCounter.signifiant.repaint();
                this.spikeFrequence.signifiant.repaint();
            }
            Clock.sharedInstance.updateOutput();
            this.generator.updateOutput();
            this.neuron.updateOutput();
        }
        this.spikeCounter.setValue(NeuronBaseModel.getFireCounter());
        this.spikeFrequence.setValue((double)NeuronBaseModel.getFireCounter() / d);
        coordinate2D2 = this.neuronCurve.getVerticalBounds();
        coordinate2D = this.stimulusCurve.getVerticalBounds();
        if (coordinate2D.getC1() - coordinate2D.getC0() < 1.0E-15 && Math.abs(coordinate2D.getC0()) < 1.0E-15) {
            coordinate2D.setC0(-1.0E-6);
            coordinate2D.setC1(1.0E-6);
        } else {
            coordinate2D.setC0(Math.min(0.0, coordinate2D.getC0()));
            coordinate2D.setC1(Math.max(0.0, coordinate2D.getC1()));
        }
        d6 = Math.min(0.0, coordinate2D2.getC0());
        d5 = Math.max(0.0, coordinate2D2.getC1());
        coordinate2D2 = this.holdedCurve.getVerticalBounds();
        d5 = Math.max(d5, coordinate2D2.getC1());
        d6 = Math.min(d6, coordinate2D2.getC0());
        this.neuronCnv.changeVirtualBounds(0.02, 0.0, d, 0.1, d6, d5);
        this.stimulusCnv.changeVirtualBounds(0.02, 0.0, d, 0.1, coordinate2D.getC0(), coordinate2D.getC1());
        this.repaint();
    }

    public final void start() {
    }

    private class StimulusUI
    extends JPanel
    implements ItemListener {
        JComboBox generatorsChoice;
        JPanel cards;
        CircularGenerator circularGenerator;
        CircularGeneratorGI circularGenInterface;
        PositiveGenerator positiveGenerator;
        PositiveGeneratorGI positiveGenInterface;
        SquareGenerator squareGenerator;
        SquareGeneratorGI squareGenInterface;
        PulsesGenerator pulsesGenerator;
        PulsesGeneratorGI pulsesGenInterface;
        RandomPulsesGenerator randomPulsesGenerator;
        RandomPulsesGeneratorGI randomPulsesGenInterface;
        NoisyGenerator noisyGenerator;
        NoisyGeneratorGI noisyGenInterface;
        DiscreteNoisyGenerator discreteNoisyGenerator;
        DiscreteNoisyGeneratorGI discreteNoisyGenInterface;
        StepGenerator stepGenerator;
        StepGeneratorGI stepGenInterface;

        StimulusUI() {
            this.setLayout(new GridBagLayout());
            Constraints constraints = new Constraints();
            TitledBorder titledBorder = new TitledBorder(new EmptyBorder(0, 0, 0, 0), "Courbe courante", 2, 0, SingleNeuron.this.bigFont);
            this.setBorder(titledBorder);
            this.generatorsChoice = new JComboBox();
            this.generatorsChoice.setBorder(new CompoundBorder(this.generatorsChoice.getBorder(), new EmptyBorder(2, 2, 2, 2)));
            this.generatorsChoice.setRenderer(new MyCellRenderer());
            this.generatorsChoice.setMaximumRowCount(4);
            this.generatorsChoice.setLightWeightPopupEnabled(true);
            this.generatorsChoice.addItemListener(this);
            this.cards = new JPanel();
            this.cards.setLayout(new CardLayout());
            this.circularGenerator = new CircularGenerator();
            this.circularGenerator.init(1.1E-7, 1.0E-8, 100.0, 0.0);
            this.circularGenInterface = new CircularGeneratorGI(this.circularGenerator);
            this.circularGenInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.cards.add((Component)this.circularGenInterface.getInterface(), Integer.toString(this.circularGenInterface.getSymbolic().hashCode()));
            this.stepGenerator = new StepGenerator();
            this.stepGenerator.init(1.1E-7, 1.0E-7, 0.5);
            this.stepGenInterface = new StepGeneratorGI(this.stepGenerator);
            this.stepGenInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.cards.add((Component)this.stepGenInterface.getInterface(), Integer.toString(this.stepGenInterface.getSymbolic().hashCode()));
            this.pulsesGenerator = new PulsesGenerator(1.1E-7, 3, 1.0E-8, 1);
            this.pulsesGenInterface = new PulsesGeneratorGI(this.pulsesGenerator);
            this.pulsesGenInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.cards.add((Component)this.pulsesGenInterface.getInterface(), Integer.toString(this.pulsesGenInterface.getSymbolic().hashCode()));
            this.randomPulsesGenerator = new RandomPulsesGenerator(1.1E-7, 75.0, 1.0E-8, 1, System.currentTimeMillis());
            this.randomPulsesGenInterface = new RandomPulsesGeneratorGI(this.randomPulsesGenerator);
            this.randomPulsesGenInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.cards.add((Component)this.randomPulsesGenInterface.getInterface(), Integer.toString(this.randomPulsesGenInterface.getSymbolic().hashCode()));
            this.noisyGenerator = new NoisyGenerator(1.1E-7, 5.0E-7, 10, System.currentTimeMillis());
            this.noisyGenInterface = new NoisyGeneratorGI(this.noisyGenerator);
            this.noisyGenInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.cards.add((Component)this.noisyGenInterface.getInterface(), Integer.toString(this.noisyGenInterface.getSymbolic().hashCode()));
            this.discreteNoisyGenerator = new DiscreteNoisyGenerator();
            this.discreteNoisyGenerator.setOffset(1.1E-7);
            this.discreteNoisyGenerator.setAmplitude(5.0E-7);
            this.discreteNoisyGenInterface = new DiscreteNoisyGeneratorGI(this.discreteNoisyGenerator);
            this.discreteNoisyGenInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.cards.add((Component)this.discreteNoisyGenInterface.getInterface(), Integer.toString(this.discreteNoisyGenInterface.getSymbolic().hashCode()));
            this.positiveGenerator = new PositiveGenerator();
            this.positiveGenerator.init(1.1E-7, 3.0E-7, 100.0, 0.0);
            this.positiveGenInterface = new PositiveGeneratorGI(this.positiveGenerator);
            this.positiveGenInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.cards.add((Component)this.positiveGenInterface.getInterface(), Integer.toString(this.positiveGenInterface.getSymbolic().hashCode()));
            this.squareGenerator = new SquareGenerator();
            this.squareGenerator.init(1.1E-7, 5.0E-6, 0.0, new double[]{0.03, 0.01, 0.02, 0.01, 0.03, 0.01, 0.02, 0.01});
            this.squareGenInterface = new SquareGeneratorGI(this.squareGenerator);
            this.squareGenInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.cards.add((Component)this.squareGenInterface.getInterface(), Integer.toString(this.squareGenInterface.getSymbolic().hashCode()));
            this.generatorsChoice.addItem(this.circularGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.stepGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.pulsesGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.randomPulsesGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.noisyGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.positiveGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.squareGenInterface.getSymbolic());
            this.generatorsChoice.addItem(this.discreteNoisyGenInterface.getSymbolic());
            this.add((Component)this.generatorsChoice, constraints.setAndGet(0, 0, 0, 1, 0, 0, 0, 0, 5, 0, 0, 11, 1.0, 0.0));
            this.add((Component)this.cards, constraints.setAndGet(0, 1, 0, 1, 1, 0, 0, 5, 0, 0, 0, 10, 1.0, 1.0));
            SingleNeuron.this.generator = this.circularGenerator;
            SingleNeuron.this.generatorInterface = this.circularGenInterface;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ((CardLayout)this.cards.getLayout()).show(this.cards, Integer.toString(this.generatorsChoice.getSelectedItem().hashCode()));
            switch (this.generatorsChoice.getSelectedIndex()) {
                case 0: {
                    SingleNeuron.this.generator = this.circularGenerator;
                    SingleNeuron.this.generatorInterface = this.circularGenInterface;
                    break;
                }
                case 1: {
                    SingleNeuron.this.generator = this.stepGenerator;
                    SingleNeuron.this.generatorInterface = this.stepGenInterface;
                    break;
                }
                case 2: {
                    SingleNeuron.this.generator = this.pulsesGenerator;
                    SingleNeuron.this.generatorInterface = this.pulsesGenInterface;
                    break;
                }
                case 3: {
                    SingleNeuron.this.generator = this.randomPulsesGenerator;
                    SingleNeuron.this.generatorInterface = this.randomPulsesGenInterface;
                    break;
                }
                case 4: {
                    SingleNeuron.this.generator = this.noisyGenerator;
                    SingleNeuron.this.generatorInterface = this.noisyGenInterface;
                    break;
                }
                case 5: {
                    SingleNeuron.this.generator = this.positiveGenerator;
                    SingleNeuron.this.generatorInterface = this.positiveGenInterface;
                    break;
                }
                case 6: {
                    SingleNeuron.this.generator = this.squareGenerator;
                    SingleNeuron.this.generatorInterface = this.squareGenInterface;
                    break;
                }
                case 7: {
                    SingleNeuron.this.generator = this.discreteNoisyGenerator;
                    SingleNeuron.this.generatorInterface = this.discreteNoisyGenInterface;
                    break;
                }
            }
        }
    }

    private class NeuronUI
    extends JPanel
    implements ItemListener {
        JComboBox neuronsChoice;
        JPanel cards;
        IntegrateAndFire ifNeuron;
        IntegrateAndFireGI ifInterface;
        SRMLongMemory srNeuron;
        SRMLongMemoryGI srInterface;
        SRMShortMemory srShortNeuron;
        SRMShortMemoryGI srShortInterface;

        NeuronUI() {
            this.setLayout(new GridBagLayout());
            Constraints constraints = new Constraints();
            TitledBorder titledBorder = new TitledBorder(new EmptyBorder(0, 0, 0, 0), "Modele neuronal", 2, 0, SingleNeuron.this.bigFont);
            this.setBorder(titledBorder);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)SingleNeuron.this.holdBtn, constraints.setAndGet(0, 0, 0, 1, 2, 0, 0, 0, 1, 0, 0, 10, 1.0, 0.5));
            jPanel.add((Component)SingleNeuron.this.resetBtn, constraints.setAndGet(0, 1, 0, 1, 2, 0, 0, 1, 0, 0, 0, 10, 1.0, 0.5));
            this.neuronsChoice = new JComboBox();
            this.neuronsChoice.setBorder(new CompoundBorder(this.neuronsChoice.getBorder(), new EmptyBorder(5, 5, 5, 5)));
            this.neuronsChoice.setRenderer(new MyCellRenderer());
            this.neuronsChoice.setLightWeightPopupEnabled(true);
            this.neuronsChoice.addItemListener(this);
            this.cards = new JPanel();
            this.cards.setLayout(new CardLayout());
            this.ifNeuron = new IntegrateAndFire(0);
            this.ifNeuron.nbmInit(0.1, 0.0, 0.005, 0.0, 1000000.0, 0.02, 0.0);
            this.ifNeuron.ifInit(0.02, 0.0);
            this.ifInterface = new IntegrateAndFireGI(this.ifNeuron);
            this.ifInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.neuronsChoice.addItem(this.ifInterface.getSymbolic());
            this.cards.add((Component)this.ifInterface.getInterface(), Integer.toString(this.ifInterface.getSymbolic().hashCode()));
            this.srNeuron = new SRMLongMemory(0);
            this.srNeuron.nbmInit(0.1, 0.0, 0.005, 0.0, 1000000.0, 0.02, 0.0);
            this.srNeuron.srInit(-0.07, 0.05);
            this.srInterface = new SRMLongMemoryGI(this.srNeuron);
            this.srInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.neuronsChoice.addItem(this.srInterface.getSymbolic());
            this.cards.add((Component)this.srInterface.getInterface(), Integer.toString(this.srInterface.getSymbolic().hashCode()));
            this.srShortNeuron = new SRMShortMemory(0);
            this.srShortNeuron.nbmInit(0.1, 0.0, 0.005, 0.0, 1000000.0, 0.02, 0.0);
            this.srShortNeuron.srInit(-0.07, 0.05);
            this.srShortInterface = new SRMShortMemoryGI(this.srShortNeuron);
            this.srShortInterface.setFontLabels(SingleNeuron.this.defaultFont);
            this.neuronsChoice.addItem(this.srShortInterface.getSymbolic());
            this.cards.add((Component)this.srShortInterface.getInterface(), Integer.toString(this.srShortInterface.getSymbolic().hashCode()));
            this.add((Component)this.neuronsChoice, constraints.setAndGet(1, 0, 0, 1, 2, 0, 0, 0, 5, 5, 5, 10, 0.95, 0.0));
            this.add((Component)this.cards, constraints.setAndGet(0, 1, 0, 0, 1, 0, 0, 5, 0, 0, 0, 10, 1.0, 1.0));
            this.add((Component)jPanel, constraints.setAndGet(0, 0, 1, 1, 2, 4, 0, 0, 0, 0, 5, 17, 0.05, 0.0));
            SingleNeuron.this.neuron = this.ifNeuron;
            SingleNeuron.this.neuronInterface = this.ifInterface;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ((CardLayout)this.cards.getLayout()).show(this.cards, Integer.toString(this.neuronsChoice.getSelectedItem().hashCode()));
            switch (this.neuronsChoice.getSelectedIndex()) {
                case 0: {
                    SingleNeuron.this.neuron = this.ifNeuron;
                    SingleNeuron.this.neuronInterface = this.ifInterface;
                    break;
                }
                case 1: {
                    SingleNeuron.this.neuron = this.srNeuron;
                    SingleNeuron.this.neuronInterface = this.srInterface;
                    break;
                }
                case 2: {
                    SingleNeuron.this.neuron = this.srShortNeuron;
                    SingleNeuron.this.neuronInterface = this.srShortInterface;
                    break;
                }
            }
        }
    }

    private class StartJButton
    extends JButton
    implements ActionListener {
        Border loweredBorder = BorderFactory.createLoweredBevelBorder();
        Border raisedBorder = BorderFactory.createRaisedBevelBorder();

        StartJButton() {
            this.setIcon(Tools.loadImageIcon(this.getClass(), "/images/computeBtn_R.gif", null));
            this.setPressedIcon(Tools.loadImageIcon(this.getClass(), "/images/computeBtn_P.gif", null));
            this.setDisabledIcon(Tools.loadImageIcon(this.getClass(), "/images/computeBtn_D.gif", null));
            this.setRolloverIcon(Tools.loadImageIcon(this.getClass(), "/images/computeBtn_S.gif", null));
            this.setBorderPainted(false);
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
            this.getAccessibleContext().setAccessibleName("Start");
            this.setToolTipText("Demarre la simulation.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            new Thread(SingleNeuron.this.singleNeuron).start();
            this.setEnabled(true);
            SingleNeuron.this.holdBtn.setEnabled(true);
        }
    }

    private class StopJButton
    extends JButton
    implements ActionListener {
        Border loweredBorder = BorderFactory.createLoweredBevelBorder();
        Border raisedBorder = BorderFactory.createRaisedBevelBorder();

        StopJButton() {
            this.setIcon(Tools.loadImageIcon(this.getClass(), "/images/stop.gif", null));
            this.setPressedIcon(Tools.loadImageIcon(this.getClass(), "/images/stop_p.gif", null));
            this.setDisabledIcon(Tools.loadImageIcon(this.getClass(), "/images/stop_d.gif", null));
            this.setRolloverIcon(Tools.loadImageIcon(this.getClass(), "/images/stop_r.gif", null));
            this.setBorderPainted(false);
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
            this.getAccessibleContext().setAccessibleName("Stop");
            this.setToolTipText("Stoppe la simulation.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            Clock.sharedInstance.setTime(Clock.sharedInstance.getMaximalTime());
            this.setEnabled(true);
            SingleNeuron.this.holdBtn.setEnabled(true);
        }
    }

    private class HoldButton
    extends JButton
    implements ActionListener {
        Border loweredBorder;
        Border raisedBorder;

        HoldButton() {
            super("Memorise");
            this.setFont(SingleNeuron.this.defaultFont);
            this.loweredBorder = BorderFactory.createLoweredBevelBorder();
            this.raisedBorder = BorderFactory.createRaisedBevelBorder();
            this.setBorderPainted(true);
            this.setOpaque(true);
            this.setFocusPainted(false);
            this.setRolloverEnabled(false);
            this.addActionListener(this);
            this.getAccessibleContext().setAccessibleName("Memorise");
            this.setToolTipText("Memorise la courbe courante.");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            this.repaint();
            SingleNeuron.this.holdedCurve.holdCurve(SingleNeuron.this.neuronCurve);
            SingleNeuron.this.resetBtn.setEnabled(true);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.setBorder(bl ? this.raisedBorder : this.loweredBorder);
        }
    }

    private class ResetHoldedButton
    extends JButton
    implements ActionListener {
        Border loweredBorder;
        Border raisedBorder;

        ResetHoldedButton() {
            super("Efface");
            this.setFont(SingleNeuron.this.defaultFont);
            this.loweredBorder = BorderFactory.createLoweredBevelBorder();
            this.raisedBorder = BorderFactory.createRaisedBevelBorder();
            this.setBorderPainted(true);
            this.setOpaque(true);
            this.setFocusPainted(false);
            this.setRolloverEnabled(false);
            this.addActionListener(this);
            this.getAccessibleContext().setAccessibleName("Efface");
            this.setToolTipText("Efface la courbe memorisee.");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SingleNeuron.this.holdedCurve.resetTime();
            SingleNeuron.this.neuronCnv.update();
            this.setEnabled(false);
            SingleNeuron.this.holdBtn.setEnabled(true);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.setBorder(bl ? this.raisedBorder : this.loweredBorder);
        }
    }

    private class TitleCanvas
    extends JButton
    implements ActionListener {
        private final int NB_STATES = 2;
        int state = 0;
        Icon[] icons = new Icon[2];
        Border[] borders = new Border[2];

        TitleCanvas() {
            int n = 0;
            while (n < 2) {
                this.icons[n] = Tools.loadImageIcon(this.getClass(), "/images/Title_s_" + n + ".gif", null);
                ++n;
            }
            this.borders[0] = BorderFactory.createLoweredBevelBorder();
            this.borders[1] = BorderFactory.createRaisedBevelBorder();
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setRolloverEnabled(false);
            this.addActionListener(this);
            this.getAccessibleContext().setAccessibleName("Title");
            this.setIcon(this.icons[this.state]);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.state = (this.state + 1) % 2;
            this.setIcon(this.icons[this.state]);
        }
    }

    private class PrimaryFrame
    extends JFrame
    implements WindowListener {
        PrimaryFrame(String string) {
            super(string);
            this.addWindowListener(this);
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            System.exit(0);
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.dispose();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    public class MyCellRenderer
    implements ListCellRenderer {
        AbstractBorder border = new EmptyBorder(4, 4, 4, 4);

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = null;
            if (bl) {
                jLabel = (JLabel)((Pair)object).second;
                jLabel.setBackground(UIManager.getColor("ComboBox.selectedBackground"));
                jLabel.setForeground(UIManager.getColor("ComboBox.selectedForeground"));
            } else {
                jLabel = (JLabel)((Pair)object).first;
                jLabel.setBackground(UIManager.getColor("ComboBox.background"));
                jLabel.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            jLabel.setBorder(this.border);
            if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                jLabel.setOpaque(n != -1);
            } else {
                jLabel.setOpaque(true);
            }
            return jLabel;
        }
    }
}

