/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.drawable;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import spikingneuron.drawable.DisplayContext;
import spikingneuron.drawable.Drawable;
import spikingneuron.math.Coordinate2D;
import spikingneuron.math.Screen2D;
import spikingneuron.tools.Clock;
import spikingneuron.tools.DataFlowAgent;
import spikingneuron.tools.RealFlowProducer;
import spikingneuron.tools.Tools;

public class LineOfPoints
extends Drawable
implements DataFlowAgent {
    public static final int GROWING_INCREMENT = 1000;
    public static final int INITIAL_CAPACITY = 5000;
    public Color lineColor;
    protected Vector pointsStock;
    protected Coordinate2D lastPoint;
    protected RealFlowProducer input = null;
    protected Coordinate2D verticalBounds;

    public LineOfPoints(Color color) {
        this.lineColor = color;
        this.verticalBounds = new Coordinate2D(0.0, 0.0);
        this.pointsStock = new Vector(5000, 1000);
    }

    public LineOfPoints(Color color, int n) {
        this.lineColor = color;
        this.verticalBounds = new Coordinate2D(0.0, 0.0);
        this.pointsStock = new Vector(n, n);
    }

    public void computeNextTic() {
        double d = this.input.getRealOutput();
        Coordinate2D coordinate2D = new Coordinate2D(Clock.sharedInstance.getTime(), d);
        if (!this.pointsStock.isEmpty() && this.synchronizedDisplay) {
            Enumeration enumeration = this.contexts.elements();
            while (enumeration.hasMoreElements()) {
                Graphics graphics;
                DisplayContext displayContext = (DisplayContext)enumeration.nextElement();
                Screen2D screen2D = displayContext.getView();
                Point point = screen2D.scrPoint(this.lastPoint);
                Point point2 = screen2D.scrPoint(coordinate2D);
                if (point2.equals(point) || (graphics = displayContext.getGraphics()) == null) continue;
                graphics.setColor(this.lineColor);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
        }
        if (d < this.verticalBounds.getC0()) {
            this.verticalBounds.setC0(d);
        } else if (d > this.verticalBounds.getC1()) {
            this.verticalBounds.setC1(d);
        }
        this.pointsStock.addElement(coordinate2D);
        this.lastPoint = coordinate2D;
    }

    public void ensureCapacity(int n) {
        this.pointsStock.ensureCapacity(n);
    }

    public Coordinate2D getHorizontalBounds() {
        if (this.pointsStock.size() > 0) {
            return new Coordinate2D(0.0, ((Coordinate2D)this.pointsStock.lastElement()).getC0());
        }
        return new Coordinate2D(0.0, 0.0);
    }

    public Coordinate2D getVerticalBounds() {
        return this.verticalBounds;
    }

    public void holdCurve(LineOfPoints lineOfPoints) {
        this.pointsStock.removeAllElements();
        this.lastPoint = lineOfPoints.lastPoint != null ? (Coordinate2D)lineOfPoints.lastPoint.clone() : null;
        this.verticalBounds = lineOfPoints.verticalBounds != null ? (Coordinate2D)lineOfPoints.verticalBounds.clone() : null;
        if (this.pointsStock != null) {
            Enumeration enumeration = lineOfPoints.pointsStock.elements();
            while (enumeration.hasMoreElements()) {
                this.pointsStock.addElement(enumeration.nextElement());
            }
        }
        this.lineColor = Tools.brightness(Tools.brightness(lineOfPoints.lineColor, 80), 1.5);
    }

    public void redrawAt(Graphics graphics, Screen2D screen2D) {
        if (graphics != null && this.pointsStock.size() >= 2) {
            graphics.setColor(this.lineColor);
            Point point = screen2D.scrPoint((Coordinate2D)this.pointsStock.elementAt(0));
            int n = 1;
            while (n < this.pointsStock.size()) {
                Point point2 = screen2D.scrPoint((Coordinate2D)this.pointsStock.elementAt(n));
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                point = point2;
                ++n;
            }
        }
    }

    public void resetTime() {
        this.verticalBounds.set(0.0, 0.0);
        this.pointsStock.removeAllElements();
        this.notifyChanges();
    }

    public void setInput(RealFlowProducer realFlowProducer) {
        this.input = realFlowProducer;
    }
}

