/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.drawable;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import spikingneuron.drawable.DisplayContext;
import spikingneuron.drawable.Drawable;
import spikingneuron.math.Coordinate2D;
import spikingneuron.math.Screen2D;
import spikingneuron.tools.Clock;
import spikingneuron.tools.DataFlowAgent;
import spikingneuron.tools.RealFlowProducer;
import spikingneuron.tools.Tools;

public class PotentialCurve
extends Drawable
implements DataFlowAgent,
Cloneable {
    public static final int GROWING_INCREMENT = 1000;
    public static final int INITIAL_CAPACITY = 5000;
    public Color curveColor;
    public Color spikeColor;
    public Color refractColor;
    public boolean valuedRefractPeriode;
    protected int spikeUpLimits;
    protected double spikeVoltage;
    protected double thresholdVoltage;
    protected double refractoryVoltage;
    protected boolean absoluteLimits;
    protected Vector pointsStock;
    protected Coordinate2D lastPoint;
    protected RealFlowProducer input;
    protected Coordinate2D verticalBounds;
    protected static final int START_POINT_TAG = 1;
    protected static final int CURVE_POINT_TAG = 2;
    protected static final int SPIKE_POINT_TAG = 3;

    protected PotentialCurve() {
    }

    public PotentialCurve(Color color, Color color2, Color color3) {
        this.lastPoint = null;
        this.input = null;
        this.curveColor = color;
        this.spikeColor = color2;
        this.refractColor = color3;
        this.spikeVoltage = 0.0;
        this.spikeUpLimits = 0;
        this.thresholdVoltage = 0.0;
        this.refractoryVoltage = 0.0;
        this.absoluteLimits = false;
        this.valuedRefractPeriode = false;
        this.verticalBounds = new Coordinate2D(0.0, 0.0);
        this.pointsStock = new Vector(5000, 1000);
    }

    public PotentialCurve(Color color, Color color2, Color color3, int n) {
        this.lastPoint = null;
        this.input = null;
        this.curveColor = color;
        this.spikeColor = color2;
        this.refractColor = color3;
        this.spikeVoltage = 0.0;
        this.spikeUpLimits = 0;
        this.thresholdVoltage = 0.0;
        this.refractoryVoltage = 0.0;
        this.absoluteLimits = false;
        this.valuedRefractPeriode = false;
        this.verticalBounds = new Coordinate2D();
        this.pointsStock = new Vector(n, n / 2);
    }

    public Object clone() {
        PotentialCurve potentialCurve = new PotentialCurve();
        potentialCurve.input = this.input;
        potentialCurve.curveColor = this.curveColor;
        potentialCurve.spikeColor = this.spikeColor;
        potentialCurve.refractColor = this.refractColor;
        potentialCurve.spikeVoltage = this.spikeVoltage;
        potentialCurve.spikeUpLimits = this.spikeUpLimits;
        potentialCurve.thresholdVoltage = this.thresholdVoltage;
        potentialCurve.refractoryVoltage = this.refractoryVoltage;
        potentialCurve.valuedRefractPeriode = this.valuedRefractPeriode;
        potentialCurve.lastPoint = this.lastPoint != null ? (Coordinate2D)this.lastPoint.clone() : null;
        potentialCurve.verticalBounds = this.verticalBounds != null ? (Coordinate2D)this.verticalBounds.clone() : null;
        potentialCurve.pointsStock = this.pointsStock != null ? (Vector)this.pointsStock.clone() : null;
        return potentialCurve;
    }

    public void computeNextTic() {
        double d = Clock.sharedInstance.getTime();
        double d2 = this.input.getRealOutput();
        Coordinate2D coordinate2D = new Coordinate2D(d, d2);
        if (d2 == Double.POSITIVE_INFINITY) {
            if (this.synchronizedDisplay) {
                Enumeration enumeration = this.contexts.elements();
                while (enumeration.hasMoreElements()) {
                    DisplayContext displayContext = (DisplayContext)enumeration.nextElement();
                    Graphics graphics = displayContext.getGraphics();
                    Screen2D screen2D = displayContext.getView();
                    if (graphics == null) continue;
                    int n = screen2D.scrY(this.thresholdVoltage);
                    int n2 = this.absoluteLimits ? screen2D.getScrMinY() + this.spikeUpLimits : screen2D.scrY(this.spikeVoltage);
                    int n3 = screen2D.scrX(d);
                    if (this.lastPoint != null) {
                        graphics.setColor(this.curveColor);
                        graphics.drawLine(screen2D.scrX(this.lastPoint.getX()), screen2D.scrY(this.lastPoint.getY()), n3, n);
                    }
                    if (this.valuedRefractPeriode) {
                        graphics.setColor(this.refractColor);
                        graphics.drawLine(n3, n, n3, screen2D.scrY(this.refractoryVoltage));
                    }
                    graphics.setColor(this.spikeColor);
                    graphics.drawLine(n3, n, n3, n2);
                }
            }
            if (this.lastPoint == null) {
                this.pointsStock.addElement(new CurveItem(1, new Coordinate2D(d, this.thresholdVoltage)));
            } else {
                this.pointsStock.addElement(new CurveItem(2, new Coordinate2D(d, this.thresholdVoltage)));
            }
            this.pointsStock.addElement(new CurveItem(3, coordinate2D));
            this.lastPoint = null;
        } else if (d2 != Double.NEGATIVE_INFINITY) {
            if (d2 < this.verticalBounds.getC0()) {
                this.verticalBounds.setC0(d2);
            } else if (d2 > this.verticalBounds.getC1()) {
                this.verticalBounds.setC1(d2);
            }
            if (this.lastPoint == null) {
                if (this.valuedRefractPeriode) {
                    Coordinate2D coordinate2D2 = new Coordinate2D(d, this.refractoryVoltage);
                    this.pointsStock.addElement(new CurveItem(1, coordinate2D2));
                    this.pointsStock.addElement(new CurveItem(2, coordinate2D));
                    Enumeration enumeration = this.contexts.elements();
                    while (enumeration.hasMoreElements()) {
                        DisplayContext displayContext = (DisplayContext)enumeration.nextElement();
                        Graphics graphics = displayContext.getGraphics();
                        Screen2D screen2D = displayContext.getView();
                        if (graphics == null) continue;
                        graphics.setColor(this.curveColor);
                        graphics.drawLine(screen2D.scrX(coordinate2D2.getX()), screen2D.scrY(coordinate2D2.getY()), screen2D.scrX(coordinate2D.getX()), screen2D.scrY(coordinate2D.getY()));
                    }
                } else {
                    this.pointsStock.addElement(new CurveItem(1, coordinate2D));
                }
            } else {
                if (this.synchronizedDisplay) {
                    Enumeration enumeration = this.contexts.elements();
                    while (enumeration.hasMoreElements()) {
                        Graphics graphics;
                        DisplayContext displayContext = (DisplayContext)enumeration.nextElement();
                        Screen2D screen2D = displayContext.getView();
                        Point point = screen2D.scrPoint(this.lastPoint);
                        Point point2 = screen2D.scrPoint(coordinate2D);
                        if (point2.equals(point) || (graphics = displayContext.getGraphics()) == null) continue;
                        graphics.setColor(this.curveColor);
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                    }
                }
                this.pointsStock.addElement(new CurveItem(2, coordinate2D));
            }
            this.lastPoint = coordinate2D;
        }
    }

    public void disableRefractoryTrace() {
        this.valuedRefractPeriode = false;
    }

    public void enableRefractoryTrace() {
        this.valuedRefractPeriode = true;
    }

    public void ensureCapacity(int n) {
        this.pointsStock.ensureCapacity(n);
    }

    public Coordinate2D getHorizontalBounds() {
        if (this.pointsStock.size() > 0) {
            return new Coordinate2D(0.0, ((CurveItem)this.pointsStock.lastElement()).point.getC0());
        }
        return new Coordinate2D(0.0, 0.0);
    }

    public Coordinate2D getVerticalBounds() {
        return this.verticalBounds;
    }

    public void holdCurve(PotentialCurve potentialCurve) {
        this.pointsStock.removeAllElements();
        this.spikeVoltage = potentialCurve.spikeVoltage;
        this.spikeUpLimits = potentialCurve.spikeUpLimits;
        this.absoluteLimits = potentialCurve.absoluteLimits;
        this.thresholdVoltage = potentialCurve.thresholdVoltage;
        this.refractoryVoltage = potentialCurve.refractoryVoltage;
        this.valuedRefractPeriode = potentialCurve.valuedRefractPeriode;
        this.lastPoint = potentialCurve.lastPoint != null ? (Coordinate2D)potentialCurve.lastPoint.clone() : null;
        this.verticalBounds = potentialCurve.verticalBounds != null ? (Coordinate2D)potentialCurve.verticalBounds.clone() : null;
        if (this.pointsStock != null) {
            Enumeration enumeration = potentialCurve.pointsStock.elements();
            while (enumeration.hasMoreElements()) {
                this.pointsStock.addElement(enumeration.nextElement());
            }
        }
        this.curveColor = Tools.brightness(Tools.brightness(potentialCurve.curveColor, 80), 1.5);
        this.spikeColor = Tools.brightness(Tools.brightness(potentialCurve.spikeColor, 80), 1.5);
        this.refractColor = Tools.brightness(potentialCurve.refractColor, 1.5);
    }

    public void redrawAt(Graphics graphics, Screen2D screen2D) {
        int n = screen2D.scrY(this.thresholdVoltage);
        int n2 = screen2D.scrY(this.refractoryVoltage);
        int n3 = this.absoluteLimits ? screen2D.getScrMinY() + this.spikeUpLimits : screen2D.scrY(this.spikeVoltage);
        Point point = null;
        Point point2 = null;
        if (graphics != null && this.pointsStock.size() > 0) {
            int n4 = 0;
            while (n4 < this.pointsStock.size()) {
                CurveItem curveItem = (CurveItem)this.pointsStock.elementAt(n4);
                int n5 = screen2D.scrX(curveItem.point.getX());
                switch (curveItem.tag) {
                    case 3: {
                        if (this.valuedRefractPeriode) {
                            graphics.setColor(this.refractColor);
                            graphics.drawLine(n5, n, n5, n2);
                        }
                        graphics.setColor(this.spikeColor);
                        graphics.drawLine(n5, n, n5, n3);
                        break;
                    }
                    case 1: {
                        graphics.setColor(this.curveColor);
                        point = screen2D.scrPoint(curveItem.point);
                        break;
                    }
                    case 2: {
                        point2 = screen2D.scrPoint(curveItem.point);
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        point = point2;
                        break;
                    }
                }
                ++n4;
            }
        }
    }

    public void resetTime() {
        this.lastPoint = null;
        this.verticalBounds.set(0.0, 0.0);
        this.pointsStock.removeAllElements();
        this.notifyChanges();
    }

    public void setInput(RealFlowProducer realFlowProducer) {
        this.input = realFlowProducer;
    }

    public void setLimits(double d, double d2, double d3) {
        this.spikeVoltage = d3;
        this.thresholdVoltage = d;
        this.refractoryVoltage = d2;
        this.absoluteLimits = false;
        this.verticalBounds.set(d2, d);
    }

    public void setLimits(double d, double d2, int n) {
        this.spikeUpLimits = n;
        this.thresholdVoltage = d;
        this.refractoryVoltage = d2;
        this.absoluteLimits = true;
        this.verticalBounds.set(d2, d);
    }

    protected class CurveItem {
        int tag;
        Coordinate2D point;

        CurveItem() {
        }

        CurveItem(int n, Coordinate2D coordinate2D) {
            this.tag = n;
            this.point = coordinate2D;
        }
    }
}

