/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.drawable;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import spikingneuron.drawable.DisplayContext;
import spikingneuron.drawable.Drawable;
import spikingneuron.math.Screen2D;
import spikingneuron.tools.Clock;
import spikingneuron.tools.DataFlowAgent;
import spikingneuron.tools.RealFlowProducer;

public class SpikesCurve
extends Drawable
implements DataFlowAgent {
    public Color lineColor;
    public double heightLineRatio;
    protected Vector spikes;
    protected RealFlowProducer input = null;

    public SpikesCurve(Color color) {
        this.lineColor = color;
        this.spikes = new Vector(50, 10);
    }

    public void computeNextTic() {
        if (this.input != null && this.input.getRealOutput() == Double.POSITIVE_INFINITY) {
            double d = Clock.sharedInstance.getTime();
            if (this.synchronizedDisplay) {
                Enumeration enumeration = this.contexts.elements();
                while (enumeration.hasMoreElements()) {
                    DisplayContext displayContext = (DisplayContext)enumeration.nextElement();
                    Graphics graphics = displayContext.getGraphics();
                    Screen2D screen2D = displayContext.getView();
                    if (graphics == null) continue;
                    graphics.setColor(this.lineColor);
                    int n = screen2D.getScrSize().height;
                    int n2 = screen2D.getScrMinY();
                    int n3 = n2 + (int)((double)n * (1.0 - this.heightLineRatio) / 2.0);
                    int n4 = n2 + (int)((double)n * (1.0 + this.heightLineRatio) / 2.0);
                    int n5 = screen2D.scrX(d);
                    graphics.drawLine(n5, n3, n5, n4);
                }
            }
            this.spikes.addElement(new Double(d));
        }
    }

    public void redrawAt(Graphics graphics, Screen2D screen2D) {
        if (graphics != null) {
            graphics.setColor(this.lineColor);
            int n = screen2D.getScrSize().height;
            int n2 = screen2D.getScrMinY();
            int n3 = n2 + (int)((double)n * (1.0 - this.heightLineRatio) / 2.0);
            int n4 = n2 + (int)((double)n * (1.0 + this.heightLineRatio) / 2.0);
            Enumeration enumeration = this.spikes.elements();
            while (enumeration.hasMoreElements()) {
                int n5 = screen2D.scrX((Double)enumeration.nextElement());
                graphics.drawLine(n5, n3, n5, n4);
            }
        }
    }

    public void resetTime() {
        this.spikes.removeAllElements();
        this.notifyChanges();
    }

    public void setHeightLineRatio(double d) {
        this.heightLineRatio = d;
    }

    public void setInput(RealFlowProducer realFlowProducer) {
        this.input = realFlowProducer;
    }
}

