/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.generators;

import spikingneuron.generators.SignalGenerator;
import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;

public class CircularGenerator
extends SignalGenerator {
    public static final String IDENTITY = "Generateur sinusoidal";
    protected double offset;
    protected double amplitude;
    protected double pulsation;
    protected double dephasage;

    public CircularGenerator() {
        this.offset = 0.0;
        this.amplitude = 0.0;
        this.pulsation = 0.0;
        this.dephasage = 0.0;
        this.signal = this.offset;
        this.updateOutput();
    }

    public CircularGenerator(double d, double d2, double d3, double d4) {
        this.offset = d;
        this.amplitude = d2;
        this.pulsation = d3;
        this.dephasage = d4;
        this.signal = d;
        this.updateOutput();
    }

    public void computeNextTic() {
        this.signal = this.offset + this.amplitude * Math.sin(this.dephasage + Clock.sharedInstance.getTime() * this.pulsation);
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public double getDephasage() {
        return this.dephasage;
    }

    public String getIdentity() {
        return IDENTITY;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getPulsation() {
        return this.pulsation;
    }

    public Coordinate2D getRange() {
        return new Coordinate2D(this.offset - Math.abs(this.amplitude), this.offset + Math.abs(this.amplitude));
    }

    public void init(double d, double d2, double d3, double d4) {
        this.offset = d;
        this.amplitude = d2;
        this.pulsation = d3;
        this.dephasage = d4;
        this.signal = d;
        this.updateOutput();
    }

    public void resetTime() {
        this.signal = this.offset;
        this.updateOutput();
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
    }

    public void setDephasage(double d) {
        this.dephasage = d;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public void setPulsation(double d) {
        this.pulsation = d;
    }
}

