/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.generators;

import java.util.Random;
import spikingneuron.generators.SignalGenerator;
import spikingneuron.math.Coordinate2D;

public class DiscreteNoisyGenerator
extends SignalGenerator {
    public static final String IDENTITY = "Generateur de bruit discret";
    protected double offset;
    protected double amplitudeMax;
    protected long seed;
    protected Random random;
    private double amplitude2;
    private double increment;

    public DiscreteNoisyGenerator() {
        this.offset = 0.0;
        this.amplitudeMax = 0.0;
        this.seed = System.currentTimeMillis();
        this.random = new Random(this.seed);
        this.signal = this.offset;
        this.computeInternalVar();
        this.updateOutput();
    }

    public DiscreteNoisyGenerator(double d, double d2, long l) {
        this.offset = d;
        this.amplitudeMax = d2;
        this.seed = l;
        this.random = new Random(l);
        this.signal = d;
        this.computeInternalVar();
        this.updateOutput();
    }

    protected void computeInternalVar() {
        this.amplitude2 = 2.0 * this.amplitudeMax;
        this.increment = this.offset - this.amplitudeMax;
    }

    public void computeNextTic() {
        this.signal = this.random.nextDouble() * this.amplitude2 + this.increment;
    }

    public double getAmplitude() {
        return this.amplitudeMax;
    }

    public String getIdentity() {
        return IDENTITY;
    }

    public double getOffset() {
        return this.offset;
    }

    public Coordinate2D getRange() {
        return new Coordinate2D(this.offset - this.amplitudeMax, this.offset + this.amplitudeMax);
    }

    public long getSeed() {
        return this.seed;
    }

    public void resetTime() {
        this.signal = this.offset;
        this.updateOutput();
    }

    public void setAmplitude(double d) {
        this.amplitudeMax = d;
        this.computeInternalVar();
    }

    public void setOffset(double d) {
        this.offset = d;
        this.computeInternalVar();
    }

    public void setSeed(long l) {
        this.seed = l;
        this.random.setSeed(l);
    }
}

