/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.generators;

import java.util.Random;
import spikingneuron.generators.SignalGenerator;
import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;

public class NoisyGenerator
extends SignalGenerator {
    public static final String IDENTITY = "Generateur de bruit";
    protected static final double maxPulsation = 1.0E12;
    protected static final double maxAmplitude = 100.0;
    protected double offset;
    protected double amplitudeMax;
    protected double[] amplitudes;
    protected double[] pulsations;
    protected double[] dephasages;
    protected double scaleFactor = 0.0;
    protected long seed;
    protected Random random;

    public NoisyGenerator() {
        this.offset = 0.0;
        this.amplitudeMax = 0.0;
        this.seed = System.currentTimeMillis();
        this.random = new Random(this.seed);
        this.pulsations = new double[10];
        this.dephasages = new double[10];
        this.amplitudes = new double[10];
        int n = 0;
        while (n < 10) {
            this.pulsations[n] = this.random.nextDouble() * 1.0E12;
            this.dephasages[n] = this.random.nextDouble() * 2.0 * Math.PI;
            this.amplitudes[n] = this.random.nextDouble() * 100.0;
            ++n;
        }
        this.signal = this.offset;
        this.updateOutput();
    }

    public NoisyGenerator(double d, double d2, int n, long l) {
        this.offset = d;
        this.amplitudeMax = d2;
        this.seed = l;
        this.random = new Random(l);
        this.pulsations = new double[n];
        this.dephasages = new double[n];
        this.amplitudes = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.pulsations[n2] = this.random.nextDouble() * 1.0E12;
            this.dephasages[n2] = this.random.nextDouble() * 2.0 * Math.PI;
            this.amplitudes[n2] = this.random.nextDouble() * 100.0;
            ++n2;
        }
        this.signal = d;
        this.updateOutput();
    }

    protected void calculateScaleFactor() {
        double d = 0.0;
        int n = this.getNbSinus() - 1;
        while (n >= 0) {
            d += this.amplitudes[n];
            --n;
        }
        this.scaleFactor = this.amplitudeMax / d;
    }

    public void computeNextTic() {
        double d = 0.0;
        double d2 = Clock.sharedInstance.getTime();
        int n = this.getNbSinus() - 1;
        while (n >= 0) {
            d += this.amplitudes[n] * Math.sin(this.dephasages[n] + d2 * this.pulsations[n]);
            --n;
        }
        this.signal = this.offset + d * this.scaleFactor;
    }

    public double getAmplitude() {
        return this.amplitudeMax;
    }

    public String getIdentity() {
        return IDENTITY;
    }

    public int getNbSinus() {
        return this.pulsations.length;
    }

    public double getOffset() {
        return this.offset;
    }

    public Coordinate2D getRange() {
        return new Coordinate2D(this.offset - this.amplitudeMax, this.offset + this.amplitudeMax);
    }

    public long getSeed() {
        return this.seed;
    }

    public void resetTime() {
        this.calculateScaleFactor();
        this.signal = this.offset;
        this.updateOutput();
    }

    public void setAmplitude(double d) {
        this.amplitudeMax = d;
    }

    public void setNbSinus(int n) {
        this.pulsations = new double[n];
        this.dephasages = new double[n];
        this.amplitudes = new double[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            this.pulsations[n2] = this.random.nextDouble() * 1.0E12;
            this.dephasages[n2] = this.random.nextDouble() * 2.0 * Math.PI;
            this.amplitudes[n2] = this.random.nextDouble() * 100.0;
            --n2;
        }
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public void setSeed(long l) {
        this.seed = l;
        this.random.setSeed(l);
        int n = this.getNbSinus() - 1;
        while (n >= 0) {
            this.pulsations[n] = this.random.nextDouble() * 1.0E12;
            this.dephasages[n] = this.random.nextDouble() * 2.0 * Math.PI;
            this.amplitudes[n] = this.random.nextDouble() * 100.0;
            --n;
        }
    }
}

