/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.generators;

import spikingneuron.generators.SignalGenerator;
import spikingneuron.math.Coordinate2D;
import spikingneuron.tools.Clock;

public class PulsesGenerator
extends SignalGenerator {
    public static final String IDENTITY = "Pulses Generator";
    protected int nbPulses;
    protected double offset;
    protected int pulseWidth;
    protected double pulseAmplitude;
    protected boolean withPulseCount;
    protected double deltaT;
    private boolean initialized;
    private double nextPulse;
    private int tics;

    public PulsesGenerator() {
        this.withPulseCount = false;
        this.offset = 0.0;
        this.nbPulses = 0;
        this.pulseWidth = 0;
        this.pulseAmplitude = 0.0;
        this.signal = this.offset;
        this.updateOutput();
        this.initialized = false;
        this.deltaT = 0.0;
        this.nextPulse = 0.0;
        this.tics = 0;
    }

    public PulsesGenerator(double d, double d2, double d3, int n) {
        this.offset = d;
        this.pulseWidth = n;
        this.pulseAmplitude = d3;
        this.signal = this.offset;
        this.updateOutput();
        this.initialized = false;
        this.deltaT = d2;
        this.nbPulses = 0;
        this.nextPulse = 0.0;
        n = 0;
        this.withPulseCount = false;
    }

    public PulsesGenerator(double d, int n, double d2, int n2) {
        this.offset = d;
        this.nbPulses = n;
        this.pulseWidth = n2;
        this.pulseAmplitude = d2;
        this.signal = this.offset;
        this.updateOutput();
        this.initialized = false;
        this.deltaT = 0.0;
        this.nextPulse = 0.0;
        n2 = 0;
        this.withPulseCount = true;
    }

    public void computeNextTic() {
        double d = Clock.sharedInstance.getTime();
        if (!this.initialized) {
            this.initialized = true;
            this.tics = 0;
            if (this.withPulseCount) {
                this.deltaT = Clock.sharedInstance.getDuration() / (double)this.nbPulses;
                this.nextPulse += this.deltaT / 2.0;
            } else {
                this.nextPulse += this.deltaT;
            }
            this.signal = this.offset;
        }
        if (this.tics > 0) {
            --this.tics;
            if (this.tics == 0) {
                this.signal = this.offset;
            }
        }
        if (d >= this.nextPulse) {
            this.nextPulse = d + this.deltaT;
            this.tics = this.pulseWidth;
            this.signal = this.offset + this.pulseAmplitude;
        }
    }

    public double getDeltaPulses() {
        return this.deltaT;
    }

    public String getIdentity() {
        return IDENTITY;
    }

    public int getNbPulses() {
        return this.nbPulses;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getPulseAmplitude() {
        return this.pulseAmplitude;
    }

    public int getPulseWidth() {
        return this.pulseWidth;
    }

    public Coordinate2D getRange() {
        return new Coordinate2D(Math.min(this.offset, this.offset + this.pulseAmplitude), Math.max(this.offset, this.offset + this.pulseAmplitude));
    }

    public boolean isNbPulsesFix() {
        return this.withPulseCount;
    }

    public void resetTime() {
        this.signal = this.offset;
        this.updateOutput();
        this.tics = 0;
        this.nextPulse = Clock.sharedInstance.getInitialTime();
        this.initialized = false;
    }

    public void setNbPulses(int n) {
        this.nbPulses = n;
        this.withPulseCount = true;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public void setPulseAmplitude(double d) {
        this.pulseAmplitude = d;
    }

    public void setPulseWidth(int n) {
        this.pulseWidth = n;
    }

    public void setPulsesDelta(double d) {
        this.deltaT = d;
        this.withPulseCount = false;
    }
}

