/*
 * Decompiled with CFR 0.152.
 */
package spikingneuron.generators;

import spikingneuron.generators.SignalGenerator;
import spikingneuron.math.Coordinate2D;
import spikingneuron.math.RandomDistribution;
import spikingneuron.tools.Clock;

public class RandomPulsesGenerator
extends SignalGenerator {
    public static final String IDENTITY = "Random Pulses Generator";
    protected double offset;
    protected double lambda;
    protected int pulseWidth;
    protected double pulseAmplitude;
    protected long seed;
    protected RandomDistribution random;
    private double nextPulse;
    private int tics;

    public RandomPulsesGenerator() {
        this.seed = System.currentTimeMillis();
        this.random = new RandomDistribution(this.seed);
        this.offset = 0.0;
        this.lambda = 0.0;
        this.pulseWidth = 0;
        this.pulseAmplitude = 0.0;
        this.signal = this.offset;
        this.updateOutput();
        this.nextPulse = 0.0;
        this.tics = 0;
    }

    public RandomPulsesGenerator(double d, double d2, double d3, int n, long l) {
        this.offset = d;
        this.lambda = d2;
        this.pulseWidth = n;
        this.pulseAmplitude = d3;
        this.seed = l;
        this.random = new RandomDistribution(l);
        this.signal = this.offset;
        this.updateOutput();
        this.nextPulse = 0.0;
        n = 0;
    }

    public void computeNextTic() {
        double d = Clock.sharedInstance.getTime();
        if (this.tics > 0) {
            --this.tics;
            if (this.tics == 0) {
                this.signal = this.offset;
            }
        }
        if (d >= this.nextPulse) {
            this.nextPulse = d + this.random.nextExponential(this.lambda);
            this.tics = this.pulseWidth;
            this.signal = this.offset + this.pulseAmplitude;
        }
    }

    public String getIdentity() {
        return IDENTITY;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getPulseAmplitude() {
        return this.pulseAmplitude;
    }

    public int getPulseWidth() {
        return this.pulseWidth;
    }

    public Coordinate2D getRange() {
        return new Coordinate2D(Math.min(this.offset, this.offset + this.pulseAmplitude), Math.max(this.offset, this.offset + this.pulseAmplitude));
    }

    public long getSeed() {
        return this.seed;
    }

    public void resetTime() {
        this.random.setSeed(this.seed);
        this.signal = this.offset;
        this.updateOutput();
        this.tics = 0;
        this.nextPulse = Clock.sharedInstance.getInitialTime() + this.random.nextExponential(this.lambda);
    }

    public void setLambda(double d) {
        this.lambda = d;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public void setPulseAmplitude(double d) {
        this.pulseAmplitude = d;
    }

    public void setPulseWidth(int n) {
        this.pulseWidth = n;
    }

    public void setSeed(long l) {
        this.seed = l;
        this.random.setSeed(l);
    }
}

